/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.hproxy.sandbox.hive.common;

import com.dataiku.hproxy.model.hive.ColumnSchema;
import com.dataiku.hproxy.sandbox.hive.common.MiniTransmogrifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class HiveColumnsUnprefixer {
    private static Logger logger = Logger.getLogger((String)"dku.hive.unprefixer");

    public static void unprefix(List<ColumnSchema> columns) {
        ArrayList<String> origTables = new ArrayList<String>();
        HashSet<String> alreadyAttributedNames = new HashSet<String>();
        MiniTransmogrifier st = new MiniTransmogrifier();
        for (ColumnSchema col : columns) {
            String table = null;
            Object columnNameWithoutTable = col.name;
            if (col.name.contains(".")) {
                Object[] chunks = col.name.split("\\.");
                table = StringUtils.join((Object[])ArrayUtils.subarray((Object[])chunks, (int)0, (int)(chunks.length - 1)), (String)".");
                logger.info((Object)("Had table in " + col.name));
                columnNameWithoutTable = chunks[chunks.length - 1];
                logger.info((Object)("tbale= " + table + " colname=" + col.name));
            }
            origTables.add(table);
            if (alreadyAttributedNames.contains(columnNameWithoutTable) && table != null) {
                logger.info((Object)"Conflict, put back the column");
                col.name = table + "_" + (String)columnNameWithoutTable;
            }
            alreadyAttributedNames.add((String)columnNameWithoutTable);
            col.name = st.transmogrify((String)columnNameWithoutTable);
            logger.info((Object)("Transmogrified to  " + col.name));
        }
    }
}

