/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.visitor.ExpressionTypeVisitor;
import org.geotools.filter.visitor.MultiRange;
import org.geotools.util.Range;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.BinaryLogicOperator;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;

abstract class RangeCombiner {
    ExpressionTypeVisitor expressionTypeVisitor;
    Map<Expression, MultiRange> rangeMap = new HashMap<Expression, MultiRange>();
    FeatureType featureType;
    List<Filter> otherFilters = new ArrayList<Filter>();
    List<Filter> filters;
    FilterFactory2 ff;

    public RangeCombiner(FilterFactory2 ff, FeatureType featureType, List<Filter> filters) {
        this.ff = ff;
        this.filters = filters;
        this.featureType = featureType;
        this.expressionTypeVisitor = new ExpressionTypeVisitor(featureType);
        for (Filter f : filters) {
            if (f instanceof PropertyIsBetween) {
                PropertyIsBetween pb = (PropertyIsBetween)f;
                Class binding = this.getTypeIfComparable(pb.getExpression());
                if (binding == null) {
                    this.otherFilters.add((Filter)pb);
                    continue;
                }
                Object min = this.evaluate(pb.getLowerBoundary(), binding);
                Object max = this.evaluate(pb.getUpperBoundary(), binding);
                if (min == null || max == null) {
                    this.otherFilters.add(f);
                    continue;
                }
                Expression expression = pb.getExpression();
                Range range = new Range(binding, (Comparable)min, (Comparable)max);
                this.addRange(this.rangeMap, expression, new MultiRange(range));
                continue;
            }
            if (f instanceof PropertyIsNotEqualTo) {
                PropertyIsNotEqualTo ne = (PropertyIsNotEqualTo)f;
                Comparable exclusion = null;
                Expression expression = null;
                Class binding = this.getTypeIfComparable(ne.getExpression1());
                if (binding != null) {
                    expression = ne.getExpression1();
                    if (binding != null) {
                        exclusion = (Comparable)this.evaluate(ne.getExpression2(), binding);
                    }
                } else {
                    expression = ne.getExpression2();
                    binding = this.getTypeIfComparable(ne.getExpression2());
                    if (binding != null) {
                        exclusion = (Comparable)this.evaluate(ne.getExpression1(), binding);
                    }
                }
                if (exclusion != null) {
                    this.addRange(this.rangeMap, expression, new MultiRange<Comparable>(binding, exclusion));
                    continue;
                }
                this.otherFilters.add(f);
                continue;
            }
            if (f instanceof BinaryComparisonOperator) {
                BinaryComparisonOperator op = (BinaryComparisonOperator)f;
                ExpressionRange er = this.getRange(op);
                if (er.range != null && (!(op instanceof PropertyIsEqualTo) || op.isMatchingCase())) {
                    this.addRange(this.rangeMap, er.expression, new MultiRange(er.range));
                    continue;
                }
                this.otherFilters.add(f);
                continue;
            }
            if (f instanceof org.opengis.filter.And || f instanceof org.opengis.filter.Or) {
                BinaryLogicOperator logic = (BinaryLogicOperator)f;
                List children = logic.getChildren();
                RangeCombiner subCombiner = logic instanceof org.opengis.filter.And ? new And(ff, featureType, children) : new Or(ff, featureType, children);
                if (!subCombiner.otherFilters.isEmpty() || subCombiner.rangeMap.size() > 1 && !subCombiner.getClass().equals(this.getClass())) {
                    this.otherFilters.add(f);
                    continue;
                }
                Map<Expression, MultiRange> combined = subCombiner.rangeMap;
                for (Map.Entry<Expression, MultiRange> entry : combined.entrySet()) {
                    Expression ex = entry.getKey();
                    MultiRange ranges = entry.getValue();
                    this.addRange(this.rangeMap, ex, ranges);
                }
                continue;
            }
            this.otherFilters.add(f);
        }
    }

    private ExpressionRange getRange(BinaryComparisonOperator op) {
        Object value;
        Class binding;
        Range range = null;
        Expression expression = null;
        if (!this.isStatic(op.getExpression1())) {
            Object value2;
            expression = op.getExpression1();
            Class binding2 = this.getTypeIfComparable(expression);
            if (binding2 != null && (value2 = this.evaluate(op.getExpression2(), binding2)) != null) {
                if (op instanceof PropertyIsLessThan) {
                    range = new Range(binding2, null, false, (Comparable)value2, false);
                } else if (op instanceof PropertyIsLessThanOrEqualTo) {
                    range = new Range(binding2, null, false, (Comparable)value2, true);
                } else if (op instanceof PropertyIsEqualTo) {
                    range = new Range(binding2, (Comparable)value2, (Comparable)value2);
                } else if (op instanceof PropertyIsGreaterThanOrEqualTo) {
                    range = new Range(binding2, (Comparable)value2, true, null, false);
                } else if (op instanceof PropertyIsGreaterThan) {
                    range = new Range(binding2, (Comparable)value2, false, null, false);
                }
            }
        } else if (!this.isStatic(op.getExpression2()) && (binding = this.getTypeIfComparable(expression = op.getExpression2())) != null && (value = this.evaluate(op.getExpression1(), binding)) != null) {
            if (op instanceof PropertyIsLessThan) {
                range = new Range(binding, (Comparable)value, true, null, false);
            } else if (op instanceof PropertyIsLessThanOrEqualTo) {
                range = new Range(binding, (Comparable)value, false, null, false);
            } else if (op instanceof PropertyIsEqualTo) {
                range = new Range(binding, (Comparable)value, (Comparable)value);
            } else if (op instanceof PropertyIsGreaterThanOrEqualTo) {
                range = new Range(binding, null, false, (Comparable)value, false);
            } else if (op instanceof PropertyIsGreaterThan) {
                range = new Range(binding, null, false, (Comparable)value, true);
            }
        }
        return new ExpressionRange(expression, range);
    }

    private boolean isStatic(Expression exp) {
        FilterAttributeExtractor attributeExtractor = new FilterAttributeExtractor();
        exp.accept((ExpressionVisitor)attributeExtractor, null);
        return attributeExtractor.getAttributeNameSet().isEmpty();
    }

    private Class getTypeIfComparable(Expression ex) {
        Class type = (Class)ex.accept((ExpressionVisitor)this.expressionTypeVisitor, null);
        if (Comparable.class.isAssignableFrom(type)) {
            return type;
        }
        return null;
    }

    String getPropertyName(Expression ex) {
        if (ex instanceof PropertyName) {
            PropertyName pn = (PropertyName)ex;
            return pn.getPropertyName();
        }
        return null;
    }

    public List<Filter> getReducedFilters() {
        if (this.rangeMap.isEmpty()) {
            return this.filters;
        }
        ArrayList<Filter> result = new ArrayList<Filter>(this.otherFilters);
        for (Expression ex : new ArrayList<Expression>(this.rangeMap.keySet())) {
            MultiRange multiRange = this.rangeMap.get(ex);
            this.addFiltersToResults(result, multiRange.toFilter((FilterFactory)this.ff, ex));
        }
        return result;
    }

    protected abstract void addFiltersToResults(List<Filter> var1, Filter var2);

    protected abstract <T extends Comparable<T>> MultiRange<T> combineRanges(MultiRange<T> var1, MultiRange<T> var2);

    private void addRange(Map<Expression, MultiRange> rangeMap, Expression expression, MultiRange other) {
        MultiRange ranges = rangeMap.get(expression);
        if (ranges == null) {
            rangeMap.put(expression, other);
        } else {
            MultiRange combined = this.combineRanges(ranges, other);
            rangeMap.put(expression, combined);
        }
    }

    private <T> T evaluate(Expression ex, Class<T> target) {
        return (T)(ex instanceof Literal ? ex.evaluate(null, target) : null);
    }

    static class CombinationResult {
        Map<Expression, List<FilterRange>> rangeMap;
        boolean combinationHappened;

        public CombinationResult(Map<Expression, List<FilterRange>> rangeMap, boolean combinationHappened) {
            this.rangeMap = rangeMap;
            this.combinationHappened = combinationHappened;
        }
    }

    static class ExpressionRange {
        Expression expression;
        Range range;

        public ExpressionRange(Expression expression, Range range) {
            this.expression = expression;
            this.range = range;
        }
    }

    static class FilterRange {
        Filter filter;
        Range range;

        public FilterRange(Filter filter, Range range) {
            this.filter = filter;
            this.range = range;
        }
    }

    static class And
    extends RangeCombiner {
        public And(FilterFactory2 ff, FeatureType featureType, List<Filter> filters) {
            super(ff, featureType, filters);
        }

        @Override
        protected <T extends Comparable<T>> MultiRange<T> combineRanges(MultiRange<T> r1, MultiRange<T> r2) {
            return r1.intersect(r2);
        }

        @Override
        protected void addFiltersToResults(List<Filter> results, Filter filter) {
            if (filter instanceof org.opengis.filter.And) {
                results.addAll(((org.opengis.filter.And)filter).getChildren());
            } else {
                results.add(filter);
            }
        }
    }

    static class Or
    extends RangeCombiner {
        public Or(FilterFactory2 ff, FeatureType featureType, List<Filter> filters) {
            super(ff, featureType, filters);
        }

        @Override
        protected <T extends Comparable<T>> MultiRange<T> combineRanges(MultiRange<T> r1, MultiRange<T> r2) {
            return r1.merge(r2);
        }

        @Override
        protected void addFiltersToResults(List<Filter> results, Filter filter) {
            if (filter instanceof org.opengis.filter.Or) {
                results.addAll(((org.opengis.filter.Or)filter).getChildren());
            } else {
                results.add(filter);
            }
        }
    }
}

