#' Get the paths of the files of a managed folder.
#'
#' It the managed folder is partitioned, you can pass a partition identifier
#'
#' @param name the identifier of the managed folder
#' @param partition The partition identifier. If given, only the paths of this partition will
#' be returned. If not given, all paths in the managed folder are returned.
#' @return The paths within the managed folder of the files (either all or files matching the partition)
#'
#' @export
#' @importFrom httr POST
dkuManagedFolderPartitionPaths <- function(name, partition=NULL) {
    getPathURL = dku_intercom__get_jek_or_backend_url("/managed-folders/get-partition-paths")
    ref = dku__resolve_smart_name(name)

    resp = POST(getPathURL,body = list(projectKey=dku__ref_to_pkey(ref), lookup=dku__ref_to_name(ref), partition=partition),
        encode="form",  dku__get_auth_headers(), dku_intercom__get_httr_config())

    dku__check_api_error(resp, "Failed to get Box path")
    data <- content(resp)

    return(data$info$paths)
}
