#' Randomly samples a fixed number of rows from a dataset
#'
#' @param nbrows number of rows
#'
#' @details
#'
#' Users should call this function via dkuReadDataset
#'
#' @examples
#' \dontrun{
#' # read 100 rows from the iris dataset
#' dkuReadDataset("iris", samplingMethod="fixed", nbrow=100)
#' }

fixed.sampling <- function(nbrows) {
    if(!is.numeric(nbrows) || nbrows%%1 != 0 || nbrows<0) {
        stop(paste0("Invalid number of rows: ",nbrows))
    }
    sampling <- {}
    sampling$samplingMethod <- "RANDOM_FIXED_NB"
    sampling$maxRecords <- nbrows
    return(sampling)
}
