(function() {
    'use strict';

    angular.module('dataiku.savedmodels').factory('SavedModelRenameService', renameService);

    function renameService(DataikuAPI, CreateModalFromTemplate) {
        function renameSavedModel({
            scope,
            state,
            projectKey,
            savedModelId,
            savedModelName,
            onSave = () => {}
        }) {
            CreateModalFromTemplate(
                "/templates/taggable-objects/rename-modal.html",
                scope,
                null,
                (newScope) => {
                    newScope.objectName = savedModelName;
                    newScope.uiState = { newName: savedModelName };

                    newScope.go = () => {
                        const newName = newScope.uiState.newName;
                        DataikuAPI.savedmodels.rename(projectKey, savedModelId, newName).then(() => {
                            newScope.dismiss();
                            onSave(newName);
                            state.reload();
                        }, setErrorInScope.bind(newScope));
                    }
                });
        }

        return { renameSavedModel };
    }
})();
