(function(){
    'use strict';

    const cellValuePopupComponent = {
        bindings : {
            cellValue : "<",
            sanitizedHtmlContent : "<",
            searchValue: "=",
            highlightTagName: "<",
            columnMeaning: "<",
            popupContainer: "="
            }, 
            templateUrl: "/static/dataiku/shared/components/cell-value-popup-component/cell-value-popup.component.html",
            controller: function($element, ClipboardUtils, $timeout) {
                const $ctrl = this;
                
                $ctrl.$onInit = () => {
                    if (["GeometryMeaning", "BagOfWordsMeaning", "JSONObjectMeaning", "JSONArrayMeaning"].indexOf($ctrl.columnMeaning) >= 0 && isNaN(parseInt($ctrl.cellValue))) {
                        try {
                            
                            $ctrl.jsonValue = JSON.parse($ctrl.cellValue);
                            
                            $ctrl.jsonDetails = {};
                            
                            if ($ctrl.jsonValue.constructor === Array) {
                                $ctrl.jsonDetails.type = "array";
                                $ctrl.jsonDetails.length = $ctrl.jsonValue.length;
                                $ctrl.jsonDetails.strLength = $ctrl.cellValue.length;
                            } else if (typeof($ctrl.jsonValue) === "object") {
                                $ctrl.jsonDetails.type = "object";
                                $ctrl.jsonDetails.nbKeys = Object.keys($ctrl.jsonValue).length;
                                $ctrl.jsonDetails.strLength = $ctrl.cellValue.length;
                            }
                            $ctrl.jsonEnabled = true;
                        } catch (e) { /* Nothing for now */ }
                    } else {
                        $ctrl.jsonEnabled = false;
                    }
                    
                    $ctrl.copyCellValue = function()  {
                        ClipboardUtils.copyToClipboard($ctrl.cellValue, `Copied to clipboard.`);
                    }
                    
                    $ctrl.selection = null;
                    if ($ctrl.searchValue) { // activate selection if it can be searched on
                        $element.mouseup(function(evt) {
                            if ($ctrl.selection) {
                                window.getSelection().removeAllRanges();
                            }
                            evt.stopPropagation();
                            const selection = getSelectionInElement($element.find("#shaker-cell-complete-value-content")[0], $ctrl.highlightTagName);
                            $timeout(() => { // Make the text appear when set
                                $ctrl.selection = selection;
                            });
                        });
                    }
                    
                }
    
                // bindings are not properly set now so we CAN'T just do: $ctrl.$postLink = $ctrl.popup.onPopupCreated
                $ctrl.$postLink = () => $ctrl.popupContainer.onPopupCreated();
            }
        }

    angular.module('dataiku.shared').component('cellValuePopupComponent', cellValuePopupComponent);
})();