# Python<->Java mapping
from typing import TypedDict, TYPE_CHECKING
from typing_extensions import Literal

if TYPE_CHECKING:
    from generated_sources.com.dataiku.dip.llm.io.commands.process_single_embedding_command.process_single_embedding_command import ProcessSingleEmbeddingCommand
    from generated_sources.com.dataiku.dip.llm.io.commands.process_single_image_generation_command.process_single_image_generation_command import ProcessSingleImageGenerationCommand
    from generated_sources.com.dataiku.dip.llm.io.commands.process_single_prompt_command.process_single_prompt_command import ProcessSinglePromptCommand
    from generated_sources.com.dataiku.dip.llm.llm_structured_ref.llm_structured_ref import LLMStructuredRef
    from generated_sources.com.dataiku.dip.llm.online.llm_client.completion_settings import CompletionSettings
    from generated_sources.com.dataiku.dip.llm.online.llm_client.llm_error_type import LLMErrorType
    from generated_sources.com.dataiku.dip.llm.online.llm_client.image_generation_prompt import ImageGenerationPrompt
    from generated_sources.com.dataiku.dip.llm.online.llm_client.simple_completion_response import SimpleCompletionResponse
    from generated_sources.com.dataiku.dip.llm.online.llm_client.simple_completion_response_or_error import SimpleCompletionResponseOrError
    from generated_sources.com.dataiku.dip.llm.online.llm_client.source import Source
    from generated_sources.com.dataiku.dip.llm.online.llm_client.source_item import SourceItem
    from generated_sources.com.dataiku.dip.llm.online.llm_client.file_ref import FileRef
    from generated_sources.com.dataiku.dip.llm.retrieval.ragllm_settings.faithfulness_settings import FaithfulnessSettings
    from generated_sources.com.dataiku.dip.llm.retrieval.ragllm_settings.below_threshold_handling import BelowThresholdHandling
    from generated_sources.com.dataiku.dip.llm.retrieval.ragllm_settings.guardrails_settings import GuardrailsSettings
    from generated_sources.com.dataiku.dip.llm.retrieval.ragllm_settings.search_input_strategy import SearchInputStrategy
    from generated_sources.com.dataiku.dip.agents.tools.vectorstore.vector_store_query_tool.vector_store_query_tool_params import VectorStoreQueryToolParams
    from generated_sources.com.dataiku.dip.llm.retrieval.base_vector_store_query_settings.base_vector_store_query_settings import BaseVectorStoreQuerySettings
    from generated_sources.com.dataiku.dip.llm.retrieval.base_vector_store_query_settings.sources_settings import SourcesSettings
    from generated_sources.com.dataiku.dip.llm.online.llm_client.image_ref import ImageRef
    from generated_sources.com.dataiku.dip.llm.online.llm_client.file_ref import FileRef
    from generated_sources.com.dataiku.dip.llm.retrieval.ragllm_settings.ragllm_settings import RAGLLMSettings
    from generated_sources.com.dataiku.dip.llm.retrieval.base_vector_store_query_settings.search_type import SearchType
    from generated_sources.com.dataiku.dip.llm.retrieval.retrievable_knowledge.retrievable_knowledge import RetrievableKnowledge
    from generated_sources.com.dataiku.dip.llm.retrieval.ragllm_settings.relevancy_settings import RelevancySettings
    from generated_sources.com.dataiku.dip.llm.pii.presidio_based_pii_handling_server.process_completion_response_command import ProcessCompletionResponseCommand
    from generated_sources.com.dataiku.dip.dataflow.exec.filter.filter_desc.filter_desc import FilterDesc
    from generated_sources.com.dataiku.dip.server.intercom.t.retrievable_knowledge_intercom_controller.trusted_object import TrustedObject
else:
    class Source(TypedDict):
        pass

    class SourceItem(TypedDict):
        pass

    class FileRef(TypedDict):
        pass

    class SimpleCompletionResponseOrError(TypedDict):
        pass

    class CompletionSettings(TypedDict):
        pass

    class ImageGenerationPrompt(TypedDict):
        pass

    class ProcessCompletionResponseCommand(TypedDict):
        pass

    class ProcessSingleEmbeddingCommand(TypedDict):
        pass

    class ProcessSingleImageGenerationCommand(TypedDict):
        pass

    class ProcessSinglePromptCommand(TypedDict):
        pass

    class FaithfulnessSettings(TypedDict):
        pass

    class RAGLLMSettings(TypedDict):
        pass

    class RelevancySettings(TypedDict):
        pass

    class GuardrailsSettings(TypedDict):
        pass

    class VectorStoreQueryToolParams(TypedDict):
        pass

    class BaseVectorStoreQuerySettings(TypedDict):
        pass

    class SourcesSettings(TypedDict):
        pass

    class ImageRef(TypedDict):
        pass

    class FilterDesc(TypedDict):
        pass

    class RetrievableKnowledge(TypedDict):
        pass

    class LLMStructuredRef(TypedDict):
        pass

    class TrustedObject(TypedDict):
        pass

    BelowThresholdHandling = Literal[
        'FAIL',
        'OVERWRITE_ANSWER',
    ]

    LLMErrorType = Literal[
        'REFUSAL', # The error came up from an LLM decision to refuse the ouput
        'ERROR', # Error while processing the LLM request
    ]

    SearchInputStrategy = Literal[
        'RAW_QUERY',      # we should embed the full query
        'REWRITE_QUERY',  # we should rewrite the query before embedding it
    ]

    SearchType = Literal[
        'SIMILARITY',
        'SIMILARITY_THRESHOLD',
        'MMR',
        'HYBRID',
    ]
