import dataiku
from dataiku.llm.agent_tools import BaseAgentTool

class MyAgentTool(BaseAgentTool):
    """An empty interface for a code-based agent tool"""

    def __init__(self):
        pass

    def get_descriptor(self, tool):
        """
        Returns the descriptor of the tool, as a dict containing:
           - description (str)
           - inputSchema (dict, a JSON Schema representation)
        """
        return {
            "description": "",
            "inputSchema" : {
                "$id": "",
                "title": "",
                "type": "object",
                "properties": {},
                "required": []
            }
        }


    def invoke(self, input, trace):
        """
        Invokes the tool.

        The arguments of the tool invocation are in input["input"], a dict
        """
        return {
            "output": "",
            "sources": [],
        }
