/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.spnego;

import net.sourceforge.spnego.Base64;

final class SpnegoAuthScheme {
    private static final transient byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final transient String scheme;
    private final transient String token;
    private final transient boolean basicScheme;
    private final transient boolean negotiateScheme;
    private final transient boolean ntlm;

    SpnegoAuthScheme(String authScheme, String authToken) {
        this.scheme = authScheme;
        this.token = authToken;
        this.ntlm = null == authToken || authToken.isBlank() ? false : authToken.startsWith("TlRMTVNT");
        this.negotiateScheme = "Negotiate".equalsIgnoreCase(authScheme);
        this.basicScheme = "Basic".equalsIgnoreCase(authScheme);
    }

    boolean isBasicScheme() {
        return this.basicScheme;
    }

    boolean isNegotiateScheme() {
        return this.negotiateScheme;
    }

    boolean isNtlmToken() {
        return this.ntlm;
    }

    String getScheme() {
        return this.scheme;
    }

    byte[] getToken() {
        return null == this.token ? EMPTY_BYTE_ARRAY : Base64.decode(this.token);
    }
}

