/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk;

import com.dataiku.dss.shadelib.com.nimbusds.common.contenttype.ContentType;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.ErrorObject;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.ErrorResponse;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.OAuth2Error;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.ParseException;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.TokenResponse;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.dataiku.dss.shadelib.net.jcip.annotations.Immutable;
import com.dataiku.dss.shadelib.net.minidev.json.JSONObject;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@Immutable
public class TokenErrorResponse
extends TokenResponse
implements ErrorResponse {
    private static final Set<ErrorObject> STANDARD_ERRORS;
    private final ErrorObject error;

    public static Set<ErrorObject> getStandardErrors() {
        return STANDARD_ERRORS;
    }

    protected TokenErrorResponse() {
        this.error = null;
    }

    public TokenErrorResponse(ErrorObject error) {
        this.error = Objects.requireNonNull(error);
    }

    @Override
    public boolean indicatesSuccess() {
        return false;
    }

    @Override
    public ErrorObject getErrorObject() {
        return this.error;
    }

    public JSONObject toJSONObject() {
        JSONObject o = new JSONObject();
        if (this.error == null) {
            return o;
        }
        o.putAll(this.error.toJSONObject());
        return o;
    }

    @Override
    public HTTPResponse toHTTPResponse() {
        int statusCode = this.error != null && this.error.getHTTPStatusCode() > 0 ? this.error.getHTTPStatusCode() : 400;
        HTTPResponse httpResponse = new HTTPResponse(statusCode);
        if (this.error == null) {
            return httpResponse;
        }
        httpResponse.setEntityContentType(ContentType.APPLICATION_JSON);
        httpResponse.setCacheControl("no-store");
        httpResponse.setPragma("no-cache");
        httpResponse.setBody(this.toJSONObject().toString());
        return httpResponse;
    }

    public static TokenErrorResponse parse(JSONObject jsonObject) throws ParseException {
        if (!jsonObject.containsKey("error")) {
            return new TokenErrorResponse();
        }
        ErrorObject error = ErrorObject.parse(jsonObject).setHTTPStatusCode(400);
        return new TokenErrorResponse(error);
    }

    public static TokenErrorResponse parse(HTTPResponse httpResponse) throws ParseException {
        httpResponse.ensureStatusCodeNotOK();
        return new TokenErrorResponse(ErrorObject.parse(httpResponse));
    }

    static {
        HashSet<ErrorObject> errors = new HashSet<ErrorObject>();
        errors.add(OAuth2Error.INVALID_REQUEST);
        errors.add(OAuth2Error.INVALID_CLIENT);
        errors.add(OAuth2Error.INVALID_GRANT);
        errors.add(OAuth2Error.UNAUTHORIZED_CLIENT);
        errors.add(OAuth2Error.UNSUPPORTED_GRANT_TYPE);
        errors.add(OAuth2Error.INVALID_SCOPE);
        STANDARD_ERRORS = Collections.unmodifiableSet(errors);
    }
}

