/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.commons.configuration2;

import com.dataiku.dss.shadelib.org.apache.commons.configuration2.AbstractConfiguration;
import com.dataiku.dss.shadelib.org.apache.commons.configuration2.Configuration;
import com.dataiku.dss.shadelib.org.apache.commons.configuration2.ConfigurationMap;
import com.dataiku.dss.shadelib.org.apache.commons.configuration2.ImmutableConfiguration;
import com.dataiku.dss.shadelib.org.apache.commons.configuration2.MapConfiguration;
import com.dataiku.dss.shadelib.org.apache.commons.configuration2.convert.ListDelimiterHandler;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.StringUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public final class ConfigurationConverter {
    private static final char DEFAULT_SEPARATOR = ',';

    public static Configuration getConfiguration(Properties props) {
        return new MapConfiguration(props);
    }

    public static Map<Object, Object> getMap(Configuration config) {
        return new ConfigurationMap(config);
    }

    public static Properties getProperties(Configuration config) {
        return ConfigurationConverter.getProperties((ImmutableConfiguration)config);
    }

    public static Properties getProperties(ImmutableConfiguration config) {
        boolean useDelimiterHandler;
        ListDelimiterHandler listHandler;
        Properties props = new Properties();
        if (config instanceof AbstractConfiguration) {
            listHandler = ((AbstractConfiguration)config).getListDelimiterHandler();
            useDelimiterHandler = true;
        } else {
            listHandler = null;
            useDelimiterHandler = false;
        }
        Iterator<String> keys2 = config.getKeys();
        while (keys2.hasNext()) {
            String propValue;
            String key = keys2.next();
            List<Object> list = config.getList(key);
            if (useDelimiterHandler) {
                try {
                    propValue = String.valueOf(listHandler.escapeList(list, ListDelimiterHandler.NOOP_TRANSFORMER));
                }
                catch (Exception ex) {
                    useDelimiterHandler = false;
                    propValue = ConfigurationConverter.listToString(list);
                }
            } else {
                propValue = ConfigurationConverter.listToString(list);
            }
            props.setProperty(key, propValue);
        }
        return props;
    }

    private static String listToString(List<?> list) {
        return StringUtils.join(list, ',');
    }

    private ConfigurationConverter() {
    }
}

