/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.queries.function.valuesource;

import com.dataiku.dss.shadelib.org.apache.lucene.queries.function.FunctionValues;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.function.ValueSource;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.function.valuesource.MultiFloatFunction;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.function.valuesource.MultiFunction;
import java.io.IOException;

public class MaxFloatFunction
extends MultiFloatFunction {
    public MaxFloatFunction(ValueSource[] sources) {
        super(sources);
    }

    @Override
    protected String name() {
        return "max";
    }

    @Override
    protected float func(int doc, FunctionValues[] valsArr) throws IOException {
        boolean noneFound = true;
        float val = Float.NEGATIVE_INFINITY;
        for (FunctionValues vals : valsArr) {
            if (!vals.exists(doc)) continue;
            noneFound = false;
            val = Math.max(vals.floatVal(doc), val);
        }
        if (noneFound) {
            return 0.0f;
        }
        return val;
    }

    @Override
    protected boolean exists(int doc, FunctionValues[] valsArr) throws IOException {
        return MultiFunction.anyExists(doc, valsArr);
    }
}

