/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.sandbox.codecs.idversion;

import com.dataiku.dss.shadelib.org.apache.lucene.codecs.FieldsConsumer;
import com.dataiku.dss.shadelib.org.apache.lucene.codecs.FieldsProducer;
import com.dataiku.dss.shadelib.org.apache.lucene.codecs.PostingsFormat;
import com.dataiku.dss.shadelib.org.apache.lucene.codecs.lucene90.blocktree.Lucene90BlockTreeTermsWriter;
import com.dataiku.dss.shadelib.org.apache.lucene.index.SegmentReadState;
import com.dataiku.dss.shadelib.org.apache.lucene.index.SegmentWriteState;
import com.dataiku.dss.shadelib.org.apache.lucene.sandbox.codecs.idversion.IDVersionPostingsReader;
import com.dataiku.dss.shadelib.org.apache.lucene.sandbox.codecs.idversion.IDVersionPostingsWriter;
import com.dataiku.dss.shadelib.org.apache.lucene.sandbox.codecs.idversion.VersionBlockTreeTermsReader;
import com.dataiku.dss.shadelib.org.apache.lucene.sandbox.codecs.idversion.VersionBlockTreeTermsWriter;
import com.dataiku.dss.shadelib.org.apache.lucene.util.BitUtil;
import com.dataiku.dss.shadelib.org.apache.lucene.util.BytesRef;
import com.dataiku.dss.shadelib.org.apache.lucene.util.IOUtils;
import java.io.IOException;

public class IDVersionPostingsFormat
extends PostingsFormat {
    public static final long MIN_VERSION = 0L;
    public static final long MAX_VERSION = 0x3FFFFFFFFFFFFFFFL;
    private final int minTermsInBlock;
    private final int maxTermsInBlock;

    public IDVersionPostingsFormat() {
        this(25, 48);
    }

    public IDVersionPostingsFormat(int minTermsInBlock, int maxTermsInBlock) {
        super("IDVersion");
        this.minTermsInBlock = minTermsInBlock;
        this.maxTermsInBlock = maxTermsInBlock;
        Lucene90BlockTreeTermsWriter.validateSettings(minTermsInBlock, maxTermsInBlock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        VersionBlockTreeTermsWriter versionBlockTreeTermsWriter;
        block3: {
            IDVersionPostingsWriter postingsWriter = new IDVersionPostingsWriter(state.liveDocs);
            boolean success = false;
            try {
                VersionBlockTreeTermsWriter ret = new VersionBlockTreeTermsWriter(state, postingsWriter, this.minTermsInBlock, this.maxTermsInBlock);
                success = true;
                versionBlockTreeTermsWriter = ret;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(postingsWriter);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(postingsWriter);
        }
        return versionBlockTreeTermsWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        VersionBlockTreeTermsReader versionBlockTreeTermsReader;
        block3: {
            IDVersionPostingsReader postingsReader = new IDVersionPostingsReader();
            boolean success = false;
            try {
                VersionBlockTreeTermsReader ret = new VersionBlockTreeTermsReader(postingsReader, state);
                success = true;
                versionBlockTreeTermsReader = ret;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(postingsReader);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(postingsReader);
        }
        return versionBlockTreeTermsReader;
    }

    public static long bytesToLong(BytesRef bytes) {
        return BitUtil.VH_BE_LONG.get(bytes.bytes, bytes.offset);
    }

    public static void longToBytes(long v, BytesRef bytes) {
        if (v > 0x3FFFFFFFFFFFFFFFL || v < 0L) {
            throw new IllegalArgumentException("version must be >= MIN_VERSION=0 and <= MAX_VERSION=4611686018427387903 (got: " + v + ")");
        }
        bytes.offset = 0;
        bytes.length = 8;
        BitUtil.VH_BE_LONG.set(bytes.bytes, 0, v);
        assert (IDVersionPostingsFormat.bytesToLong(bytes) == v) : IDVersionPostingsFormat.bytesToLong(bytes) + " vs " + v + " bytes=" + bytes;
    }
}

