/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.servlet;

import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.servlet.HttpInput;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.servlet.HttpOutput;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.servlet.ServletApiRequest;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.servlet.ServletChannel;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.servlet.ServletChannelState;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.servlet.ServletContextResponse;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.servlet.ServletHandler;
import com.dataiku.dss.shadelib.org.eclipse.jetty.http.HttpCookie;
import com.dataiku.dss.shadelib.org.eclipse.jetty.http.HttpFields;
import com.dataiku.dss.shadelib.org.eclipse.jetty.http.HttpMethod;
import com.dataiku.dss.shadelib.org.eclipse.jetty.http.HttpURI;
import com.dataiku.dss.shadelib.org.eclipse.jetty.http.UriCompliance;
import com.dataiku.dss.shadelib.org.eclipse.jetty.http.pathmap.MatchedResource;
import com.dataiku.dss.shadelib.org.eclipse.jetty.io.EndPoint;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.Request;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.Response;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.Session;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.handler.ContextRequest;
import com.dataiku.dss.shadelib.org.eclipse.jetty.session.AbstractSessionManager;
import com.dataiku.dss.shadelib.org.eclipse.jetty.session.ManagedSession;
import com.dataiku.dss.shadelib.org.eclipse.jetty.session.SessionManager;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.Attributes;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.Fields;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.URIUtil;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestAttributeListener;
import jakarta.servlet.ServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Set;

public class ServletContextRequest
extends ContextRequest
implements ServletContextHandler.ServletRequestInfo,
Request.ServeAs {
    public static final String MULTIPART_CONFIG_ELEMENT = "com.dataiku.dss.shadelib.org.eclipse.jetty.multipartConfig";
    public static final String SSL_CIPHER_SUITE = "jakarta.servlet.request.cipher_suite";
    public static final String SSL_KEY_SIZE = "jakarta.servlet.request.key_size";
    public static final String SSL_SESSION_ID = "jakarta.servlet.request.ssl_session_id";
    public static final String PEER_CERTIFICATES = "jakarta.servlet.request.X509Certificate";
    private static final Set<String> ATTRIBUTES = Set.of("jakarta.servlet.request.cipher_suite", "jakarta.servlet.request.key_size", "jakarta.servlet.request.ssl_session_id", "jakarta.servlet.request.X509Certificate", "com.dataiku.dss.shadelib.org.eclipse.jetty.multipartConfig", "com.dataiku.dss.shadelib.org.eclipse.jetty.server.Request.maxFormKeys", "com.dataiku.dss.shadelib.org.eclipse.jetty.server.Request.maxFormContentSize");
    static final int INPUT_NONE = 0;
    static final int INPUT_STREAM = 1;
    static final int INPUT_READER = 2;
    static final Fields NO_PARAMS = new Fields(Collections.emptyMap());
    static final Fields BAD_PARAMS = new Fields(Collections.emptyMap());
    private final ServletApiRequest _servletApiRequest;
    private final ServletContextResponse _response;
    private final MatchedResource<ServletHandler.MappedServlet> _matchedResource;
    private final HttpInput _httpInput;
    private final String _decodedPathInContext;
    private final ServletChannel _servletChannel;
    private final SessionManager _sessionManager;
    private final Attributes _attributes;
    private List<ServletRequestAttributeListener> _requestAttributeListeners;
    private Charset _queryEncoding;
    private HttpFields _trailers;
    private ManagedSession _managedSession;
    AbstractSessionManager.RequestedSession _requestedSession;

    public static ServletContextRequest getServletContextRequest(ServletRequest request) {
        ServletApiRequest servletApiRequest;
        ServletContextHandler.ServletRequestInfo servletRequestInfo;
        if (request instanceof ServletApiRequest && (servletRequestInfo = (servletApiRequest = (ServletApiRequest)request).getServletRequestInfo()) instanceof ServletContextRequest) {
            ServletContextRequest servletContextRequest = (ServletContextRequest)servletRequestInfo;
            return servletContextRequest;
        }
        Object servletContextRequest = request.getAttribute(ServletChannel.class.getName());
        if (servletContextRequest instanceof ServletChannel) {
            ServletChannel servletChannel = (ServletChannel)servletContextRequest;
            return servletChannel.getServletContextRequest();
        }
        while (request instanceof ServletRequestWrapper) {
            ServletApiRequest servletApiRequest2;
            ServletContextHandler.ServletRequestInfo servletRequestInfo2;
            ServletRequestWrapper wrapper = (ServletRequestWrapper)request;
            if (!((request = wrapper.getRequest()) instanceof ServletApiRequest) || !((servletRequestInfo2 = (servletApiRequest2 = (ServletApiRequest)request).getServletRequestInfo()) instanceof ServletContextRequest)) continue;
            ServletContextRequest servletContextRequest2 = (ServletContextRequest)servletRequestInfo2;
            return servletContextRequest2;
        }
        throw new IllegalStateException("could not find %s for %s".formatted(ServletContextRequest.class.getSimpleName(), request));
    }

    protected ServletContextRequest(ServletContextHandler.ServletContextApi servletContextApi, ServletChannel servletChannel, Request request, Response response, String decodedPathInContext, MatchedResource<ServletHandler.MappedServlet> matchedResource, SessionManager sessionManager) {
        super(servletContextApi.getContext(), request);
        this._servletChannel = servletChannel;
        this._matchedResource = matchedResource;
        this._httpInput = this._servletChannel.getHttpInput();
        this._decodedPathInContext = decodedPathInContext;
        this._sessionManager = sessionManager;
        this._servletApiRequest = this.newServletApiRequest();
        this._response = this.newServletContextResponse(response);
        this._attributes = new Attributes.Synthetic(request){

            @Override
            protected Object getSyntheticAttribute(String name) {
                return switch (name) {
                    case ServletContextRequest.SSL_CIPHER_SUITE -> {
                        Object var5_4 = super.getAttribute("com.dataiku.dss.shadelib.org.eclipse.jetty.io.Endpoint.SslSessionData");
                        if (var5_4 instanceof EndPoint.SslSessionData) {
                            EndPoint.SslSessionData data = (EndPoint.SslSessionData)var5_4;
                            yield data.cipherSuite();
                        }
                        yield null;
                    }
                    case ServletContextRequest.SSL_KEY_SIZE -> {
                        Object var5_5 = super.getAttribute("com.dataiku.dss.shadelib.org.eclipse.jetty.io.Endpoint.SslSessionData");
                        if (var5_5 instanceof EndPoint.SslSessionData) {
                            EndPoint.SslSessionData data = (EndPoint.SslSessionData)var5_5;
                            yield data.keySize();
                        }
                        yield null;
                    }
                    case ServletContextRequest.SSL_SESSION_ID -> {
                        Object var5_6 = super.getAttribute("com.dataiku.dss.shadelib.org.eclipse.jetty.io.Endpoint.SslSessionData");
                        if (var5_6 instanceof EndPoint.SslSessionData) {
                            EndPoint.SslSessionData data = (EndPoint.SslSessionData)var5_6;
                            yield data.sslSessionId();
                        }
                        yield null;
                    }
                    case ServletContextRequest.PEER_CERTIFICATES -> {
                        Object var5_7 = super.getAttribute("com.dataiku.dss.shadelib.org.eclipse.jetty.io.Endpoint.SslSessionData");
                        if (var5_7 instanceof EndPoint.SslSessionData) {
                            EndPoint.SslSessionData data = (EndPoint.SslSessionData)var5_7;
                            yield data.peerCertificates();
                        }
                        yield null;
                    }
                    case ServletContextRequest.MULTIPART_CONFIG_ELEMENT -> ServletContextRequest.this._matchedResource.getResource().getServletHolder().getMultipartConfigElement();
                    case "com.dataiku.dss.shadelib.org.eclipse.jetty.server.Request.maxFormKeys" -> ServletContextRequest.this.getServletContext().getServletContextHandler().getMaxFormKeys();
                    case "com.dataiku.dss.shadelib.org.eclipse.jetty.server.Request.maxFormContentSize" -> ServletContextRequest.this.getServletContext().getServletContextHandler().getMaxFormContentSize();
                    default -> null;
                };
            }

            @Override
            protected Set<String> getSyntheticNameSet() {
                return ATTRIBUTES;
            }
        };
        this.addIdleTimeoutListener(this._servletChannel.getServletRequestState()::onIdleTimeout);
    }

    @Override
    public Request wrap(Request request, final HttpURI uri) {
        String decodedPathInContext = URIUtil.decodePath(this.getContext().getPathInContext(uri.getCanonicalPath()));
        MatchedResource<ServletHandler.MappedServlet> matchedResource = this.getServletContextHandler().getServletHandler().getMatchedServlet(decodedPathInContext);
        if (matchedResource == null) {
            return null;
        }
        ServletHandler.MappedServlet mappedServlet = matchedResource.getResource();
        if (mappedServlet == null) {
            return null;
        }
        ServletChannel servletChannel = this.getServletChannel();
        ServletContextRequest servletContextRequest = this.getServletContextHandler().newServletContextRequest(servletChannel, new Request.Wrapper(this, request){
            final /* synthetic */ ServletContextRequest this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public HttpURI getHttpURI() {
                return uri;
            }
        }, this._response, decodedPathInContext, matchedResource);
        servletChannel.associate(servletContextRequest);
        return servletContextRequest;
    }

    protected ServletApiRequest newServletApiRequest() {
        if (this.getHttpURI().hasViolations() && !this.getServletChannel().getServletContextHandler().getServletHandler().isDecodeAmbiguousURIs()) {
            StringBuilder msg = null;
            for (UriCompliance.Violation violation : this.getHttpURI().getViolations()) {
                if (!UriCompliance.AMBIGUOUS_VIOLATIONS.contains(violation)) continue;
                if (msg == null) {
                    msg = new StringBuilder();
                    msg.append("Ambiguous URI encoding: ");
                } else {
                    msg.append(", ");
                }
                msg.append(violation.name());
            }
            if (msg != null) {
                return new ServletApiRequest.AmbiguousURI(this, msg.toString());
            }
        }
        if (this.getServletContextHandler().isCrossContextDispatchSupported()) {
            if (DispatcherType.INCLUDE.toString().equals(this.getContext().getCrossContextDispatchType(this.getWrapped()))) {
                return new ServletApiRequest.CrossContextIncluded(this);
            }
            if (DispatcherType.FORWARD.toString().equals(this.getContext().getCrossContextDispatchType(this.getWrapped()))) {
                return new ServletApiRequest.CrossContextForwarded(this);
            }
            return new ServletApiRequest(this);
        }
        return new ServletApiRequest(this);
    }

    protected ServletContextResponse newServletContextResponse(Response response) {
        return new ServletContextResponse(this._servletChannel, this, response);
    }

    @Override
    public ServletContextHandler getServletContextHandler() {
        return this._servletChannel.getServletContextHandler();
    }

    @Override
    public String getDecodedPathInContext() {
        return this._decodedPathInContext;
    }

    @Override
    public MatchedResource<ServletHandler.MappedServlet> getMatchedResource() {
        return this._matchedResource;
    }

    @Override
    public HttpFields getTrailers() {
        return this._trailers;
    }

    void setTrailers(HttpFields trailers) {
        this._trailers = trailers;
    }

    @Override
    public ServletChannelState getState() {
        return this._servletChannel.getServletRequestState();
    }

    public ServletContextResponse getServletContextResponse() {
        return this._response;
    }

    @Override
    public ServletContextHandler.ServletScopedContext getServletContext() {
        return (ServletContextHandler.ServletScopedContext)super.getContext();
    }

    @Override
    public HttpInput getHttpInput() {
        return this._httpInput;
    }

    public HttpOutput getHttpOutput() {
        return this._response.getHttpOutput();
    }

    public void errorClose() {
        this._response.getHttpOutput().softClose();
    }

    public boolean isHead() {
        return HttpMethod.HEAD.is(this.getMethod());
    }

    @Override
    public void setQueryEncoding(String queryEncoding) {
        this._queryEncoding = Charset.forName(queryEncoding);
    }

    @Override
    public Charset getQueryEncoding() {
        return this._queryEncoding;
    }

    @Override
    public Object getAttribute(String name) {
        return this._attributes.getAttribute(name);
    }

    @Override
    public Object removeAttribute(String name) {
        return this._attributes.removeAttribute(name);
    }

    @Override
    public Object setAttribute(String name, Object value) {
        return this._attributes.setAttribute(name, value);
    }

    @Override
    public Set<String> getAttributeNameSet() {
        return this._attributes.getAttributeNameSet();
    }

    public ServletContextHandler.ServletScopedContext getErrorContext() {
        return this._servletChannel.getContext();
    }

    @Override
    public ServletChannelState getServletRequestState() {
        return this._servletChannel.getServletRequestState();
    }

    @Override
    public ServletChannel getServletChannel() {
        return this._servletChannel;
    }

    public ServletApiRequest getServletApiRequest() {
        return this._servletApiRequest;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this._response.getServletApiResponse();
    }

    public String getServletName() {
        return this.getMatchedResource().getResource().getServletHolder().getName();
    }

    @Override
    public List<ServletRequestAttributeListener> getRequestAttributeListeners() {
        if (this._requestAttributeListeners == null) {
            this._requestAttributeListeners = new ArrayList<ServletRequestAttributeListener>();
        }
        return this._requestAttributeListeners;
    }

    public void addEventListener(EventListener listener) {
        if (listener instanceof ServletRequestAttributeListener) {
            ServletRequestAttributeListener attributeListener = (ServletRequestAttributeListener)listener;
            if (this._requestAttributeListeners == null) {
                this._requestAttributeListeners = new ArrayList<ServletRequestAttributeListener>();
            }
            this._requestAttributeListeners.add(attributeListener);
        }
        if (listener instanceof AsyncListener) {
            throw new IllegalArgumentException(listener.getClass().toString());
        }
    }

    public void removeEventListener(EventListener listener) {
        if (this._requestAttributeListeners != null) {
            this._requestAttributeListeners.remove(listener);
        }
    }

    static boolean isNoParams(Fields fields) {
        boolean isNoParams = fields == NO_PARAMS;
        return isNoParams;
    }

    @Override
    public ManagedSession getManagedSession() {
        return this._managedSession;
    }

    public void setManagedSession(ManagedSession managedSession) {
        this._managedSession = managedSession;
    }

    @Override
    public SessionManager getSessionManager() {
        return this._sessionManager;
    }

    public void setRequestedSession(AbstractSessionManager.RequestedSession requestedSession) {
        if (this._requestedSession != null) {
            throw new IllegalStateException();
        }
        this._requestedSession = requestedSession;
        this._managedSession = requestedSession.session();
    }

    @Override
    public AbstractSessionManager.RequestedSession getRequestedSession() {
        return this._requestedSession;
    }

    @Override
    public Session getSession(boolean create) {
        if (this._managedSession != null) {
            if (this._sessionManager != null && !this._managedSession.isValid()) {
                this._managedSession = null;
            } else {
                return this._managedSession;
            }
        }
        if (!create) {
            return null;
        }
        if (this._response.isCommitted()) {
            throw new IllegalStateException("Response is committed");
        }
        if (this._sessionManager == null) {
            throw new IllegalStateException("No SessionManager");
        }
        this._sessionManager.newSession(this, this._requestedSession.sessionId(), this::setManagedSession);
        if (this._managedSession == null) {
            throw new IllegalStateException("Create session failed");
        }
        HttpCookie cookie = this._sessionManager.getSessionCookie(this._managedSession, this.isSecure());
        if (cookie != null) {
            Response.putCookie(this._response, cookie);
        }
        return this._managedSession;
    }
}

