/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.http.content;

import com.dataiku.dss.shadelib.org.eclipse.jetty.http.CompressedContentFormat;
import com.dataiku.dss.shadelib.org.eclipse.jetty.http.HttpField;
import com.dataiku.dss.shadelib.org.eclipse.jetty.http.HttpHeader;
import com.dataiku.dss.shadelib.org.eclipse.jetty.http.MimeTypes;
import com.dataiku.dss.shadelib.org.eclipse.jetty.http.PreEncodedHttpField;
import com.dataiku.dss.shadelib.org.eclipse.jetty.http.content.HttpContent;
import com.dataiku.dss.shadelib.org.eclipse.jetty.io.ByteBufferPool;
import com.dataiku.dss.shadelib.org.eclipse.jetty.io.IOResources;
import com.dataiku.dss.shadelib.org.eclipse.jetty.io.Retainable;
import com.dataiku.dss.shadelib.org.eclipse.jetty.io.RetainableByteBuffer;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.NanoTime;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.StringUtil;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.resource.Resource;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingHttpContentFactory
implements HttpContent.Factory {
    private static final Logger LOG = LoggerFactory.getLogger(CachingHttpContentFactory.class);
    private static final int DEFAULT_MAX_CACHED_FILE_SIZE = 0x8000000;
    private static final int DEFAULT_MAX_CACHED_FILES = 2048;
    private static final long DEFAULT_MAX_CACHE_SIZE = 0x10000000L;
    private final HttpContent.Factory _authority;
    private final ConcurrentHashMap<String, CachingHttpContent> _cache = new ConcurrentHashMap();
    private final AtomicLong _cachedSize = new AtomicLong();
    private final ByteBufferPool _bufferPool;
    private int _maxCachedFileSize = 0x8000000;
    private int _maxCachedFiles = 2048;
    private long _maxCacheSize = 0x10000000L;
    private boolean _useDirectByteBuffers = true;

    public CachingHttpContentFactory(HttpContent.Factory authority, ByteBufferPool bufferPool) {
        this._authority = authority;
        this._bufferPool = bufferPool != null ? bufferPool : ByteBufferPool.NON_POOLING;
    }

    protected ConcurrentMap<String, CachingHttpContent> getCache() {
        return this._cache;
    }

    public long getCachedSize() {
        return this._cachedSize.get();
    }

    public int getCachedFiles() {
        return this._cache.size();
    }

    public int getMaxCachedFileSize() {
        return this._maxCachedFileSize;
    }

    public void setMaxCachedFileSize(int maxCachedFileSize) {
        this._maxCachedFileSize = maxCachedFileSize;
        this.shrinkCache();
    }

    public long getMaxCacheSize() {
        return this._maxCacheSize;
    }

    public void setMaxCacheSize(long maxCacheSize) {
        this._maxCacheSize = maxCacheSize;
        this.shrinkCache();
    }

    public int getMaxCachedFiles() {
        return this._maxCachedFiles;
    }

    public void setMaxCachedFiles(int maxCachedFiles) {
        this._maxCachedFiles = maxCachedFiles;
        this.shrinkCache();
    }

    public boolean isUseDirectByteBuffers() {
        return this._useDirectByteBuffers;
    }

    public void setUseDirectByteBuffers(boolean useDirectByteBuffers) {
        this._useDirectByteBuffers = useDirectByteBuffers;
    }

    private void shrinkCache() {
        int numCacheEntries = this._cache.size();
        while (numCacheEntries > 0 && (numCacheEntries > this._maxCachedFiles || this._cachedSize.get() > this._maxCacheSize)) {
            TreeSet<CachingHttpContent> sorted2 = new TreeSet<CachingHttpContent>((c1, c2) -> {
                long delta = NanoTime.elapsed(c2.getLastAccessedNanos(), c1.getLastAccessedNanos());
                if (delta != 0L) {
                    return delta < 0L ? -1 : 1;
                }
                delta = c1.getContentLengthValue() - c2.getContentLengthValue();
                if (delta != 0L) {
                    return delta < 0L ? -1 : 1;
                }
                return c1.getKey().compareTo(c2.getKey());
            });
            sorted2.addAll(this._cache.values());
            for (CachingHttpContent content : sorted2) {
                if (this._cache.size() <= this._maxCachedFiles && this._cachedSize.get() <= this._maxCacheSize) break;
                this.removeFromCache(content);
            }
            numCacheEntries = this._cache.size();
        }
    }

    protected void removeFromCache(CachingHttpContent content) {
        CachingHttpContent removed = this._cache.remove(content.getKey());
        if (removed != null) {
            removed.release();
            this._cachedSize.addAndGet(-removed.getBytesOccupied());
        }
    }

    public void flushCache() {
        for (CachingHttpContent content : this._cache.values()) {
            this.removeFromCache(content);
        }
    }

    protected boolean isCacheable(HttpContent httpContent) {
        if (httpContent == null) {
            return true;
        }
        if (httpContent.getResource().isDirectory()) {
            return false;
        }
        if (this._maxCachedFiles <= 0) {
            return false;
        }
        long len = httpContent.getBytesOccupied();
        return len <= (long)this._maxCachedFileSize && len <= this._maxCacheSize;
    }

    @Override
    public HttpContent getContent(String path) throws IOException {
        HttpContent httpContent;
        CachingHttpContent cachingHttpContent = this._cache.get(path);
        if (cachingHttpContent != null) {
            cachingHttpContent.setLastAccessedNanos(NanoTime.now());
            if (cachingHttpContent.isValid()) {
                if (cachingHttpContent.retain()) {
                    return cachingHttpContent instanceof NotFoundHttpContent ? null : cachingHttpContent;
                }
            } else {
                this.removeFromCache(cachingHttpContent);
            }
        }
        if (!this.isCacheable(httpContent = this._authority.getContent(path))) {
            return httpContent;
        }
        AtomicBoolean added = new AtomicBoolean();
        cachingHttpContent = this._cache.computeIfAbsent(path, key -> {
            CachingHttpContent cachingContent = httpContent == null ? this.newNotFoundContent((String)key) : this.newCachedContent((String)key, httpContent);
            added.set(true);
            this._cachedSize.addAndGet(cachingContent.getBytesOccupied());
            return cachingContent;
        });
        if (!cachingHttpContent.retain()) {
            return httpContent;
        }
        if (added.get()) {
            this.shrinkCache();
        } else if (httpContent != null) {
            httpContent.release();
        }
        return cachingHttpContent instanceof NotFoundHttpContent ? null : cachingHttpContent;
    }

    protected CachingHttpContent newCachedContent(String p, HttpContent httpContent) {
        return new CachedHttpContent(p, httpContent);
    }

    protected CachingHttpContent newNotFoundContent(String p) {
        return new NotFoundHttpContent(p);
    }

    protected static interface CachingHttpContent
    extends HttpContent {
        public long getLastAccessedNanos();

        public void setLastAccessedNanos(long var1);

        public String getKey();

        public boolean isValid();

        public boolean retain();
    }

    protected static class NotFoundHttpContent
    implements CachingHttpContent {
        private volatile long _lastAccessed;
        private final String _key;

        public NotFoundHttpContent(String key) {
            this._key = key;
            this._lastAccessed = NanoTime.now();
        }

        @Override
        public String getKey() {
            return this._key;
        }

        @Override
        public long getLastAccessedNanos() {
            return this._lastAccessed;
        }

        @Override
        public void setLastAccessedNanos(long nanosTime) {
            this._lastAccessed = nanosTime;
        }

        @Override
        public HttpField getContentType() {
            return null;
        }

        @Override
        public String getContentTypeValue() {
            return null;
        }

        @Override
        public String getCharacterEncoding() {
            return null;
        }

        @Override
        public MimeTypes.Type getMimeType() {
            return null;
        }

        @Override
        public HttpField getContentEncoding() {
            return null;
        }

        @Override
        public String getContentEncodingValue() {
            return null;
        }

        @Override
        public HttpField getContentLength() {
            return null;
        }

        @Override
        public long getContentLengthValue() {
            return 0L;
        }

        @Override
        public Instant getLastModifiedInstant() {
            return null;
        }

        @Override
        public HttpField getLastModified() {
            return null;
        }

        @Override
        public String getLastModifiedValue() {
            return null;
        }

        @Override
        public HttpField getETag() {
            return null;
        }

        @Override
        public String getETagValue() {
            return null;
        }

        @Override
        public Resource getResource() {
            return null;
        }

        @Override
        public ByteBuffer getByteBuffer() {
            return null;
        }

        @Override
        public Set<CompressedContentFormat> getPreCompressedContentFormats() {
            return null;
        }

        @Override
        public void release() {
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public boolean retain() {
            return true;
        }
    }

    protected class CachedHttpContent
    extends HttpContent.Wrapper
    implements CachingHttpContent {
        private final RetainableByteBuffer _buffer;
        private final String _cacheKey;
        private final HttpField _etagField;
        private final long _contentLengthValue;
        private volatile long _lastAccessed;
        private final Set<CompressedContentFormat> _compressedFormats;
        private final String _lastModifiedValue;
        private final String _characterEncoding;
        private final MimeTypes.Type _mimeType;
        private final HttpField _contentLength;
        private final Instant _lastModifiedInstant;
        private final HttpField _lastModified;
        private final long _bytesOccupied;
        private final boolean _isValid;
        private final Retainable.ReferenceCounter _referenceCount;

        public CachedHttpContent(String key, HttpContent httpContent) {
            RetainableByteBuffer buffer;
            boolean isValid;
            block7: {
                super(httpContent);
                this._referenceCount = new Retainable.ReferenceCounter();
                this._cacheKey = key;
                HttpField etagField = httpContent.getETag();
                String eTagValue = httpContent.getETagValue();
                if (StringUtil.isNotBlank(eTagValue)) {
                    etagField = new PreEncodedHttpField(HttpHeader.ETAG, eTagValue);
                }
                this._etagField = etagField;
                this._contentLengthValue = httpContent.getContentLengthValue();
                isValid = true;
                ByteBuffer byteBuffer = httpContent.getByteBuffer();
                if (byteBuffer == null) {
                    try {
                        if (this._contentLengthValue <= (long)CachingHttpContentFactory.this._maxCachedFileSize) {
                            buffer = IOResources.toRetainableByteBuffer(httpContent.getResource(), CachingHttpContentFactory.this._bufferPool, CachingHttpContentFactory.this._useDirectByteBuffers);
                            break block7;
                        }
                        buffer = null;
                    }
                    catch (Throwable t2) {
                        buffer = null;
                        isValid = false;
                        if (LOG.isDebugEnabled()) {
                            LOG.warn("Failed to read Resource: {}", (Object)httpContent.getResource(), (Object)t2);
                            break block7;
                        }
                        LOG.warn("Failed to read Resource: {} - {}", (Object)httpContent.getResource(), (Object)t2.toString());
                    }
                } else {
                    buffer = RetainableByteBuffer.wrap(byteBuffer);
                }
            }
            this._buffer = buffer;
            this._isValid = isValid;
            this._bytesOccupied = httpContent.getBytesOccupied();
            this._lastModifiedValue = httpContent.getLastModifiedValue();
            this._characterEncoding = httpContent.getCharacterEncoding();
            this._compressedFormats = httpContent.getPreCompressedContentFormats();
            this._mimeType = httpContent.getMimeType();
            this._contentLength = httpContent.getContentLength();
            this._lastModifiedInstant = httpContent.getLastModifiedInstant();
            this._lastModified = httpContent.getLastModified();
            this._lastAccessed = NanoTime.now();
        }

        @Override
        public long getContentLengthValue() {
            return this._contentLengthValue;
        }

        @Override
        public ByteBuffer getByteBuffer() {
            return this._buffer == null ? null : this._buffer.getByteBuffer().asReadOnlyBuffer();
        }

        @Override
        public long getBytesOccupied() {
            return this._bytesOccupied;
        }

        @Override
        public long getLastAccessedNanos() {
            return this._lastAccessed;
        }

        @Override
        public void setLastAccessedNanos(long nanosTime) {
            this._lastAccessed = nanosTime;
        }

        @Override
        public String getKey() {
            return this._cacheKey;
        }

        @Override
        public boolean retain() {
            return CachingHttpContentFactory.this._cache.computeIfPresent(this._cacheKey, (s2, cachingHttpContent) -> {
                this._referenceCount.retain();
                return cachingHttpContent;
            }) != null;
        }

        @Override
        public void release() {
            if (this._referenceCount.release()) {
                if (this._buffer != null) {
                    this._buffer.release();
                }
                super.release();
            }
        }

        @Override
        public Set<CompressedContentFormat> getPreCompressedContentFormats() {
            return this._compressedFormats;
        }

        @Override
        public HttpField getETag() {
            return this._etagField;
        }

        @Override
        public String getETagValue() {
            return this._etagField == null ? null : this._etagField.getValue();
        }

        @Override
        public String getCharacterEncoding() {
            return this._characterEncoding;
        }

        @Override
        public MimeTypes.Type getMimeType() {
            return this._mimeType;
        }

        @Override
        public HttpField getContentLength() {
            return this._contentLength;
        }

        @Override
        public Instant getLastModifiedInstant() {
            return this._lastModifiedInstant;
        }

        @Override
        public HttpField getLastModified() {
            return this._lastModified;
        }

        @Override
        public String getLastModifiedValue() {
            return this._lastModifiedValue;
        }

        @Override
        public boolean isValid() {
            return this._isValid;
        }
    }
}

