/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.util.resource;

import com.dataiku.dss.shadelib.org.eclipse.jetty.util.UriPatternPredicate;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.resource.Resource;
import java.net.URI;
import java.util.Objects;
import java.util.function.Predicate;

public class ResourceUriPatternPredicate
implements Predicate<Resource> {
    private final Predicate<URI> uriPredicate;

    public ResourceUriPatternPredicate(String regex, boolean isNullInclusive) {
        this(new UriPatternPredicate(regex, isNullInclusive));
    }

    public ResourceUriPatternPredicate(UriPatternPredicate uriPredicate) {
        this.uriPredicate = Objects.requireNonNull(uriPredicate, "UriPatternPredicate cannot be null");
    }

    @Override
    public boolean test(Resource resource) {
        if (resource == null) {
            return false;
        }
        URI uri = resource.getURI();
        return this.uriPredicate.test(uri);
    }
}

