/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.logging;

import com.dataiku.dip.logging.LimitedLogContext;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.reflect.TypeToken;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.log4j.Level;

public class LimitedLogFactory {
    public static final int DEFAULT_LIMIT = 100;
    public static final String CONF_PREFIX = "logging.limit.";
    public static final String SPARK_CONF = "spark.dku.limitedLogs";
    private static final Map<String, Long> REGISTRY = new HashMap<String, Long>();

    public static LimitedLogContext get(DKULogger logger, String id) {
        return LimitedLogFactory.get(logger, id, Level.DEBUG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LimitedLogContext get(DKULogger logger, String id, Level level) {
        long limit = 100L;
        Map<String, Long> map = REGISTRY;
        synchronized (map) {
            if (REGISTRY.containsKey(id)) {
                if (REGISTRY.get(id) == null) {
                    logger.info("NaN limited logger " + id + ", defaulting to " + limit);
                } else if (REGISTRY.get(id) <= 0L) {
                    logger.info("Limited logger " + id + " <= 0, defaulting to " + limit);
                } else {
                    limit = REGISTRY.get(id);
                }
            }
        }
        return new LimitedLogContext(logger, limit, level);
    }

    public static void configure(Properties conf) {
        for (String name : conf.stringPropertyNames()) {
            Long limit;
            if (!name.startsWith(CONF_PREFIX)) continue;
            String value = conf.getProperty(name);
            try {
                limit = Long.parseLong(value);
            }
            catch (NumberFormatException nfe) {
                limit = null;
            }
            LimitedLogFactory.register(name.substring(CONF_PREFIX.length()), limit);
        }
    }

    public static void configure(String json) {
        Map<String, Long> map = JSON.parse(json, new TypeToken<Map<String, Long>>(){});
        for (String id : map.keySet()) {
            LimitedLogFactory.register(id, map.get(id));
        }
    }

    public static String toJSON() {
        return JSON.toJsonObject(REGISTRY).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void register(String id, @Nullable Long limit) {
        Map<String, Long> map = REGISTRY;
        synchronized (map) {
            REGISTRY.put(id, limit);
        }
    }
}

