/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.endpoints.predictcommon;

import com.dataiku.dip.classpathfix.DKUDoubles;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.lambda.endpoints.predictcommon.PipelineMessage;
import com.dataiku.lambda.endpoints.predictcommon.PredictionStep;
import com.dataiku.lambda.model.api.PredictionResponse;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractPythonPredictionStep
implements PredictionStep {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.lambda.predict");

    protected PreparedRecords toRecords(PipelineMessage message, Map<String, SchemaColumn> schemaMap, PasswordEncryptionService passwordEncryptionService) {
        PreparedRecords out = new PreparedRecords();
        JsonObject obj = new JsonObject();
        JsonObject columns = new JsonObject();
        int serializedCells = 0;
        for (MemColumn memCol : message.table.columnsList) {
            JsonArray arr = new JsonArray();
            int rowIdx = 0;
            for (MemRow row : message.table.rows) {
                if (message.prePredictIgnoreReasons.get(rowIdx) != null) {
                    logger.info((Object)("Not serializing row " + rowIdx));
                    ++rowIdx;
                    continue;
                }
                SchemaColumn sc = schemaMap == null ? null : schemaMap.get(memCol.getName());
                String v = row.get((Column)memCol);
                if (v == null) {
                    arr.add((Boolean)null);
                } else if (StringUtils.isNotBlank((String)v) && sc != null && sc.getType().isFloatingPoint()) {
                    Double d = DKUDoubles.tryParse((String)v);
                    if (d == null) {
                        arr.add((Boolean)null);
                    } else {
                        arr.add((JsonElement)new JsonPrimitive(d.toString()));
                    }
                } else {
                    arr.add((JsonElement)new JsonPrimitive(v));
                }
                ++serializedCells;
                ++rowIdx;
            }
            columns.add(memCol.getName(), (JsonElement)arr);
        }
        obj.add("records", (JsonElement)columns);
        if (message.explanations != null) {
            obj.add("explanations", (JsonElement)JSON.toJsonObject((Object)message.explanations));
        }
        out.obj = obj;
        out.serialized = serializedCells;
        if (message.apiKey != null) {
            out.usedAPIKey = passwordEncryptionService.decryptIfEncrypted(message.apiKey.key);
        }
        out.httpRequestMetadata = JSON.toJsonObject((Object)message.httpRequestMetadata);
        return out;
    }

    protected PredictionResponse toResponse(PipelineMessage message, InternalPredictionResponse iret) {
        PredictionResponse ret = new PredictionResponse();
        if (!iret.timeseriesForecasting.isEmpty()) {
            ret.results.addAll(iret.timeseriesForecasting);
        } else {
            ArrayList<Object> resultItems = new ArrayList<Object>();
            resultItems.addAll(iret.regression);
            resultItems.addAll(iret.classification);
            resultItems.addAll(iret.objectDetection);
            resultItems.addAll(iret.arbitraryPrimitive);
            resultItems.addAll(iret.arbitraryObject);
            resultItems.addAll(iret.arbitraryArray);
            resultItems.addAll(iret.clustering);
            resultItems.addAll(iret.causalPrediction);
            int idxInResultItems = 0;
            for (int i = 0; i < message.prePredictIgnoreReasons.size(); ++i) {
                if (message.prePredictIgnoreReasons.get(i) != null) {
                    PredictionResponse.PredictionResponseItem item = new PredictionResponse.PredictionResponseItem();
                    item.ignored = true;
                    item.ignoreReason = message.prePredictIgnoreReasons.get(i);
                    ret.results.add(item);
                    continue;
                }
                ret.results.add((PredictionResponse.PredictionResponseItem)resultItems.get(idxInResultItems));
                ++idxInResultItems;
            }
            ret.timing.predictionExplain = iret.explanationsTimeUS;
        }
        ret.timing.predictionPredict = iret.execTimeUS;
        return ret;
    }

    public static class PreparedRecords {
        public JsonObject obj;
        public int serialized;
        public String usedAPIKey;
        @Nullable
        public JsonObject httpRequestMetadata;
    }

    public static class InternalPredictionResponse {
        public List<PredictionResponse.RegressionResponseItem> regression = new ArrayList<PredictionResponse.RegressionResponseItem>();
        public List<PredictionResponse.ClassificationResponseItem> classification = new ArrayList<PredictionResponse.ClassificationResponseItem>();
        public List<PredictionResponse.ObjectDetectionResponseItem> objectDetection = new ArrayList<PredictionResponse.ObjectDetectionResponseItem>();
        public List<PredictionResponse.TimeseriesForecastingResponseItem> timeseriesForecasting = new ArrayList<PredictionResponse.TimeseriesForecastingResponseItem>();
        public List<PredictionResponse.CausalPredictionResponseItem> causalPrediction = new ArrayList<PredictionResponse.CausalPredictionResponseItem>();
        public List<PredictionResponse.ArbitraryPrimitiveResponseItem> arbitraryPrimitive = new ArrayList<PredictionResponse.ArbitraryPrimitiveResponseItem>();
        public List<PredictionResponse.ArbitraryObjectResponseItem> arbitraryObject = new ArrayList<PredictionResponse.ArbitraryObjectResponseItem>();
        public List<PredictionResponse.ArbitraryArrayResponseItem> arbitraryArray = new ArrayList<PredictionResponse.ArbitraryArrayResponseItem>();
        public List<PredictionResponse.ClusteringResponseItem> clustering = new ArrayList<PredictionResponse.ClusteringResponseItem>();
        public long execTimeUS;
        public Long explanationsTimeUS;
    }
}

