/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.aiexplanations;

import com.dataiku.common.rpc.InternalAPIClient;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.aiexplanations.ExplainStuffFrontendResponse;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.AIFeaturesUtil;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.NDC;

public abstract class ExplainStuffFutureThread
extends SimpleFutureThread<ExplainStuffFrontendResponse> {
    public static final String DEFAULT_URL = "https://ai.api-services.dataiku.io/";
    private final LicenseStatusService licenseStatusService;
    private final JsonObject explanationOptions;
    protected final GeneralSettingsDAO.GeneralSettings generalSettings;
    private final AuthCtx authCtx;
    private final boolean disableThrottling;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.aiexplanations");

    public ExplainStuffFutureThread(AuthCtx owner, LicenseStatusService licenseStatusService, String explanationOptions, boolean disableThrottling) {
        super(owner);
        Preconditions.checkNotNull((Object)licenseStatusService);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)explanationOptions));
        this.licenseStatusService = licenseStatusService;
        this.explanationOptions = (JsonObject)JSON.parse((String)explanationOptions, JsonObject.class);
        this.generalSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        this.authCtx = owner;
        this.disableThrottling = disableThrottling;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public ExplainStuffFrontendResponse compute() throws Exception {
        NDC.push((String)this.createNdcMessage());
        try {
            ExplainStuffFrontendResponse explainStuffFrontendResponse;
            block24: {
                ExplainStuffBackendResponse resp2222;
                InternalAPIClient apiClient;
                block22: {
                    ExplainStuffFrontendResponse explainStuffFrontendResponse2;
                    block23: {
                        if (!this.generalSettings.aiDrivenAnalyticsSettings.aiExplanationsEnabled) {
                            throw new IllegalStateException("AI-generated explanations are not enabled");
                        }
                        LicenseStatusService.LicensingStatus licensingStatus = this.licenseStatusService.getLicensingStatus();
                        if (licensingStatus.community) {
                            String message = "AI services are not available with Dataiku Free Edition";
                            throw new IllegalArgumentException(message);
                        }
                        ExplainStuffBackendQuery explainQuery = this.createQuery();
                        if (explainQuery == null) {
                            ExplainStuffFrontendResponse explainStuffFrontendResponse3 = this.createEmptyBackendQueryFrontendResponse();
                            return explainStuffFrontendResponse3;
                        }
                        explainQuery.licenseId = licensingStatus.licenseContent != null ? licensingStatus.licenseContent.licenseId : null;
                        explainQuery.telemetryEnabled = this.generalSettings.aiDrivenAnalyticsSettings.aiExplanationsTelemetryEnabled;
                        explainQuery.explanationOptions = this.explanationOptions;
                        int aiExplainTimeout = DKUApp.getParams().getIntParam("dku.dada.AIExplain.network.timeout", Integer.valueOf(200000));
                        int maxRetries = DKUApp.getParams().getIntParam("dku.dada.AIExplain.network.maxretries", Integer.valueOf(5));
                        int sleepIntervalSeconds = 60;
                        if (this.disableThrottling) {
                            maxRetries = 0;
                        }
                        apiClient = AIFeaturesUtil.getAiServerAPIClient(this.authCtx, this.generalSettings, GeneralSettingsDAO.LocalAIServerSettings.AiAssistant.aiExplanations, aiExplainTimeout, aiExplainTimeout, maxRetries, sleepIntervalSeconds);
                        resp2222 = (ExplainStuffBackendResponse)apiClient.postObject(this.createBackendApiEndpointPath(), ExplainStuffBackendResponse.class, (Object)explainQuery);
                        logger.info((Object)("AI Response: " + JSON.json((Object)resp2222)));
                        if (resp2222.ok) break block22;
                        ExplainStuffFrontendResponse finalResp = new ExplainStuffFrontendResponse();
                        finalResp.reason = this.createFailureReason();
                        if (resp2222.error != null) {
                            finalResp.reason = finalResp.reason + ": " + resp2222.error;
                        }
                        finalResp.ok = false;
                        logger.warn((Object)finalResp.reason);
                        explainStuffFrontendResponse2 = finalResp;
                        if (apiClient == null) break block23;
                        apiClient.close();
                    }
                    return explainStuffFrontendResponse2;
                }
                ExplainStuffFrontendResponse finalResp = new ExplainStuffFrontendResponse();
                finalResp.ok = true;
                finalResp.requestId = resp2222.request_id;
                finalResp.explanation = resp2222.explanation;
                explainStuffFrontendResponse = finalResp;
                if (apiClient == null) break block24;
                {
                    catch (Throwable resp2222) {
                        ExplainStuffFrontendResponse finalResp2;
                        try {
                            if (apiClient != null) {
                                try {
                                    apiClient.close();
                                }
                                catch (Throwable throwable) {
                                    resp2222.addSuppressed(throwable);
                                }
                            }
                            throw resp2222;
                        }
                        catch (IOException e) {
                            logger.error((Object)"IO exception while getting AI explanation", (Throwable)e);
                            finalResp2 = new ExplainStuffFrontendResponse();
                            finalResp2.ok = false;
                            finalResp2.reason = "Could not get response from AI service: " + ExceptionUtils.getMessageWithCauses((Throwable)e);
                            ExplainStuffFrontendResponse explainStuffFrontendResponse4 = finalResp2;
                            return explainStuffFrontendResponse4;
                        }
                        catch (DKUSecurityException e) {
                            logger.error((Object)"Unauthorized exception while getting AI explanation", (Throwable)e);
                            finalResp2 = new ExplainStuffFrontendResponse();
                            finalResp2.ok = false;
                            finalResp2.reason = ExceptionUtils.getMessageWithCauses((Throwable)e);
                            ExplainStuffFrontendResponse explainStuffFrontendResponse5 = finalResp2;
                            return explainStuffFrontendResponse5;
                        }
                    }
                }
                apiClient.close();
            }
            return explainStuffFrontendResponse;
        }
        finally {
            NDC.pop();
        }
    }

    protected abstract ExplainStuffBackendQuery createQuery() throws Exception;

    protected ExplainStuffFrontendResponse createEmptyBackendQueryFrontendResponse() {
        return null;
    }

    protected abstract String createBackendApiEndpointPath();

    protected abstract String createFailureReason();

    protected abstract String createNdcMessage();

    protected static abstract class ExplainStuffBackendQuery {
        String licenseId;
        boolean telemetryEnabled;
        JsonObject explanationOptions;

        protected ExplainStuffBackendQuery() {
        }
    }

    private static class ExplainStuffBackendResponse {
        boolean ok;
        String error;
        String request_id;
        String explanation;

        private ExplainStuffBackendResponse() {
        }
    }
}

