/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.aigenerations;

import com.dataiku.common.rpc.InternalAPIClient;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.util.AIFeaturesUtil;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.log4j.NDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AITextGenerationService {
    @Autowired
    private FutureService futureService;
    @Autowired
    private LicenseStatusService licenseStatusService;
    private static final DKULogger logger = DKULogger.getLogger(AITextGenerationService.class);

    public FutureResponse<AITextGenerationFrontendResponse> startTextGeneration(DSSAuthCtx authCtx, String text, @Nullable Integer maxLine) throws Exception {
        AITextGenerationBackendQuery query = new AITextGenerationBackendQuery();
        query.text = text;
        query.maxLine = maxLine;
        AITextGenerationScriptFutureThread futureThread = new AITextGenerationScriptFutureThread(authCtx, query);
        return this.futureService.runFuture(futureThread, 0L, new TypeToken<FutureResponse<AITextGenerationFrontendResponse>>(){});
    }

    public FutureResponse<AITextGenerationFrontendResponse> startTextTransformation(DSSAuthCtx authCtx, String text, String transform) throws Exception {
        AITextTransformBackendQuery query = new AITextTransformBackendQuery();
        query.text = text;
        query.transform = transform;
        AITextGenerationScriptFutureThread futureThread = new AITextGenerationScriptFutureThread(authCtx, query);
        return this.futureService.runFuture(futureThread, 0L, new TypeToken<FutureResponse<AITextGenerationFrontendResponse>>(){});
    }

    public static class AITextGenerationBackendQuery
    extends AITextGenerationBackendQueryBase {
        @Nullable
        Integer maxLine;
    }

    private class AITextGenerationScriptFutureThread
    extends SimpleFutureThread<AITextGenerationFrontendResponse> {
        private final AITextGenerationBackendQueryBase query;
        private final GeneralSettingsDAO.GeneralSettings generalSettings;

        public AITextGenerationScriptFutureThread(DSSAuthCtx owner, AITextGenerationBackendQueryBase query) {
            super((AuthCtx)owner);
            this.generalSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
            this.query = query;
        }

        public FuturePayload getPayload() {
            return FuturePayload.newSimple((String)"ai_text_generation", (String)"AI Text Generation");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AITextGenerationFrontendResponse compute() throws Exception {
            NDC.push((String)("ai-textgeneration: " + this.query.text));
            try {
                AITextGenerationFrontendResponse aITextGenerationFrontendResponse;
                block17: {
                    if (!this.generalSettings.aiDrivenAnalyticsSettings.storiesAIEnabled || !this.generalSettings.dataikuStoriesSettings.enabled) {
                        throw new IllegalStateException("Stories AI text generation is not enabled. Please contact an administrator to enable it.");
                    }
                    LicenseStatusService.LicensingStatus ls = AITextGenerationService.this.licenseStatusService.getLicensingStatus();
                    if (ls.community) {
                        throw new IllegalArgumentException("AI services are not available with Dataiku Free Edition");
                    }
                    this.query.licenseId = ls != null && ls.licenseContent != null ? ls.licenseContent.licenseId : null;
                    this.query.telemetryEnabled = this.generalSettings.aiDrivenAnalyticsSettings.storiesAITelemetryEnabled;
                    InternalAPIClient apiClient = AIFeaturesUtil.getAiServerAPIClient(this.owner, this.generalSettings, GeneralSettingsDAO.LocalAIServerSettings.AiAssistant.storiesAI, AIFeaturesUtil.CONNECTION_TIMEOUT, AIFeaturesUtil.SOCKET_TIMEOUT);
                    try {
                        String endpoint = this.query instanceof AITextTransformBackendQuery ? "/text2text/transform" : "/text2text/generate";
                        AITextGenerationBackendResponse resp = (AITextGenerationBackendResponse)apiClient.postObject(endpoint, AITextGenerationBackendResponse.class, (Object)this.query);
                        logger.info((Object)("AI Response: " + JSON.json((Object)resp)));
                        AITextGenerationFrontendResponse finalResp = new AITextGenerationFrontendResponse();
                        finalResp.requestId = resp.request_id;
                        if (!resp.ok) {
                            logger.warn((Object)"AI was not able to generate that text");
                            finalResp.reason = "AI was not able to generate that text";
                            if (resp.error != null) {
                                finalResp.reason = finalResp.reason + ": " + resp.error;
                            }
                            finalResp.ok = false;
                        } else {
                            finalResp.ok = true;
                            finalResp.text = resp.text;
                        }
                        aITextGenerationFrontendResponse = finalResp;
                        if (apiClient == null) break block17;
                    }
                    catch (Throwable endpoint) {
                        try {
                            if (apiClient != null) {
                                try {
                                    apiClient.close();
                                }
                                catch (Throwable throwable) {
                                    endpoint.addSuppressed(throwable);
                                }
                            }
                            throw endpoint;
                        }
                        catch (IOException e) {
                            logger.error((Object)"IO exception while getting AI transformation", (Throwable)e);
                            AITextGenerationFrontendResponse finalResp = new AITextGenerationFrontendResponse();
                            finalResp.ok = false;
                            finalResp.reason = "Could not get response from AI service: " + ExceptionUtils.getMessageWithCauses((Throwable)e);
                            AITextGenerationFrontendResponse aITextGenerationFrontendResponse2 = finalResp;
                            NDC.pop();
                            return aITextGenerationFrontendResponse2;
                        }
                    }
                    apiClient.close();
                }
                return aITextGenerationFrontendResponse;
            }
            finally {
                NDC.pop();
            }
        }
    }

    public static abstract class AITextGenerationBackendQueryBase {
        String licenseId;
        String text;
        boolean telemetryEnabled;
    }

    public static class AITextTransformBackendQuery
    extends AITextGenerationBackendQueryBase {
        String transform;
    }

    public static class AITextGenerationFrontendResponse {
        boolean ok;
        String reason;
        String text;
        String requestId;
    }

    public static class AITextGenerationBackendResponse {
        boolean ok;
        String error;
        String text;
        String request_id;
    }
}

