/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.clustering.guess;

import com.dataiku.dip.analysis.ml.clustering.guess.ClusteringGuesser;
import com.dataiku.dip.analysis.model.ClusteringModelingParams;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.clustering.ClusteringMLTask;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import org.apache.log4j.Logger;

public class DefaultClusteringGuesser
extends ClusteringGuesser {
    private static Logger logger = Logger.getLogger((String)"dku.analysis.guess");

    public DefaultClusteringGuesser(ClusteringMLTask task, MemTable table) {
        super(task, table);
    }

    private ClusteringModelingParams initAlgorithmsParams(boolean keepExistingParams) {
        ClusteringModelingParams params;
        if (keepExistingParams) {
            params = ((ClusteringMLTask)this.task).modeling;
            if (((ClusteringMLTask)this.task).backendType == MLTask.BackendType.MLLIB) {
                params.mllib_kmeans_clustering = new ClusteringModelingParams.MLLibKMeansParams();
                params.mllib_gaussian_mixture_clustering = new ClusteringModelingParams.MLLibGaussianMixtureParams();
            } else if (((ClusteringMLTask)this.task).backendType == MLTask.BackendType.H2O) {
                params.h2o_kmeans = new ClusteringModelingParams.H2OKMeansModelingParams();
            } else {
                params.kmeans_clustering = new ClusteringModelingParams.KMeansParams();
                params.mini_batch_kmeans_clustering = new ClusteringModelingParams.MiniBatchKMeansParams();
                params.ward_clustering = new ClusteringModelingParams.WardParams();
                params.spectral_clustering = new ClusteringModelingParams.SpectralParams();
                params.db_scan_clustering = new ClusteringModelingParams.DBScanParams();
                params.hdb_scan_clustering = new ClusteringModelingParams.HDBScanParams();
                params.gmm_clustering = new ClusteringModelingParams.GMMParams();
            }
        } else {
            params = new ClusteringModelingParams();
        }
        return params;
    }

    @Override
    public ClusteringModelingParams guessAlgorithms(boolean keepExistingParams) {
        ClusteringModelingParams params = this.initAlgorithmsParams(keepExistingParams);
        if (((ClusteringMLTask)this.task).backendType == MLTask.BackendType.MLLIB) {
            params.mllib_kmeans_clustering.enabled = true;
            params.mllib_kmeans_clustering.k = new int[]{3, 5, 7};
            params.mllib_kmeans_clustering.max_iterations = 25;
            params.mllib_gaussian_mixture_clustering.k = new int[]{5};
            params.mllib_gaussian_mixture_clustering.max_iterations = 25;
            params.mllib_gaussian_mixture_clustering.setFactoryKValues();
        } else if (((ClusteringMLTask)this.task).backendType == MLTask.BackendType.H2O) {
            params.h2o_kmeans.k = new int[]{3, 5, 7};
            params.h2o_kmeans.max_iterations = 50;
            params.h2o_kmeans.init = "PlusPlus";
            params.h2o_kmeans.enabled = true;
        } else {
            if (((ClusteringMLTask)this.task).backendType == MLTask.BackendType.VERTICA) {
                throw new IllegalArgumentException(String.valueOf((Object)((ClusteringMLTask)this.task).backendType) + " not supported.");
            }
            params.kmeans_clustering.enabled = true;
            params.kmeans_clustering.setFactoryKValues();
            params.mini_batch_kmeans_clustering.setFactoryKValues();
            params.ward_clustering.setFactoryKValues();
            params.spectral_clustering.setFactoryKValues();
            params.gmm_clustering.setFactoryKValues();
            params.db_scan_clustering.epsilon = new double[]{0.5};
            params.db_scan_clustering.min_sample_ratio = 0.1;
            params.hdb_scan_clustering.min_cluster_size_ratio = new double[]{0.01, 0.03, 0.1, 0.3};
            params.gmm_clustering.max_iterations = 100;
        }
        return params;
    }
}

