/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.prediction.flow;

import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.dataflow.kernel.master.BuildState;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PredictionSavedModelStateService {
    @Autowired
    private SavedModelsDAO savedModelsDAO;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private BuildState buildState;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.ml.savedmodels.state");

    public SavedModelState compute(SavedModel sm) {
        SavedModel currentSm;
        try (Transaction t = this.transactionService.beginRead();){
            currentSm = (SavedModel)this.savedModelsDAO.getMandatory(sm.projectKey, sm.id);
        }
        catch (IOException e) {
            logger.warn((Object)String.format("Could not retrieve settings of saved model %s", sm.id), (Throwable)e);
            return new SavedModelState(sm, false, true);
        }
        BuildState.DatasetBuildState bs = this.buildState.getDatasetBuildState(sm.projectKey, sm.id);
        boolean isBeingBuiltOrAboutToBeBuilt = bs != null && (bs.beingBuilt.size() > 0 || bs.aboutToBeBuilt.size() > 0);
        return new SavedModelState(currentSm, isBeingBuiltOrAboutToBeBuilt, false);
    }

    public static class SavedModelState {
        private final String smId;
        final boolean isBeingTrained;
        final boolean unknown;
        final long lastModifiedOn;

        SavedModelState(SavedModel sm, boolean isBeingTrained, boolean unknown) {
            this.smId = sm.id;
            this.unknown = unknown;
            this.lastModifiedOn = sm.versionTag != null ? sm.versionTag.getLastModifiedOn() : (sm.creationTag != null ? sm.creationTag.getLastModifiedOn() : 0L);
            this.isBeingTrained = isBeingTrained;
        }

        public String toString() {
            if (this.unknown) {
                return String.format("SMState(id=%s, unknown=true)", this.smId);
            }
            return String.format("SMState(id=%s, isBeingTrained=%s, lastModifiedOn=%s)", this.smId, this.isBeingTrained, this.lastModifiedOn);
        }
    }
}

