/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.datamodel.actual.databricks;

import com.dataiku.dip.apideployer.DeployerCodes;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractFullyManagedStatusReporter;
import com.dataiku.dip.apideployer.datamodel.actual.DeploymentHealth;
import com.dataiku.dip.apideployer.datamodel.actual.DeploymentStatusReport;
import com.dataiku.dip.apideployer.datamodel.actual.databricks.DatabricksDeploymentLocalSummary;
import com.dataiku.dip.apideployer.datamodel.actual.databricks.DatabricksDeploymentRemoteSummary;
import com.dataiku.dip.apideployer.datamodel.actual.databricks.DatabricksEndpointComparator;
import com.dataiku.dip.apideployer.datamodel.actual.databricks.DatabricksEndpointDetailsComparator;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.externalinfras.databricks.DatabricksUtils;
import com.dataiku.dip.externalinfras.databricks.datamodel.DatabricksServedEntity;
import com.dataiku.dip.externalinfras.databricks.datamodel.DatabricksServingEndpointBase;
import com.dataiku.dip.externalinfras.databricks.datamodel.DatabricksServingEndpointDetailedConfig;
import com.dataiku.dip.externalinfras.databricks.datamodel.DatabricksServingEndpointDetails;
import com.dataiku.dip.externalinfras.databricks.datamodel.DatabricksServingEndpointState;
import com.dataiku.dip.externalinfras.databricks.datamodel.DatabricksServingEndpointTrafficRoute;
import com.dataiku.dip.externalinfras.databricks.datamodel.actual.DatabricksEndpoint;
import com.dataiku.dip.externalinfras.databricks.datamodel.actual.DatabricksModelVersion;
import com.dataiku.dip.utils.DKULogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class DatabricksDeploymentStatusReporter
extends AbstractFullyManagedStatusReporter {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.deployment.actual.databricks.status-reporter");

    public DatabricksDeploymentStatusReporter(String deploymentId, String infraId) {
        super(infraId, deploymentId);
    }

    public DeploymentStatusReport computeBasicCheck(@Nonnull DatabricksDeploymentLocalSummary localSummary, @Nullable DatabricksServingEndpointBase remoteEndpoint, boolean isDeploymentEnabled) {
        DeploymentStatusReport deploymentStatusReport = new DeploymentStatusReport(this.deploymentId, this.infraId);
        deploymentStatusReport.statusMessages.mergeFrom(this.checkEndpointSync(localSummary.endpoint, remoteEndpoint));
        if (!deploymentStatusReport.statusMessages.isEmpty()) {
            deploymentStatusReport.isOutOfSync = true;
            deploymentStatusReport.setHealthWithSeverity(DeploymentHealth.OUT_OF_SYNC);
        }
        Pair<DeploymentHealth, InfoMessage.InfoMessages> healthReport = this.createEndpointHealthReport(localSummary, remoteEndpoint, isDeploymentEnabled);
        deploymentStatusReport.setHealthWithSeverity((DeploymentHealth)((Object)healthReport.getLeft()));
        deploymentStatusReport.statusMessages.mergeFrom((InfoMessage.InfoMessages)healthReport.getRight());
        return deploymentStatusReport;
    }

    public DeploymentStatusReport computeFullCheck(DatabricksDeploymentLocalSummary localSummary, DatabricksDeploymentRemoteSummary remoteSummary, boolean isDeploymentEnabled) {
        DatabricksServingEndpointDetails remoteEndpoint = remoteSummary.endpoint;
        DeploymentStatusReport fullStatusReport = new DeploymentStatusReport(this.deploymentId, this.infraId);
        fullStatusReport.statusMessages.mergeFrom(this.checkEndpointDetailsSync(localSummary, remoteEndpoint));
        if (!fullStatusReport.statusMessages.isEmpty()) {
            fullStatusReport.isOutOfSync = true;
            fullStatusReport.setHealthWithSeverity(DeploymentHealth.OUT_OF_SYNC);
        }
        Pair<DeploymentHealth, InfoMessage.InfoMessages> endpointStatusReport = this.createEndpointHealthReport(localSummary, remoteEndpoint, isDeploymentEnabled);
        fullStatusReport.setHealthWithSeverity((DeploymentHealth)((Object)endpointStatusReport.getLeft()));
        fullStatusReport.statusMessages.mergeFrom((InfoMessage.InfoMessages)endpointStatusReport.getRight());
        Pair<DeploymentHealth, InfoMessage.InfoMessages> trafficStatusReport = this.getTrafficHealthReport(localSummary, remoteEndpoint, isDeploymentEnabled);
        fullStatusReport.setHealthWithSeverity((DeploymentHealth)((Object)trafficStatusReport.getLeft()));
        fullStatusReport.statusMessages.mergeFrom((InfoMessage.InfoMessages)trafficStatusReport.getRight());
        return fullStatusReport;
    }

    private InfoMessage.InfoMessages checkEndpointSync(@Nullable DatabricksEndpoint localEndpoint, @Nullable DatabricksServingEndpointBase remoteEndpoint) {
        InfoMessage.InfoMessages endpointSyncMessages = new InfoMessage.InfoMessages();
        if (localEndpoint != null && remoteEndpoint != null) {
            DatabricksEndpointComparator endpointComparator = new DatabricksEndpointComparator(localEndpoint);
            if (endpointComparator.isOutOfSync(remoteEndpoint)) {
                for (String outOfSyncField : endpointComparator.reportOutOfSyncFields(remoteEndpoint)) {
                    logger.warnV("Databricks endpoint %s out of sync. %s", new Object[]{localEndpoint.name, outOfSyncField});
                    endpointSyncMessages.withWarningV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_OUT_OF_SYNC_CONFIG, outOfSyncField, new Object[0]);
                }
            } else {
                logger.debugV("Databricks endpoint %s is synchronized.", new Object[]{localEndpoint.name});
            }
        }
        return endpointSyncMessages;
    }

    private InfoMessage.InfoMessages checkEndpointDetailsSync(@Nonnull DatabricksDeploymentLocalSummary localSummary, @Nullable DatabricksServingEndpointDetails remoteEndpoint) {
        InfoMessage.InfoMessages endpointSyncMessages = new InfoMessage.InfoMessages();
        DatabricksEndpoint localEndpoint = localSummary.endpoint;
        if (localEndpoint != null && remoteEndpoint != null) {
            DatabricksEndpointDetailsComparator endpointComparator = new DatabricksEndpointDetailsComparator(localEndpoint, localSummary.modelVersion);
            if (endpointComparator.isOutOfSync(remoteEndpoint)) {
                for (String outOfSyncField : endpointComparator.reportOutOfSyncFields(remoteEndpoint)) {
                    logger.warnV("Databricks endpoint %s out of sync. %s", new Object[]{localEndpoint.name, outOfSyncField});
                    endpointSyncMessages.withWarningV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_OUT_OF_SYNC_CONFIG, outOfSyncField, new Object[0]);
                }
                if (remoteEndpoint.hasPendingConfig()) {
                    endpointSyncMessages.withWarningV((InfoMessage.MessageCode)DeployerCodes.INFO_API_DEPLOYER_DATABRICKS_ENDPOINT_CONFIG_UPDATE_IN_PROGRESS, "Using the pending configuration for computing the full-check report since the endpoint is not ready.", new Object[0]);
                }
            } else {
                logger.debugV("Databricks endpoint %s is synchronized.", new Object[]{localEndpoint.name});
            }
        }
        return endpointSyncMessages;
    }

    private Pair<DeploymentHealth, InfoMessage.InfoMessages> getTrafficHealthReport(@Nonnull DatabricksDeploymentLocalSummary localSummary, @Nullable DatabricksServingEndpointDetails remoteEndpoint, boolean isDeploymentEnabled) {
        List<Object> traffic;
        InfoMessage.InfoMessages trafficHealthMessages = new InfoMessage.InfoMessages();
        DeploymentHealth trafficHealth = DeploymentHealth.UNKNOWN;
        if (remoteEndpoint == null) {
            return new ImmutablePair((Object)trafficHealth, (Object)trafficHealthMessages);
        }
        String endpointName = remoteEndpoint.name;
        DatabricksServingEndpointDetailedConfig endpointConfig = remoteEndpoint.getLatestConfig();
        DatabricksModelVersion localModelVersion = localSummary.modelVersion;
        List<Object> list = traffic = endpointConfig != null ? endpointConfig.trafficConfig.routes : new ArrayList();
        if (isDeploymentEnabled) {
            Optional<DatabricksServedEntity> servedEntityOpt = DatabricksUtils.getServedEntity(localModelVersion, endpointConfig);
            String servedEntityName = servedEntityOpt.map(e -> e.name).orElse("");
            long trafficPercentageForDefinedServedEntity = servedEntityOpt.flatMap(servedEntity -> traffic.stream().filter(r -> r.servedModelName.equals(servedEntity.name)).findFirst()).map(route -> route.trafficPercentage).orElse(0L);
            if (traffic.isEmpty()) {
                trafficHealth = DeploymentHealth.UNHEALTHY;
                trafficHealthMessages.withErrorV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_MISSING_RESOURCE_CONFIG, "Unable to find model version '%s' in its associated Endpoint '%s'. Updating the deployment should delete invalid models (if any) and create a new one.", new Object[]{localModelVersion, endpointName});
            } else if (trafficPercentageForDefinedServedEntity == 0L) {
                trafficHealth = DeploymentHealth.UNHEALTHY;
                trafficHealthMessages.withErrorV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_DATABRICKS_ENDPOINT_TRAFFIC, "The traffic configured for the for model version '%s' associated to the Endpoint '%s' is set to %s%% instead of 100%%.", new Object[]{localModelVersion, endpointName, trafficPercentageForDefinedServedEntity});
            } else if (trafficPercentageForDefinedServedEntity != 100L) {
                trafficHealth = DeploymentHealth.WARNING;
                trafficHealthMessages.withWarningV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_DATABRICKS_ENDPOINT_TRAFFIC, "The traffic configured for the endpoint '%s' is set to %s%% instead of 100%% for model version '%s'.", new Object[]{endpointName, trafficPercentageForDefinedServedEntity, localModelVersion});
            }
            for (DatabricksServingEndpointTrafficRoute databricksServingEndpointTrafficRoute : traffic) {
                if (databricksServingEndpointTrafficRoute.servedModelName.equals(servedEntityName)) continue;
                trafficHealth = trafficHealth.getSeverer(DeploymentHealth.WARNING);
                trafficHealthMessages.withWarningV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_DATABRICKS_ENDPOINT_TRAFFIC, "Unexpected unmanaged served model named '%s' associated to the endpoint '%s'. Its traffic is set to %s%%. You might be incurring in unnecessary costs.", new Object[]{databricksServingEndpointTrafficRoute.servedModelName, endpointName, databricksServingEndpointTrafficRoute.trafficPercentage});
            }
        } else if (!traffic.isEmpty()) {
            trafficHealthMessages.withWarning((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_OUT_OF_SYNC_CONFIG, String.format("The deployment is disabled but the Databricks Endpoint '%s' exists and has a running model. Update your deployment to completely disable it.", endpointName));
            trafficHealth = DeploymentHealth.OUT_OF_SYNC;
        }
        return new ImmutablePair((Object)trafficHealth, (Object)trafficHealthMessages);
    }

    private Pair<DeploymentHealth, InfoMessage.InfoMessages> createEndpointHealthReport(@Nonnull DatabricksDeploymentLocalSummary localSummary, @Nullable DatabricksServingEndpointBase endpoint, boolean isDeploymentEnabled) {
        boolean shouldExist;
        boolean exists = endpoint != null;
        boolean bl = shouldExist = localSummary.endpoint != null && isDeploymentEnabled;
        if (!isDeploymentEnabled) {
            if (exists) {
                return this.getNotUpdatedDisabledDeploymentReport(endpoint);
            }
            return this.getDisabledDeploymentReport();
        }
        if (shouldExist) {
            if (exists) {
                return this.getExistingEndpointDeploymentReport(endpoint);
            }
            return this.getNonExistentEndpointDeploymentReport(localSummary.endpoint.name);
        }
        return this.getIncompleteDeploymentReport();
    }

    private Pair<DeploymentHealth, InfoMessage.InfoMessages> getNotUpdatedDisabledDeploymentReport(@Nonnull DatabricksServingEndpointBase endpoint) {
        return new ImmutablePair((Object)DeploymentHealth.OUT_OF_SYNC, (Object)new InfoMessage.InfoMessages().withWarningV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_OUT_OF_SYNC_CONFIG, "the deployment is disabled but the Databricks Endpoint '%s' exists. Update your deployment to completely disable it.", new Object[]{endpoint.name}));
    }

    private Pair<DeploymentHealth, InfoMessage.InfoMessages> getIncompleteDeploymentReport() {
        return new ImmutablePair((Object)DeploymentHealth.OUT_OF_SYNC, (Object)new InfoMessage.InfoMessages().withWarning((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_DEPLOYMENT_INCOMPLETE, ""));
    }

    private Pair<DeploymentHealth, InfoMessage.InfoMessages> getNonExistentEndpointDeploymentReport(String endpointName) {
        String message = "endpoint '%s' is not present in Databricks.";
        logger.warnV(message, new Object[]{endpointName});
        return new ImmutablePair((Object)DeploymentHealth.UNHEALTHY, (Object)new InfoMessage.InfoMessages().withErrorV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_MISSING_RESOURCE_CONFIG, message, new Object[]{endpointName}));
    }

    private Pair<DeploymentHealth, InfoMessage.InfoMessages> getDisabledDeploymentReport() {
        return new ImmutablePair((Object)DeploymentHealth.DISABLED, (Object)new InfoMessage.InfoMessages().withInfo((InfoMessage.MessageCode)DeployerCodes.INFO_API_DEPLOYER_FULLY_MANAGED_DISABLED_DEPLOYMENT, "update deployment settings to enable it again."));
    }

    private Pair<DeploymentHealth, InfoMessage.InfoMessages> getExistingEndpointDeploymentReport(@Nonnull DatabricksServingEndpointBase endpoint) {
        Pair<DeploymentHealth, InfoMessage.InfoMessages> report = new Pair<DeploymentHealth, InfoMessage.InfoMessages>((Object)DeploymentHealth.UNKNOWN, (Object)new InfoMessage.InfoMessages());
        if (endpoint.state.ready == DatabricksServingEndpointState.Readiness.READY) {
            report = this.getReadyEndpointDeploymentReport(endpoint);
        } else if (endpoint.state.ready == DatabricksServingEndpointState.Readiness.NOT_READY) {
            report = this.getNotReadyEndpointDeploymentReport(endpoint);
        }
        if (report.getLeft() == DeploymentHealth.UNKNOWN && ((InfoMessage.InfoMessages)report.getRight()).isEmpty()) {
            ((InfoMessage.InfoMessages)report.getRight()).withWarning((InfoMessage.MessageCode)DeployerCodes.INFO_API_DEPLOYER_DATABRICKS_ENDPOINT_UNKNOWN_STATE, String.format("deployment's status is '%s', and the endpoint config update's status is '%s'", new Object[]{endpoint.state.ready, endpoint.state.configUpdate}));
        }
        return report;
    }

    private Pair<DeploymentHealth, InfoMessage.InfoMessages> getReadyEndpointDeploymentReport(@Nonnull DatabricksServingEndpointBase endpoint) {
        MutablePair report = new MutablePair((Object)DeploymentHealth.UNKNOWN, (Object)new InfoMessage.InfoMessages());
        if (endpoint.state.configUpdate == DatabricksServingEndpointState.ConfigUpdate.NOT_UPDATING) {
            report.setLeft((Object)DeploymentHealth.HEALTHY);
        } else if (endpoint.state.configUpdate == DatabricksServingEndpointState.ConfigUpdate.UPDATE_FAILED) {
            report.setLeft((Object)DeploymentHealth.WARNING);
            ((InfoMessage.InfoMessages)report.right).withWarning((InfoMessage.MessageCode)DeployerCodes.INFO_API_DEPLOYER_DATABRICKS_ENDPOINT_CONFIG_UPDATE_FAILURE, "Check deployment and Databricks serving endpoint logs");
        } else if (endpoint.state.configUpdate == DatabricksServingEndpointState.ConfigUpdate.IN_PROGRESS) {
            report.setLeft((Object)DeploymentHealth.WARNING);
            ((InfoMessage.InfoMessages)report.right).withWarning((InfoMessage.MessageCode)DeployerCodes.INFO_API_DEPLOYER_DATABRICKS_ENDPOINT_CONFIG_UPDATE_IN_PROGRESS, "");
        } else if (endpoint.state.configUpdate == DatabricksServingEndpointState.ConfigUpdate.UPDATE_CANCELED) {
            report.setLeft((Object)DeploymentHealth.WARNING);
            ((InfoMessage.InfoMessages)report.right).withWarning((InfoMessage.MessageCode)DeployerCodes.INFO_API_DEPLOYER_DATABRICKS_ENDPOINT_CONFIG_UPDATE_CANCELED, "");
        }
        return report;
    }

    private Pair<DeploymentHealth, InfoMessage.InfoMessages> getNotReadyEndpointDeploymentReport(@Nonnull DatabricksServingEndpointBase endpoint) {
        MutablePair report = new MutablePair((Object)DeploymentHealth.UNKNOWN, (Object)new InfoMessage.InfoMessages());
        if (endpoint.state.configUpdate == DatabricksServingEndpointState.ConfigUpdate.IN_PROGRESS) {
            ((InfoMessage.InfoMessages)report.right).withInfo((InfoMessage.MessageCode)DeployerCodes.INFO_API_DEPLOYER_DATABRICKS_ENDPOINT_CONFIG_UPDATE_IN_PROGRESS, "");
        } else if (endpoint.state.configUpdate == DatabricksServingEndpointState.ConfigUpdate.UPDATE_FAILED) {
            report.setLeft((Object)DeploymentHealth.UNHEALTHY);
            ((InfoMessage.InfoMessages)report.right).withError((InfoMessage.MessageCode)DeployerCodes.INFO_API_DEPLOYER_DATABRICKS_ENDPOINT_CONFIG_UPDATE_FAILURE, "Check deployment and Databricks serving endpoint logs");
        } else {
            report.setLeft((Object)DeploymentHealth.UNHEALTHY);
            ((InfoMessage.InfoMessages)report.right).withError((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_DATABRICKS_UNHEALTHY_ENDPOINT, "the endpoint is not ready to receive queries, inspect its state");
        }
        return report;
    }
}

