/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections.aws;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.dataiku.dip.connections.ConnectionWithAWSAuthCredentials;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.EC2Connection;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.AuthCtxCreationService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import java.io.IOException;

@Deprecated
public class S3ConnectionAWSSessionCredentialsProvider
implements AWSCredentialsProvider {
    private final String authCtxIdentifier;
    private final String connectionName;

    public S3ConnectionAWSSessionCredentialsProvider(String authCtxIdentifier, String connectionName) {
        this.authCtxIdentifier = authCtxIdentifier;
        this.connectionName = connectionName;
    }

    @Override
    public void refresh() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AWSCredentials getCredentials() {
        TransactionService ts = (TransactionService)SpringUtils.getBean(TransactionService.class);
        try (Transaction t = ts.retrieveOrBeginRead();){
            ConnectionsDAO cdao = (ConnectionsDAO)SpringUtils.getBean(ConnectionsDAO.class);
            AuthCtxCreationService accs = (AuthCtxCreationService)SpringUtils.getBean(AuthCtxCreationService.class);
            AuthCtx authCtx = accs.create(this.authCtxIdentifier);
            EC2Connection conn = (EC2Connection)cdao.getConnection(authCtx, this.connectionName);
            ConnectionWithAWSAuthCredentials.SerializableAWSCredential sac = conn.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, null), ConnectionWithAWSAuthCredentials.SerializableAWSCredential.class);
            if (sac.sessionToken == null) {
                BasicDKUAWSCredentials basicDKUAWSCredentials = new BasicDKUAWSCredentials(sac.accessKey, sac.secretKey);
                return basicDKUAWSCredentials;
            }
            BasicDKUAWSSessionCredentials basicDKUAWSSessionCredentials = new BasicDKUAWSSessionCredentials(sac.accessKey, sac.secretKey, sac.sessionToken);
            return basicDKUAWSSessionCredentials;
        }
        catch (DKUSecurityException | IOException e) {
            throw new RuntimeException("Failed to get AWS credentials", e);
        }
    }

    public static class BasicDKUAWSCredentials
    implements AWSCredentials {
        private final String accessKey;
        private final String secretKey;

        public BasicDKUAWSCredentials(String accessKey, String secretKey) {
            this.accessKey = accessKey;
            this.secretKey = secretKey;
        }

        @Override
        public String getAWSAccessKeyId() {
            return this.accessKey;
        }

        @Override
        public String getAWSSecretKey() {
            return this.secretKey;
        }
    }

    public static class BasicDKUAWSSessionCredentials
    extends BasicDKUAWSCredentials
    implements AWSSessionCredentials {
        private final String sessionToken;

        public BasicDKUAWSSessionCredentials(String accessKey, String secretKey, String sessionToken) {
            super(accessKey, secretKey);
            this.sessionToken = sessionToken;
        }

        @Override
        public String getSessionToken() {
            return this.sessionToken;
        }
    }
}

