/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections.bigquery.simba;

import com.dataiku.dip.utils.ExceptionUtils;
import com.google.common.base.Preconditions;
import java.sql.SQLException;
import java.util.Iterator;

public class SQLExceptionHelper {
    private static final String SQL_EXCEPTION_MESSAGE_RATE_LIMIT = "Exceeded rate limits";

    public static boolean containsRateLimitError(SQLException sqlException) {
        Preconditions.checkNotNull((Object)sqlException);
        if (ExceptionUtils.getMessageWithCauses((Throwable)sqlException).contains(SQL_EXCEPTION_MESSAGE_RATE_LIMIT)) {
            return true;
        }
        Iterator<Throwable> iter = sqlException.iterator();
        while (iter.hasNext()) {
            if (!ExceptionUtils.getMessageWithCauses((Throwable)iter.next()).contains(SQL_EXCEPTION_MESSAGE_RATE_LIMIT)) continue;
            return true;
        }
        return false;
    }
}

