/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow;

import com.dataiku.dip.coremodel.JobDef;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.impl.FlowStateInternalDB;
import com.dataiku.dip.dataflow.ComputableHashComputer;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeHashComputer;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.GeneratorEvaluator;
import com.dataiku.dip.dataflow.pipeline.AbstractPipelineRunnableSubgraph;
import com.dataiku.dip.datasets.DatasetReadiness;
import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.server.services.ProjectsDAO;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang.NotImplementedException;
import org.intellij.lang.annotations.PrintFormat;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class ComputeRequiredRefreshOfSubgraphs {
    @Autowired
    protected DatasetsDAO dao;
    @Autowired
    protected RecipesDAO recipesDAO;
    @Autowired
    protected ProjectsDAO projectsDAO;
    @Autowired
    protected FlowStateInternalDB flowStateInternalDB;
    protected final ComputableHashComputer dtComputer;
    protected final RecipeHashComputer ttComputer;
    protected final JobActivity topLevelActivity;
    protected final JobDef jobDef;
    private SerializedProject project;
    protected Map<JobActivity, Boolean> requiredActivityCache = Maps.newHashMap();
    private Map<String, Boolean> generatorExecutionNeededCache = Maps.newHashMap();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.flow.compute.prune");

    public void setProject_ForTestsOnly(SerializedProject project) {
        this.project = project;
    }

    protected boolean cachedIsGeneratorExecutionNeeded(GeneratorEvaluator g, FlowComputable computable, Partition partition) throws Exception {
        String key = computable.getFullId() + "#" + (partition == null ? "NP" : partition.id());
        if (!this.generatorExecutionNeededCache.containsKey(key)) {
            this.generatorExecutionNeededCache.put(key, g.isExecutionNeeded(computable, partition));
        }
        return this.generatorExecutionNeededCache.get(key);
    }

    protected boolean allTargetsExist(DSSDBConnection conn, JobActivity item, int indentLevel) throws Exception {
        this.infoV(item, indentLevel, "checking target partitions existence", new Object[0]);
        if (item.getSubgraph() instanceof RecipeRunnableSubgraph || item.getSubgraph() instanceof AbstractPipelineRunnableSubgraph) {
            for (FlowComputable flowComputable : item.getSubgraph().getTargets()) {
                Partition targetP;
                DatasetReadiness targetPartitionHash = this.dtComputer.getCurrentContentHash(conn, flowComputable, targetP = item.getSubgraph().getTargetPartitions().get(flowComputable.getFullId()));
                if (targetPartitionHash.isReady()) continue;
                this.infoV(item, indentLevel, "target %s does not exist : activity is needed", this.prettyDSP(flowComputable, targetP));
                return false;
            }
            this.infoV(item, indentLevel, "all target partitions exist", new Object[0]);
            return true;
        }
        throw new NotImplementedException();
    }

    public ComputeRequiredRefreshOfSubgraphs(ComputableHashComputer dtComputer, RecipeHashComputer ttComputer, JobDef jobDef, JobActivity topLevelActivity) {
        this.dtComputer = dtComputer;
        this.ttComputer = ttComputer;
        this.jobDef = jobDef;
        this.topLevelActivity = topLevelActivity;
    }

    public final void prune() throws Exception {
        try (DSSDBConnection conn = this.flowStateInternalDB.acquireConnection();){
            this.pruneInternal(conn);
        }
    }

    public abstract void pruneInternal(DSSDBConnection var1) throws Exception;

    protected String prettyDSP(FlowComputable fds, Partition p) {
        if (p.getScheme() != null && p.getScheme().isPartitioned()) {
            return fds.getFullId() + "/" + p.id();
        }
        return fds.getFullId();
    }

    protected void throwSourceNotReady(FlowComputable fds, Partition p, Throwable notReadyError) {
        IllegalArgumentException e = ErrorContext.iaef((String)"Source dataset '%s' is not ready, can't build", (Object)this.prettyDSP(fds, p), (Object[])new Object[0]);
        if (notReadyError != null) {
            e = new IllegalArgumentException(e.getMessage(), notReadyError);
        }
        throw e;
    }

    protected boolean cacheAndReturnIsActivityRequired(JobActivity jobActivity, boolean isRequired) {
        this.requiredActivityCache.put(jobActivity, isRequired);
        return isRequired;
    }

    protected void infoV(JobActivity item, int indentLevel, @PrintFormat String format, Object ... args) {
        logger.infoV(DKUtils.indent((int)indentLevel) + "* " + item.id() + ": " + format, args);
    }

    protected void warnV(JobActivity item, int indentLevel, @PrintFormat String format, Object ... args) {
        logger.infoV(DKUtils.indent((int)indentLevel) + "* " + item.id() + ": " + format, args);
    }

    protected void errorV(JobActivity item, int indentLevel, @PrintFormat String format, Object ... args) {
        logger.infoV(DKUtils.indent((int)indentLevel) + "* " + item.id() + ": " + format, args);
    }

    protected SerializedProject getProjectUnsafe() throws IOException {
        if (this.project == null) {
            this.project = this.projectsDAO.getMandatoryUnsafe(this.jobDef.projectKey);
        }
        return this.project;
    }
}

