/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.join;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.ComputedColumnUtils;
import com.dataiku.dip.dataflow.exec.MultiEngineRecipeRunner;
import com.dataiku.dip.dataflow.exec.computedcolumn.ComputedColumn;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.dataflow.exec.h2.H2TemporarySQLConfig;
import com.dataiku.dip.dataflow.exec.join.JoinQueryGenerator;
import com.dataiku.dip.dataflow.exec.join.JoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.join.JoinRecipeSchemaComputer;
import com.dataiku.dip.dataflow.exec.joinlike.ColumnDesc;
import com.dataiku.dip.dataflow.exec.joinlike.JoinInputDescBase;
import com.dataiku.dip.dataflow.exec.joinlike.JoinLikeRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.joinlike.JoinOutputRole;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.recipes.ServiceUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.processors.transform.StringTransformation;
import com.dataiku.dip.sql.H2SQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class JoinRecipeHelper {
    @Autowired
    protected DatasetsDAO datasetsDAO;
    @Autowired
    protected VariablesService variablesService;
    @Autowired
    protected TransactionService transactionService;
    Map<String, SQLUtils.SQLTable> sqlTablesMap;
    Map<String, Dataset> datasetsMap;
    Map<Integer, List<SchemaColumn>> virtualColumnsByDataset;
    static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.join");

    public JoinRecipeHelper() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    private void expandParams(JoinRecipePayloadParams params, String projectKey) {
        VariablesContext vc = this.variablesService.getForProject(projectKey);
        for (JoinRecipePayloadParams.InputDesc vi : params.virtualInputs) {
            FilterDescUtils.expand(vi.preFilter, vc);
            ComputedColumnUtils.expand(vc, vi.getComputedColumns());
        }
        FilterDescUtils.expand(params.postFilter, vc);
        if (params.computedColumns != null) {
            ComputedColumnUtils.expand(vc, params.computedColumns);
        }
        if (params.joins != null) {
            for (JoinRecipePayloadParams.JoinDesc join : params.joins) {
                if (join == null || join.customSQLCondition == null) continue;
                join.customSQLCondition = vc.expand(join.customSQLCondition);
            }
        }
    }

    public String generateSQL(AuthCtx authCtx, JobActivity activity, SQLDialect dialect, JoinRecipePayloadParams params, boolean lowerCaseColumnsNames, JoinOutputRole role) throws Exception {
        Partition part;
        Dataset outputDS;
        HashMap<String, PartitioningScheme> sourcePartitionSchemes = new HashMap<String, PartitioningScheme>();
        HashMap<String, List<Partition>> sourcePartitions = new HashMap<String, List<Partition>>();
        PartitioningScheme targetPartitionScheme = null;
        if (MultiEngineRecipeRunner.shouldSpecifySourcePartitionInWhereClause(dialect, params.engineParams)) {
            for (FlowDataset fdSource : activity.getSubgraph().getSourceDatasets()) {
                Dataset source = fdSource.getMandatory(this.datasetsDAO);
                List<Partition> parts = activity.getSubgraph().getSourcePartitions(fdSource);
                if (parts == null || parts.size() <= 0 || parts.get(0).isAll() || parts.get(0).isNP() || !source.getPartitioningSchema().isPartitioned()) continue;
                sourcePartitionSchemes.put(source.getFullName(), source.getPartitioningSchema());
                sourcePartitions.put(source.getFullName(), parts);
            }
        }
        if (DatasetInspector.arePartitioningColumnsMandatoryInSchema(outputDS = activity.getSubgraph().getSingleTargetDataset().getMandatory(this.datasetsDAO)) && (part = activity.getSubgraph().getTargetPartition(activity.getSubgraph().getSingleTargetDataset())) != null && !part.isNP() && !part.isAll() && outputDS.getPartitioningSchema().isPartitioned()) {
            targetPartitionScheme = outputDS.getPartitioningSchema();
        }
        return this.generateSQL(authCtx, activity, dialect, params, lowerCaseColumnsNames, sourcePartitionSchemes, sourcePartitions, targetPartitionScheme, outputDS, role);
    }

    protected String generateSQLIgnorePartitioning(AuthCtx authCtx, JobActivity activity, SQLDialect dialect, JoinRecipePayloadParams params, boolean lowerCaseColumnsNames, JoinOutputRole role) throws Exception {
        return this.generateSQL(authCtx, activity, dialect, params, lowerCaseColumnsNames, null, null, null, null, role);
    }

    protected String generateSQLIgnorePartitioning_NT(AuthCtx authCtx, JobActivity activity, SQLDialect dialect, JoinRecipePayloadParams params, boolean lowerCaseColumnsNames, JoinOutputRole role) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            String string = this.generateSQL(authCtx, activity, dialect, params, lowerCaseColumnsNames, null, null, null, null, role);
            return string;
        }
    }

    protected String generateSQL(AuthCtx authCtx, JobActivity activity, SQLDialect dialect, JoinRecipePayloadParams params, boolean lowerCaseColumnsNames, Map<String, PartitioningScheme> sourcePartitionSchemes, Map<String, List<Partition>> sourcePartitions, PartitioningScheme targetPartitionScheme, Dataset target, JoinOutputRole role) throws Exception {
        Schema inferredOutputSchema = this.inferOutputSchema(authCtx, activity, params, role);
        Dataset targetWithInferredOutputSchema = target == null ? new Dataset().withSchema(inferredOutputSchema) : ((Dataset)JSON.deepCopy((Object)target)).withSchema(inferredOutputSchema);
        this.initAliases(params, lowerCaseColumnsNames);
        JoinQueryGenerator sqlGenerator = new JoinQueryGenerator(params, this.datasetsMap, this.sqlTablesMap, targetWithInferredOutputSchema, role);
        sqlGenerator.setPartitioning(sourcePartitionSchemes, sourcePartitions, targetPartitionScheme);
        if (this.virtualColumnsByDataset != null) {
            sqlGenerator.setVirtualColumns(this.virtualColumnsByDataset);
        }
        if (dialect instanceof H2SQLDialect) {
            sqlGenerator.ignoreFilterTranslationError(true);
        }
        if (target != null) {
            this.checkSchemaConsistency(params, target.getSchema(), role, sqlGenerator);
        }
        return sqlGenerator.generateSQL(dialect);
    }

    private void checkSchemaConsistency(JoinRecipePayloadParams params, Schema outputSchema, JoinOutputRole role, JoinQueryGenerator joinQueryGenerator) {
        switch (role) {
            case MAIN: {
                int computedColumnsNb;
                int n = computedColumnsNb = params.computedColumns == null ? 0 : params.computedColumns.size();
                if (params.getSelectedColumns().size() + computedColumnsNb <= outputSchema.columns.size()) break;
                throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCOMPATIBLE_SCHEMA, String.format("Expected %s columns but output schema contains %s. Try to propagate the schema of the input(s) dataset(s) first.", params.getSelectedColumns().size() + computedColumnsNb, outputSchema.columns.size()));
            }
            case UNMATCHED_ROWS_LEFT: {
                int unmatchedTableIndex = ((JoinRecipePayloadParams.JoinDesc)params.joins.get((int)0)).table1;
                List<String> unmatchedLeftColumns = joinQueryGenerator.getAllColumnsNamesForInputDataset(unmatchedTableIndex);
                if (unmatchedLeftColumns.size() <= outputSchema.columns.size()) break;
                throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCOMPATIBLE_SCHEMA, String.format("Expected %s columns but left unmatched output schema contains %s. Try to propagate the schema of the input(s) dataset(s) first.", unmatchedLeftColumns.size(), outputSchema.columns.size()));
            }
            case UNMATCHED_ROWS_RIGHT: {
                int unmatchedTableIndex = ((JoinRecipePayloadParams.JoinDesc)params.joins.get((int)0)).table2;
                List<String> unmatchedRightColumns = joinQueryGenerator.getAllColumnsNamesForInputDataset(unmatchedTableIndex);
                if (unmatchedRightColumns.size() <= outputSchema.columns.size()) break;
                throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCOMPATIBLE_SCHEMA, String.format("Expected %s columns but right unmatched output schema contains %s. Try to propagate the schema of the input(s) dataset(s) first.", unmatchedRightColumns.size(), outputSchema.columns.size()));
            }
        }
    }

    private Schema inferOutputSchema(AuthCtx authCtx, JobActivity activity, JoinRecipePayloadParams params, JoinOutputRole role) throws Exception {
        JoinRecipeSchemaComputer schemaComputer = new JoinRecipeSchemaComputer(authCtx, activity);
        schemaComputer.setParams(params);
        return schemaComputer.getSchema(role);
    }

    public static void unicizeTableAliases(JoinLikeRecipePayloadParams<?, ?, ?> params) {
        HashSet<String> usedNames = new HashSet<String>(params.virtualInputs.size());
        for (JoinInputDescBase t : params.virtualInputs) {
            String tableId = StringUtils.isNotBlank((String)t.alias) ? t.alias : t.name;
            tableId = tableId.replace('.', '_');
            int n = 2;
            Object newTableId = tableId;
            while (usedNames.contains(((String)newTableId).toLowerCase())) {
                newTableId = tableId + "_" + n++;
            }
            t.alias = newTableId;
            usedNames.add(((String)newTableId).toLowerCase());
        }
    }

    public static void computeColumnAliases(JoinLikeRecipePayloadParams<?, ?, ?> params, boolean lowerCase) {
        if (params.getSelectedColumns() != null) {
            for (ColumnDesc cd : params.getSelectedColumns()) {
                cd.alias = JoinRecipeHelper.computeColumnAlias(cd, ((JoinInputDescBase)params.virtualInputs.get((int)cd.table)).prefix, lowerCase);
            }
        }
    }

    public static String computeColumnAlias(ColumnDesc columnDesc, String prefix, boolean lowerCase) {
        Object computedAlias = StringUtils.isBlank((String)columnDesc.alias) ? (StringUtils.isNotBlank((String)prefix) ? prefix + "_" + columnDesc.name : columnDesc.name) : columnDesc.alias;
        if (lowerCase && StringUtils.isNotBlank((String)computedAlias)) {
            computedAlias = ((String)computedAlias).toLowerCase();
        }
        return computedAlias;
    }

    protected void initAliases(JoinRecipePayloadParams params, boolean lowerCase) {
        JoinRecipeHelper.unicizeTableAliases(params);
        JoinRecipeHelper.computeColumnAliases(params, lowerCase);
    }

    public void initInputDatasets(JobActivity activity, JoinRecipePayloadParams params, boolean builtinEngine, SQLDialect dialect, boolean caseInsensitive) throws IOException {
        Preconditions.checkNotNull((Object)params, (Object)"No params");
        Preconditions.checkNotNull((Object)params.virtualInputs, (Object)"No inputs");
        this.sqlTablesMap = new HashMap<String, SQLUtils.SQLTable>();
        this.datasetsMap = new HashMap<String, Dataset>();
        for (JoinRecipePayloadParams.InputDesc vi : params.virtualInputs) {
            Dataset source = ServiceUtils.getDataset(activity, this.datasetsDAO, vi.name);
            logger.trace(() -> "Register dataset " + vi.name + " : " + JSON.json((Object)source));
            if (builtinEngine) {
                Dataset h2Source = new Dataset();
                h2Source.setFullName(source.getFullName());
                H2TemporarySQLConfig fakeConfig = new H2TemporarySQLConfig();
                fakeConfig.table = source.getFullName();
                fakeConfig.mode = "table";
                fakeConfig.setAssumedJavaTzForUnknownTz("UTC");
                h2Source.setParams(fakeConfig);
                Schema sourceSchema = (Schema)JSON.deepCopy((Object)source.getSchema());
                sourceSchema.columns.stream().forEach(sc -> {
                    sc.timestampNoTzAsDate = false;
                });
                h2Source.setSchema(sourceSchema);
                this.datasetsMap.put(vi.name, h2Source);
                this.sqlTablesMap.put(vi.name, new SQLUtils.SQLTable(null, null, source.getFullName(), false));
                continue;
            }
            this.datasetsMap.put(vi.name, source);
            SQLUtils.SQLTable table = DatasetUtils.getResolvedTableWithSparkSQLFallback(source, dialect, params.engineParams);
            this.sqlTablesMap.put(vi.name, table);
        }
        params.resolveSelectedColumns(this.datasetsMap, caseInsensitive);
    }

    public static <T extends JoinLikeRecipePayloadParams<?, ?, ?>> T resolveDatasetNames(T params, SerializedRecipe sr) {
        AnyLoc loc;
        ArrayList<String> datasets = new ArrayList<String>(sr.getFlatInputs().size());
        for (SerializedRecipe.RecipeInput in : sr.getFlatInputs()) {
            loc = AnyLoc.resolveSmart(sr.projectKey, in.ref);
            datasets.add(loc.getFullName());
        }
        for (int i = 0; i < params.virtualInputs.size(); ++i) {
            JoinInputDescBase vi = (JoinInputDescBase)params.virtualInputs.get(i);
            if (vi.index < 0 || vi.index >= datasets.size()) {
                throw ErrorContext.iae((String)("Recipes inputs are incorrect. Input index: " + vi.index));
            }
            loc = DatasetLocUtils.resolveFull((String)datasets.get(vi.index));
            vi.name = loc.getFullName();
            vi.alias = ((DatasetLocUtils.DatasetLoc)loc).getName();
        }
        return params;
    }

    public JoinRecipePayloadParams loadParams(String payload, SerializedRecipe sr) {
        JoinRecipePayloadParams params = (JoinRecipePayloadParams)JSON.parse((String)payload, JoinRecipePayloadParams.class);
        Preconditions.checkNotNull((Object)params, (Object)"Empty parameters");
        this.expandParams(params, sr.projectKey);
        return JoinRecipeHelper.resolveDatasetNames(params, sr);
    }

    protected void sanitizeColumnNormalization(JoinRecipePayloadParams params) {
        for (JoinRecipePayloadParams.JoinDesc join : params.joins) {
            for (JoinRecipePayloadParams.MatchingCondition condition : join.getJoinConditions()) {
                if (!condition.caseInsensitive && !condition.normalizeText) continue;
                JoinRecipePayloadParams.InputDesc table1Desc = (JoinRecipePayloadParams.InputDesc)params.virtualInputs.get(join.table1);
                JoinRecipePayloadParams.InputDesc table2Desc = (JoinRecipePayloadParams.InputDesc)params.virtualInputs.get(join.table2);
                Dataset source1 = this.datasetsMap.get(table1Desc.name);
                Dataset source2 = this.datasetsMap.get(table2Desc.name);
                if (source1 == null || source2 == null) continue;
                SchemaColumn schemaColumn1 = ExpressionUtils.getSchemaColumn(condition.column1.name, source1.getSchema(), table1Desc.computedColumns);
                SchemaColumn schemaColumn2 = ExpressionUtils.getSchemaColumn(condition.column2.name, source2.getSchema(), table2Desc.computedColumns);
                Type type1 = schemaColumn1.getType();
                Type type2 = schemaColumn2.getType();
                if (!type1.isNumericOrBoolean() || !type2.isNumericOrBoolean()) continue;
                logger.info((Object)("Text normalization is not needed on " + JSON.json((Object)condition) + ", removing"));
                condition.normalizeText = false;
                condition.caseInsensitive = false;
            }
        }
    }

    protected SimpleIndexes getAndPrepareIndexes(JoinRecipePayloadParams params) {
        String virtualColumnPrefix = this.getUnusedPrefix(this.collectAllColumnNames(params));
        this.sanitizeColumnNormalization(params);
        SimpleIndexes ret = new SimpleIndexes();
        for (JoinRecipePayloadParams.JoinDesc join : params.joins) {
            List<JoinRecipePayloadParams.MatchingCondition> indexableConditions = join.getIndexableConditions();
            JoinRecipePayloadParams.InputDesc table1Desc = (JoinRecipePayloadParams.InputDesc)params.virtualInputs.get(join.table1);
            JoinRecipePayloadParams.InputDesc table2Desc = (JoinRecipePayloadParams.InputDesc)params.virtualInputs.get(join.table2);
            Dataset source1 = this.datasetsMap.get(table1Desc.name);
            Dataset source2 = this.datasetsMap.get(table2Desc.name);
            if (source1 == null || source2 == null) continue;
            indexableConditions = indexableConditions.stream().filter(m -> table1Desc.getComputedColumns().stream().noneMatch(c2 -> c2.name.equals(m.column1.name)) && table2Desc.getComputedColumns().stream().noneMatch(c2 -> c2.name.equals(m.column2.name))).collect(Collectors.toList());
            if ((indexableConditions = indexableConditions.stream().filter(m -> !(source1.getSchema().getColumn(m.column1.name) == null && !ret.virtualColumns.stream().anyMatch(c2 -> c2.virtualColumnName.equals(m.column1.name)) || source2.getSchema().getColumn(m.column2.name) == null && !ret.virtualColumns.stream().anyMatch(c2 -> c2.virtualColumnName.equals(m.column2.name)))).collect(Collectors.toList())).isEmpty()) continue;
            HashSet newVirtualColumns = Sets.newHashSet();
            for (JoinRecipePayloadParams.MatchingCondition condition : indexableConditions) {
                if (!condition.caseInsensitive && !condition.normalizeText) continue;
                SimpleVirtualColumn virtualColumn1 = new SimpleVirtualColumn();
                virtualColumn1.datasetIndex = table1Desc.index;
                virtualColumn1.inputColumnName = condition.column1.name;
                virtualColumn1.transformation = condition.normalizeText ? StringTransformation.NORMALIZE_SQLLIKE : StringTransformation.TO_LOWER;
                newVirtualColumns.add(virtualColumn1);
                SimpleVirtualColumn virtualColumn2 = new SimpleVirtualColumn();
                virtualColumn2.datasetIndex = table2Desc.index;
                virtualColumn2.inputColumnName = condition.column2.name;
                virtualColumn2.transformation = condition.normalizeText ? StringTransformation.NORMALIZE_SQLLIKE : StringTransformation.TO_LOWER;
                newVirtualColumns.add(virtualColumn2);
            }
            for (SimpleVirtualColumn virtualColumn : newVirtualColumns) {
                if (ret.virtualColumns.contains(virtualColumn)) continue;
                virtualColumn.virtualColumnName = String.format("%s_%s_%s_%s", virtualColumnPrefix, virtualColumn.datasetIndex, virtualColumn.transformation == StringTransformation.NORMALIZE_SQLLIKE ? "n" : "l", virtualColumn.inputColumnName);
                ret.virtualColumns.add(virtualColumn);
            }
            for (JoinRecipePayloadParams.MatchingCondition condition : indexableConditions) {
                if (condition.normalizeText) {
                    this.replaceByVirtualColumn(ret.virtualColumns, StringTransformation.NORMALIZE_SQLLIKE, table1Desc, table2Desc, condition);
                } else if (condition.caseInsensitive) {
                    this.replaceByVirtualColumn(ret.virtualColumns, StringTransformation.TO_LOWER, table1Desc, table2Desc, condition);
                }
                condition.caseInsensitive = false;
                condition.normalizeText = false;
            }
            SimpleIndexDef sid = new SimpleIndexDef();
            sid.table = this.sqlTablesMap.get(table1Desc.name);
            sid.columns = indexableConditions.stream().map(c2 -> c2.column1.name).collect(Collectors.toList());
            ret.definitions.add(sid);
            sid = new SimpleIndexDef();
            sid.table = this.sqlTablesMap.get(table2Desc.name);
            sid.columns = indexableConditions.stream().map(c2 -> c2.column2.name).collect(Collectors.toList());
            ret.definitions.add(sid);
        }
        this.virtualColumnsByDataset = Maps.newHashMap();
        for (SimpleVirtualColumn column : ret.virtualColumns) {
            List datasetVirtualColumns = this.virtualColumnsByDataset.computeIfAbsent(column.datasetIndex, index -> Lists.newArrayList());
            datasetVirtualColumns.add(new SchemaColumn(column.virtualColumnName, Type.STRING));
        }
        return ret;
    }

    private void replaceByVirtualColumn(Set<SimpleVirtualColumn> virtualColumns, StringTransformation transformation, JoinRecipePayloadParams.InputDesc table1Desc, JoinRecipePayloadParams.InputDesc table2Desc, JoinRecipePayloadParams.MatchingCondition condition) {
        for (SimpleVirtualColumn virtualColumn : virtualColumns.stream().filter(c2 -> c2.transformation == transformation).collect(Collectors.toList())) {
            if (virtualColumn.datasetIndex == table1Desc.index && StringUtils.equals((String)virtualColumn.inputColumnName, (String)condition.column1.name)) {
                condition.column1.name = virtualColumn.virtualColumnName;
            }
            if (virtualColumn.datasetIndex != table2Desc.index || !StringUtils.equals((String)virtualColumn.inputColumnName, (String)condition.column2.name)) continue;
            condition.column2.name = virtualColumn.virtualColumnName;
        }
    }

    private Set<String> collectAllColumnNames(JoinRecipePayloadParams params) {
        HashSet allColumnNames = Sets.newHashSet();
        for (Dataset source : this.datasetsMap.values()) {
            for (SchemaColumn sc : source.getSchema().getColumns()) {
                allColumnNames.add(sc.getName());
            }
        }
        for (JoinRecipePayloadParams.InputDesc inputDesc : params.virtualInputs) {
            for (ComputedColumn computedColumn : inputDesc.getComputedColumns()) {
                allColumnNames.add(computedColumn.name);
            }
        }
        return allColumnNames;
    }

    private String getUnusedPrefix(Set<String> columnNames) {
        Object prefix = "virtual_";
        int i = 0;
        while (this.prefixIsUsed((String)prefix, columnNames)) {
            prefix = "virtual" + i + "_";
            ++i;
        }
        return prefix;
    }

    private boolean prefixIsUsed(String prefix, Set<String> columnNames) {
        return columnNames.stream().anyMatch(c2 -> c2.startsWith(prefix));
    }

    protected static class SimpleIndexes {
        public Set<SimpleIndexDef> definitions = Sets.newHashSet();
        public Set<SimpleVirtualColumn> virtualColumns = Sets.newHashSet();

        protected SimpleIndexes() {
        }
    }

    public static class SimpleVirtualColumn {
        public int datasetIndex;
        public String inputColumnName;
        public String virtualColumnName;
        public StringTransformation transformation;

        public int hashCode() {
            return Objects.hash(this.datasetIndex, this.inputColumnName, this.transformation);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SimpleVirtualColumn other = (SimpleVirtualColumn)obj;
            return this.datasetIndex == other.datasetIndex && Objects.equals(this.inputColumnName, other.inputColumnName) && this.transformation == other.transformation;
        }
    }

    protected static class SimpleIndexDef {
        public SQLUtils.SQLTable table;
        public List<String> columns;

        protected SimpleIndexDef() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.columns == null ? 0 : this.columns.hashCode());
            result = 31 * result + (this.table == null ? 0 : this.table.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SimpleIndexDef other = (SimpleIndexDef)obj;
            return Objects.equals(this.table, other.table) && Objects.equals(this.columns, other.columns);
        }
    }
}

