/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sync;

import com.dataiku.dip.connections.AzureConnection;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataflow.exec.sync.CloudToSnowflake;
import com.dataiku.dip.dataflow.exec.sync.SnowflakeToCloud;
import com.dataiku.dip.datasets.fs.AzureBlobDatasetHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.sql.SnowflakeSQLDialect;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.PathUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class SnowflakeToWASB
extends SnowflakeToCloud<AzureBlobDatasetHandler> {
    @Autowired
    private PasswordEncryptionService symetricCryptoService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.sync.snowflaketowasb");

    public SnowflakeToWASB() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public static void setCompatible(Dataset inputDS, Dataset outputDS, RecipeEngineStatus status) {
        status.isSelectable = true;
        try {
            SnowflakeToWASB.checkCompatible(inputDS, outputDS, "Azure");
        }
        catch (SnowflakeToCloud.SnowflakeCloudFastpathImpossibleException e) {
            status.markAsNonSelectable(e.getMessage(), RecipeEngineStatus.WarningLevel.ERROR);
        }
    }

    @Override
    protected String getTemporaryTablePrefix() {
        return "synctoazure";
    }

    @Override
    protected String createDestinationRootUri(AzureBlobDatasetHandler azureDh) throws IOException, DKUSecurityException, CodedException {
        String providerRoot = azureDh.getRootPathForSnowflakeFastPath();
        return PathUtils.slashes((String)providerRoot, null, (Boolean)true, (boolean)false, null);
    }

    @Override
    @VisibleForTesting
    boolean containsDateColumn(Dataset dataset) {
        return dataset.getSchema().columns.stream().anyMatch(schemaColumn -> schemaColumn.getType().isTemporal());
    }

    @Override
    protected String generateCopyStatementToCloud(String inputTableFullName, String outputFSPath, CloudToSnowflake.CopyMode mode, AzureBlobDatasetHandler blobDSHandler, StringBuilder displayableSql) throws DKUSecurityException, IOException {
        String displayCreds;
        String creds;
        AzureConnection azure = blobDSHandler.getConnection();
        if (StringUtils.isEmpty((String)azure.params.sasToken) && StringUtils.isEmpty((String)azure.params.snowflakeStorageIntegration) && !outputFSPath.startsWith("@")) {
            throw new SnowflakeToCloud.SnowflakeCloudFastpathImpossibleException(String.format("Cannot generate fastpath statement: SAS token, external stage, or storage integration is not defined for connection: %s", azure.name));
        }
        if (outputFSPath.startsWith("@")) {
            creds = "";
            displayCreds = "";
        } else if (StringUtils.isNotBlank((String)azure.params.snowflakeStorageIntegration)) {
            SnowflakeSQLDialect dialect = new SnowflakeSQLDialect();
            displayCreds = creds = String.format("   STORAGE_INTEGRATION=%s", dialect.quoteIdentifier(azure.params.snowflakeStorageIntegration));
        } else {
            AzureConnection.SerializableAzureStorageAccountCredentials azureCreds = azure.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(this.authCtx, this.contextProjectKey), AzureConnection.SerializableAzureStorageAccountCredentials.class);
            creds = String.format("   CREDENTIALS=(azure_sas_token='%s')", azureCreds.sasToken);
            displayCreds = "   CREDENTIALS=(****)";
        }
        String copyQueryPattern = "COPY INTO '%s' FROM %s   %s   %s   FILE_FORMAT = (%s)   OVERWRITE = TRUE";
        String formatOptions = mode.generateFormatOptions();
        String commonOptions = mode.generateFromSnowflakeCommonOptions();
        String displayableStatement = String.format(copyQueryPattern, outputFSPath, inputTableFullName, displayCreds, commonOptions, formatOptions);
        logger.info((Object)displayableStatement);
        displayableSql.append(displayableStatement);
        return String.format(copyQueryPattern, outputFSPath, inputTableFullName, creds, commonOptions, formatOptions);
    }
}

