/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.graphtools;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.graph.utils.GraphIds;
import com.dataiku.dip.dataflow.graphtools.AbstractFlowTool;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.NavigatorService;
import com.dataiku.dip.server.services.ReadOnlyJobsInternalDB;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class LastBuildDurationView
extends AbstractFlowTool.FlowView {
    @Autowired
    private NavigatorService navigatorService;
    private LastBuildDurationViewState state;

    public LastBuildDurationView(AuthCtx authCtx, String projectKey) {
        super(authCtx, projectKey);
    }

    @Override
    public AbstractFlowTool.FlowState getFlowState(JsonObject options) throws Exception {
        if (this.state != null) {
            Collection<String> currentFocus = this.state.focused;
            this.computeState();
            this.state.focused = currentFocus;
        } else {
            this.computeState();
        }
        return this.state;
    }

    @Override
    public synchronized LastBuildDurationViewState computeState() throws Exception {
        List recipes;
        this.state = new LastBuildDurationViewState();
        try (Transaction tr = this.transactionService.beginRead();){
            recipes = this.recipesDAO.listUnsafe(this.projectKey);
        }
        for (SerializedRecipe recipe : recipes) {
            FutureProgressState.checkInterrupt();
            String nodeId = GraphIds.forRecipe(recipe.name);
            ReadOnlyJobsInternalDB.ObjectBuild ob = this.navigatorService.getRecipeLastSuccessfulBuild(recipe);
            if (ob == null) continue;
            this.add(nodeId, ob.buildEndTime - ob.buildStartTime);
        }
        return this.state;
    }

    @Override
    public void setFocus(Collection<String> focused) throws Exception {
        if (this.state == null) {
            this.computeState();
        }
        this.state.focused = focused == null ? new HashSet<String>() : focused;
    }

    private void add(String nodeId, Long lastBuildDuration) {
        this.state.valueByNode.put(nodeId, lastBuildDuration);
    }

    public class LastBuildDurationViewState
    implements AbstractFlowTool.FlowState {
        Map<String, Long> valueByNode = new HashMap<String, Long>();
        public Collection<String> focused = new HashSet<String>();
    }
}

