/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.streaming;

import com.dataiku.dip.DSSStartedEvent;
import com.dataiku.dip.autorestart.AutoRestartingLoopThread;
import com.dataiku.dip.autorestart.AutoRestartingProcessState;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.ContinuousActivitiesPersistentStateDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.dataflow.streaming.ContinuousActivity;
import com.dataiku.dip.dataflow.streaming.slave.ContinuousActivityMonitor;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.model.PublicAPIKey;
import com.dataiku.dip.server.api.auth.PublicAPIKeysService;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.notifications.backend.ContinuousActivityStateChangedEvent;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Service;

@Service
public class ContinuousActivitiesManager
implements ApplicationListener<DSSStartedEvent> {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ContinuousActivitiesPersistentStateDAO dao;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private UsersService usersService;
    @Autowired
    private PublicAPIKeysService publicApiKeyService;
    Map<String, ContinuousActivityMonitor> monitors = new HashMap<String, ContinuousActivityMonitor>();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.streaming.manager");

    public void onApplicationEvent(DSSStartedEvent dssStartedEvent) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    logger.debug((Object)"Init continuous activities manager");
                    Change c2 = ContinuousActivitiesManager.this.computeUpdatePersistentStateFromPossibleActivities();
                    if (c2.addedSomething || c2.removedButStillInState.size() > 0) {
                        try (RWTransaction rwt = ContinuousActivitiesManager.this.transactionService.beginWriteAsDSS();){
                            ContinuousActivitiesManager.this.dao.save(c2.newState);
                            rwt.commit("Resynced continuous activities persistent state");
                        }
                    }
                    Thread.sleep(15000L);
                    for (ContinuousActivitiesPersistentStateDAO.ContinuousActivityPersistentState activity : c2.newState.activities) {
                        if (activity.desiredState != ContinuousActivitiesPersistentStateDAO.DesiredState.STARTED || activity.loopParams.abortAfterCrashes >= 0) continue;
                        logger.info((Object)("Re-starting activity " + activity.projectKey + "." + activity.recipeId + " after backend start"));
                        if (StringUtils.isBlank((String)activity.startedBy)) {
                            logger.warn((Object)"Last initiator of the continuous activity not stored, skipping");
                            continue;
                        }
                        try {
                            DSSAuthCtx authCtx;
                            block23: {
                                try (Transaction t = ContinuousActivitiesManager.this.transactionService.beginRead();){
                                    UsersDAO.User user = ContinuousActivitiesManager.this.usersService.getInternalUserOrNullUnsafe(activity.startedBy);
                                    if (user != null) {
                                        authCtx = DSSAuthCtx.forUserLogin(user);
                                        break block23;
                                    }
                                    if (activity.startedBy.startsWith("api:")) {
                                        PublicAPIKey apiKey = ContinuousActivitiesManager.this.publicApiKeyService.getKeyById(activity.startedBy.substring(4));
                                        if (apiKey != null) {
                                            authCtx = DSSAuthCtx.forAPIKey(apiKey);
                                            break block23;
                                        }
                                        throw new DKUSecurityException("Cannot restart activity, started by unknown api key");
                                    }
                                    throw new DKUSecurityException("Cannot restart activity, started by unknown auth context");
                                }
                            }
                            ContinuousActivitiesManager.this.start_NT(authCtx, activity.projectKey, activity.recipeId);
                        }
                        catch (Exception e) {
                            logger.error((Object)"Failed to restart activity, skipping", (Throwable)e);
                        }
                    }
                    logger.debug((Object)"Done init continuous activities manager");
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to init continuous activities manager", (Throwable)e);
                }
            }
        }).start();
    }

    private void addToPersistentStateIfNeeded(String projectKey, String recipeId) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        ContinuousActivitiesPersistentStateDAO.ContinuousActivityPersistentState ps2 = null;
        try (Transaction t = this.transactionService.beginRead();){
            ps2 = this.getPersistentState(projectKey, recipeId);
        }
        if (ps2 == null) {
            logger.info((Object)("Adding " + projectKey + " " + recipeId + " to persistent state"));
            try (RWTransaction rwt = this.transactionService.beginWriteAsDSS();){
                ContinuousActivitiesPersistentStateDAO.ContinuousActivitiesPersistentState state = (ContinuousActivitiesPersistentStateDAO.ContinuousActivitiesPersistentState)JSON.deepCopy((Object)this.dao.getUnsafe());
                SerializedRecipe sr = (SerializedRecipe)this.recipesDAO.getMandatoryUnsafe(projectKey, recipeId);
                ps2 = new ContinuousActivitiesPersistentStateDAO.ContinuousActivityPersistentState();
                ps2.projectKey = projectKey;
                ps2.recipeId = recipeId;
                ps2.recipeType = sr.type;
                ps2.desiredState = ContinuousActivitiesPersistentStateDAO.DesiredState.STOPPED;
                state.activities.add(ps2);
                this.dao.save(state);
                rwt.commit("Added " + projectKey + " " + recipeId + " to persistent state");
            }
        }
    }

    private Change computeUpdatePersistentStateFromPossibleActivities() throws IOException {
        List<String> projectKeyList;
        ContinuousActivitiesPersistentStateDAO.ContinuousActivitiesPersistentState state;
        Change ret = new Change();
        try (Transaction t = this.transactionService.beginRead();){
            state = (ContinuousActivitiesPersistentStateDAO.ContinuousActivitiesPersistentState)JSON.deepCopy((Object)this.dao.getUnsafe());
            projectKeyList = this.projectsService.listKeys();
        }
        HashSet<CallSite> allExisting = new HashSet<CallSite>();
        logger.info((Object)"Start scanning for continuous activities");
        for (String projectKey : projectKeyList) {
            logger.info((Object)("> scan continuous activities in " + projectKey));
            try {
                Transaction t = this.transactionService.beginRead();
                try {
                    for (SerializedRecipe sr : this.recipesDAO.listUnsafe(projectKey)) {
                        RecipeMeta rm2 = RecipeRegistry.getMeta(sr.type);
                        if (!rm2.isContinuous()) continue;
                        allExisting.add((CallSite)((Object)(projectKey + "__DKU__" + sr.name)));
                        boolean found = false;
                        for (ContinuousActivitiesPersistentStateDAO.ContinuousActivityPersistentState ps2 : state.activities) {
                            if (!ps2.projectKey.equals(projectKey) || !ps2.recipeId.equals(sr.name)) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        ContinuousActivitiesPersistentStateDAO.ContinuousActivityPersistentState ps3 = new ContinuousActivitiesPersistentStateDAO.ContinuousActivityPersistentState();
                        ps3.projectKey = projectKey;
                        ps3.recipeId = sr.name;
                        ps3.recipeType = sr.type;
                        ps3.desiredState = ContinuousActivitiesPersistentStateDAO.DesiredState.STOPPED;
                        state.activities.add(ps3);
                        ret.addedSomething = true;
                    }
                }
                finally {
                    if (t == null) continue;
                    t.close();
                }
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to sync continuous activities in " + projectKey), (Throwable)e);
            }
        }
        ListIterator<ContinuousActivitiesPersistentStateDAO.ContinuousActivityPersistentState> it = state.activities.listIterator();
        while (it.hasNext()) {
            ContinuousActivitiesPersistentStateDAO.ContinuousActivityPersistentState ps4 = it.next();
            String key = ps4.projectKey + "__DKU__" + ps4.recipeId;
            if (allExisting.contains(key)) continue;
            ret.removedButStillInState.add(ps4);
            it.remove();
        }
        ret.newState = state;
        return ret;
    }

    private ContinuousActivitiesPersistentStateDAO.ContinuousActivityPersistentState getPersistentState(String projectKey, String recipeId) throws Exception {
        ContinuousActivitiesPersistentStateDAO.ContinuousActivitiesPersistentState state = this.dao.getUnsafe();
        for (ContinuousActivitiesPersistentStateDAO.ContinuousActivityPersistentState ps2 : state.activities) {
            if (!ps2.projectKey.equals(projectKey) || !ps2.recipeId.equals(recipeId)) continue;
            return (ContinuousActivitiesPersistentStateDAO.ContinuousActivityPersistentState)JSON.deepCopy((Object)ps2);
        }
        return null;
    }

    private boolean updatePersistentState(String projectKey, String recipeId, ContinuousActivitiesPersistentStateDAO.ContinuousActivityPersistentState newState) throws Exception {
        ContinuousActivitiesPersistentStateDAO.ContinuousActivitiesPersistentState state = this.dao.getUnsafe();
        ListIterator<ContinuousActivitiesPersistentStateDAO.ContinuousActivityPersistentState> it = state.activities.listIterator();
        while (it.hasNext()) {
            ContinuousActivitiesPersistentStateDAO.ContinuousActivityPersistentState ps2 = it.next();
            if (!ps2.projectKey.equals(projectKey) || !ps2.recipeId.equals(recipeId)) continue;
            it.set(newState);
            return true;
        }
        return false;
    }

    private void deletePersistentState(String projectKey, String recipeId) throws Exception {
        ContinuousActivitiesPersistentStateDAO.ContinuousActivitiesPersistentState state = this.dao.getUnsafe();
        ListIterator<ContinuousActivitiesPersistentStateDAO.ContinuousActivityPersistentState> it = state.activities.listIterator();
        while (it.hasNext()) {
            ContinuousActivitiesPersistentStateDAO.ContinuousActivityPersistentState ps2 = it.next();
            if (!ps2.projectKey.equals(projectKey) || !ps2.recipeId.equals(recipeId)) continue;
            it.remove();
            break;
        }
    }

    private void deletePersistentStates(String projectKey) throws Exception {
        ContinuousActivitiesPersistentStateDAO.ContinuousActivitiesPersistentState state = this.dao.getUnsafe();
        ListIterator<ContinuousActivitiesPersistentStateDAO.ContinuousActivityPersistentState> it = state.activities.listIterator();
        while (it.hasNext()) {
            ContinuousActivitiesPersistentStateDAO.ContinuousActivityPersistentState ps2 = it.next();
            if (!ps2.projectKey.equals(projectKey)) continue;
            it.remove();
            break;
        }
    }

    public ContinuousActivitiesCurrentState getGlobalState() throws Exception {
        ContinuousActivitiesCurrentState ret = new ContinuousActivitiesCurrentState();
        ContinuousActivitiesPersistentStateDAO.ContinuousActivitiesPersistentState state = null;
        try (Transaction t = this.transactionService.beginRead();){
            state = this.dao.getUnsafe();
        }
        for (ContinuousActivitiesPersistentStateDAO.ContinuousActivityPersistentState ps2 : state.activities) {
            ContinuousActivityCurrentState cs2 = (ContinuousActivityCurrentState)JSON.parse((String)JSON.json((Object)ps2), ContinuousActivityCurrentState.class);
            ContinuousActivityMonitor monitor = this.getOrCreateMonitor(ps2.projectKey, ps2.recipeId);
            cs2.mainLoopState = monitor.getState();
            ret.activities.add(cs2);
        }
        return ret;
    }

    public ContinuousActivitiesCurrentState listProjectStates_autoTxn(String projectKey) throws Exception {
        ContinuousActivitiesCurrentState ret = new ContinuousActivitiesCurrentState();
        ContinuousActivitiesPersistentStateDAO.ContinuousActivitiesPersistentState state = null;
        if (TransactionContext.hasAttachedTransaction()) {
            state = this.dao.getUnsafe();
        } else {
            try (Transaction t = this.transactionService.beginRead();){
                state = this.dao.getUnsafe();
            }
        }
        for (ContinuousActivitiesPersistentStateDAO.ContinuousActivityPersistentState ps2 : state.activities) {
            if (!ps2.projectKey.equals(projectKey)) continue;
            ContinuousActivityCurrentState cs2 = (ContinuousActivityCurrentState)JSON.parse((String)JSON.json((Object)ps2), ContinuousActivityCurrentState.class);
            ContinuousActivityMonitor monitor = this.getOrCreateMonitor(ps2.projectKey, ps2.recipeId);
            cs2.mainLoopState = monitor.getState();
            ret.activities.add(cs2);
        }
        return ret;
    }

    public List<ContinuousActivitiesPersistentStateDAO.ContinuousActivityPersistentState> listProjectPersistentStates_T(String projectKey) throws Exception {
        ArrayList ret = Lists.newArrayList();
        for (ContinuousActivitiesPersistentStateDAO.ContinuousActivityPersistentState ps2 : this.dao.getUnsafe().activities) {
            if (!ps2.projectKey.equals(projectKey)) continue;
            ret.add(ps2);
        }
        return ret;
    }

    public ContinuousActivityCurrentState getStateOrNull(String projectKey, String recipeId) throws Exception {
        ContinuousActivitiesPersistentStateDAO.ContinuousActivitiesPersistentState state = null;
        try (Transaction t = this.transactionService.beginRead();){
            state = this.dao.getUnsafe();
        }
        for (ContinuousActivitiesPersistentStateDAO.ContinuousActivityPersistentState ps2 : state.activities) {
            if (!ps2.projectKey.equals(projectKey) || !ps2.recipeId.equals(recipeId)) continue;
            ContinuousActivityCurrentState cs2 = (ContinuousActivityCurrentState)JSON.parse((String)JSON.json((Object)ps2), ContinuousActivityCurrentState.class);
            ContinuousActivityMonitor monitor = this.getOrCreateMonitor(ps2.projectKey, ps2.recipeId);
            cs2.mainLoopState = monitor.getState();
            return cs2;
        }
        return null;
    }

    public ContinuousActivityCurrentState getState(String projectKey, String recipeId) throws Exception {
        ContinuousActivityCurrentState state = this.getStateOrNull(projectKey, recipeId);
        if (state != null) {
            return state;
        }
        throw new NotFoundException("Activity not found: " + projectKey + " " + recipeId);
    }

    private synchronized ContinuousActivityMonitor getOrCreateMonitor(String projectKey, String recipeId) {
        String key = projectKey + "__DKU__" + recipeId;
        ContinuousActivityMonitor cam = this.monitors.get(key);
        if (cam == null) {
            ContinuousActivity ce = new ContinuousActivity();
            ce.projectKey = projectKey;
            ce.recipeId = recipeId;
            cam = new ContinuousActivityMonitor(ce);
            this.monitors.put(key, cam);
        }
        return cam;
    }

    public FutureResponse<AutoRestartingProcessState> start_NT(AuthCtx authCtx, String projectKey, String recipeId) throws Exception {
        return this.start_NT(authCtx, projectKey, recipeId, null);
    }

    public FutureResponse<AutoRestartingProcessState> start_NT(AuthCtx authCtx, String projectKey, String recipeId, AutoRestartingLoopThread.AutoRestartingLoopParams lp) throws Exception {
        this.addToPersistentStateIfNeeded(projectKey, recipeId);
        StreamingEndpointService.checkFeatureFlag();
        ContinuousActivitiesPersistentStateDAO.ContinuousActivityPersistentState state = null;
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            state = this.getPersistentState(projectKey, recipeId);
            assert (state != null);
            state.desiredState = ContinuousActivitiesPersistentStateDAO.DesiredState.STARTED;
            state.startedOn = System.currentTimeMillis();
            state.startedBy = authCtx.getIdentifier();
            if (lp != null) {
                state.loopParams = lp;
            }
            if (this.updatePersistentState(projectKey, recipeId, state)) {
                this.dao.save(this.dao.getUnsafe());
            }
            t.commit("Started continuous activity " + projectKey + " / " + recipeId);
        }
        this.pubSub.publish(new ContinuousActivityStateChangedEvent(authCtx, state));
        ContinuousActivityMonitor monitor = this.getOrCreateMonitor(projectKey, recipeId);
        return monitor.stopAndStart(authCtx, state.loopParams);
    }

    public void stop_NT(AuthCtx authCtx, String projectKey, String recipeId) throws Exception {
        ContinuousActivitiesPersistentStateDAO.ContinuousActivityPersistentState state = null;
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            state = this.getPersistentState(projectKey, recipeId);
            if (state == null) {
                logger.info((Object)("Continuous activity " + recipeId + " was never started, nothing to do"));
            } else {
                state.desiredState = ContinuousActivitiesPersistentStateDAO.DesiredState.STOPPED;
                state.startedOn = null;
                state.startedBy = null;
                if (this.updatePersistentState(projectKey, recipeId, state)) {
                    this.dao.save(this.dao.getUnsafe());
                }
                t.commit("Stopped continuous activity " + projectKey + " / " + recipeId);
            }
        }
        if (state != null) {
            this.pubSub.publish(new ContinuousActivityStateChangedEvent(authCtx, state));
        }
        ContinuousActivityMonitor monitor = this.getOrCreateMonitor(projectKey, recipeId);
        monitor.stop();
    }

    public void deleteIfNeeded_T(String projectKey, String recipeId) throws Exception {
        ContinuousActivitiesPersistentStateDAO.ContinuousActivityPersistentState state = null;
        state = this.getPersistentState(projectKey, recipeId);
        if (state != null) {
            this.deletePersistentState(projectKey, recipeId);
            ContinuousActivityMonitor monitor = this.getOrCreateMonitor(projectKey, recipeId);
            monitor.stop();
        }
    }

    public void deleteForProject(String projectKey) throws Exception {
        for (ContinuousActivityCurrentState state : this.listProjectStates_autoTxn((String)projectKey).activities) {
            ContinuousActivityMonitor monitor = this.getOrCreateMonitor(projectKey, state.recipeId);
            monitor.stop();
        }
        this.deletePersistentStates(projectKey);
    }

    static class Change {
        boolean addedSomething;
        List<ContinuousActivitiesPersistentStateDAO.ContinuousActivityPersistentState> removedButStillInState = new ArrayList<ContinuousActivitiesPersistentStateDAO.ContinuousActivityPersistentState>();
        ContinuousActivitiesPersistentStateDAO.ContinuousActivitiesPersistentState newState;

        Change() {
        }
    }

    public static class ContinuousActivitiesCurrentState {
        public List<ContinuousActivityCurrentState> activities = new ArrayList<ContinuousActivityCurrentState>();
    }

    public static class ContinuousActivityCurrentState
    extends ContinuousActivitiesPersistentStateDAO.ContinuousActivityPersistentState {
        public AutoRestartingProcessState mainLoopState;

        public void stripFutureIds() {
            if (this.mainLoopState != null) {
                this.mainLoopState.futureId = null;
                if (this.mainLoopState.futureInfo != null) {
                    this.mainLoopState.futureInfo.jobId = null;
                }
            }
        }
    }
}

