/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.coremodel.Checklists;
import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.coremodel.ObjectCustomMetadata;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.datalineage.ManualDataLineage;
import com.dataiku.dip.dataquality.DataQualityRuleSet;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.labeling.ImageViewSettings;
import com.dataiku.dip.metrics.ProbesSet;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.polyjson.RichJsonReader;
import com.dataiku.dip.utils.polyjson.RichJsonWriter;
import com.dataiku.dip.variables.OverrideTable;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum SerializedDatasetAdapter implements TypeAdapterFactory
{
    INSTANCE;

    private static final Map<String, Class<? extends DatasetHandler.DatasetParams>> datasetParamsMap;
    private static final Map<String, Class<? extends FormatParams>> formatParamsMap;

    public static void registerType(String type, Class<? extends DatasetHandler.DatasetParams> stepParamClass) {
        datasetParamsMap.put(type, stepParamClass);
    }

    public static void deregisterType(String type) {
        datasetParamsMap.remove(type);
    }

    public static void registerFormatType(String type, Class<? extends FormatParams> stepParamClass) {
        formatParamsMap.put(type, stepParamClass);
    }

    public static void deregisterFormatType(String type) {
        formatParamsMap.remove(type);
    }

    public <U> TypeAdapter<U> create(final Gson gson, TypeToken<U> typeToken) {
        if (!SerializedDataset.class.equals((Object)typeToken.getRawType())) {
            return null;
        }
        final boolean includesFileTransient = gson.toJsonTree((Object)new JSON.FileExclusionPolicyTest()).getAsJsonObject().has("test");
        final TypeAdapter schemaAdapter = gson.getAdapter(Schema.class);
        final TypeAdapter typeSystemVersionAdapter = gson.getAdapter(SerializedDataset.TypeSystemVersion.class);
        final TypeAdapter partitioningAdapter = gson.getAdapter(PartitioningScheme.class);
        final TypeAdapter listOfStringAdapter = gson.getAdapter((TypeToken)new TypeToken<List<String>>(){});
        final TypeAdapter checklistsAdapter = gson.getAdapter(Checklists.class);
        final TypeAdapter listOfSerializedCheckAdapter = gson.getAdapter((TypeToken)new TypeToken<List<SerializedDataset.SerializedCheck>>(){});
        final TypeAdapter remoteFilesAdapter = gson.getAdapter(SerializedDataset.RemoteFiles.class);
        final TypeAdapter listOfCustomDatabaseProperty = gson.getAdapter((TypeToken)new TypeToken<List<AbstractSQLConnection.CustomDatabaseProperty>>(){});
        final TypeAdapter flowOptionsAdapter = gson.getAdapter(SerializedDataset.FlowOptions.class);
        final TypeAdapter readWriteOptionsAdapter = gson.getAdapter(SerializedDataset.ReadWriteOptions.class);
        final TypeAdapter overrideTableAdapter = gson.getAdapter(OverrideTable.class);
        final TypeAdapter versionTagAdapter = gson.getAdapter(VersionTag.class);
        final TypeAdapter objectCustomMetadataAdapter = gson.getAdapter(ObjectCustomMetadata.class);
        final TypeAdapter probesSetAdapter = gson.getAdapter(ProbesSet.class);
        final TypeAdapter dataQualityRuleSetAdapter = gson.getAdapter(DataQualityRuleSet.class);
        final TypeAdapter jsonObjectAdapter = gson.getAdapter(JsonObject.class);
        final TypeAdapter imageViewSettingsTypeAdapter = gson.getAdapter(ImageViewSettings.class);
        final TypeAdapter manualDataLineageAdapter = gson.getAdapter(ManualDataLineage.class);
        return new TypeAdapter<SerializedDataset>(){

            public void write(JsonWriter jsonWriter, SerializedDataset sds) throws IOException {
                RichJsonWriter writer = RichJsonWriter.fromWriter((JsonWriter)jsonWriter);
                writer.beginObject();
                writer.writeProperty("type", sds.type);
                writer.writeProperty("managed", sds.managed);
                writer.writeProperty("featureGroup", sds.featureGroup);
                if (includesFileTransient) {
                    writer.writeProperty("name", sds.name);
                    writer.writeProperty("smartName", sds.smartName);
                    writer.writeProperty("projectKey", sds.projectKey);
                }
                writer.writeProperty("autodetectedFormatId", sds.autodetectedFormatId);
                writer.writeProperty("description", sds.description);
                writer.writeProperty("shortDesc", sds.shortDesc);
                writer.writeProperty("formatType", sds.formatType);
                writer.writeProperty(checklistsAdapter, "checklists", (Object)sds.checklists);
                writer.writeProperty(listOfSerializedCheckAdapter, "checks", sds.checks);
                writer.writeProperty(objectCustomMetadataAdapter, "customMeta", (Object)sds.customMeta);
                writer.writeProperty(flowOptionsAdapter, "flowOptions", (Object)sds.flowOptions);
                writer.writeProperty(readWriteOptionsAdapter, "readWriteOptions", (Object)sds.readWriteOptions);
                writer.writeProperty(gson, "formatParams", (Object)sds.getFormatParams());
                writer.writeProperty(partitioningAdapter, "partitioning", (Object)sds.partitioning);
                writer.writeProperty(overrideTableAdapter, "overrideTable", (Object)sds.overrideTable);
                writer.writeProperty(versionTagAdapter, "versionTag", (Object)sds.versionTag);
                writer.writeProperty(versionTagAdapter, "creationTag", (Object)sds.creationTag);
                writer.writeProperty(listOfStringAdapter, "tags", (Object)sds.tags);
                writer.writeProperty(remoteFilesAdapter, "remoteFiles", (Object)sds.remoteFiles);
                writer.writeProperty(gson, "params", (Object)sds.getParams());
                writer.writeProperty(schemaAdapter, "schema", (Object)sds.getSchema());
                writer.writeProperty(typeSystemVersionAdapter, "typeSystemVersion", (Object)sds.typeSystemVersion);
                writer.writeProperty(listOfCustomDatabaseProperty, "dkuProperties", sds.dkuProperties);
                writer.writeProperty(probesSetAdapter, "metrics", (Object)sds.getMetrics());
                writer.writeProperty(dataQualityRuleSetAdapter, "metricsChecks", (Object)sds.getDataQualityRuleSet());
                writer.writeProperty(jsonObjectAdapter, "customFields", (Object)sds.customFields);
                writer.writeProperty(imageViewSettingsTypeAdapter, "imageViewSettings", (Object)sds.imageViewSettings);
                writer.writeProperty("dataSteward", sds.dataSteward);
                writer.writeProperty(manualDataLineageAdapter, "manualDataLineage", (Object)sds.manualDataLineage);
                writer.endObject();
            }

            private void readProperty(RichJsonReader reader, String propertyName, SerializedDataset sds) throws IOException {
                switch (propertyName) {
                    case "projectKey": {
                        sds.projectKey = reader.nextStringOrNull();
                        break;
                    }
                    case "name": {
                        sds.name = reader.nextStringOrNull();
                        break;
                    }
                    case "smartName": {
                        sds.smartName = reader.nextStringOrNull();
                        break;
                    }
                    case "managed": {
                        sds.managed = !reader.isNullValue() && reader.nextBoolean();
                        break;
                    }
                    case "featureGroup": {
                        sds.featureGroup = !reader.isNullValue() && reader.nextBoolean();
                        break;
                    }
                    case "schema": {
                        sds.setSchema((Schema)reader.nextJsonElement(schemaAdapter));
                        break;
                    }
                    case "typeSystemVersion": {
                        sds.typeSystemVersion = (SerializedDataset.TypeSystemVersion)((Object)reader.nextJsonElement(typeSystemVersionAdapter));
                        break;
                    }
                    case "partitioning": {
                        sds.partitioning = (PartitioningScheme)reader.nextJsonElement(partitioningAdapter);
                        break;
                    }
                    case "tags": {
                        sds.tags = (List)reader.nextJsonElement(listOfStringAdapter);
                        break;
                    }
                    case "checklists": {
                        sds.checklists = (Checklists)reader.nextJsonElement(checklistsAdapter);
                        break;
                    }
                    case "description": {
                        sds.description = reader.nextStringOrNull();
                        break;
                    }
                    case "autodetectedFormatId": {
                        sds.autodetectedFormatId = reader.nextStringOrNull();
                        break;
                    }
                    case "shortDesc": {
                        sds.shortDesc = reader.nextStringOrNull();
                        break;
                    }
                    case "remoteFiles": {
                        sds.remoteFiles = (SerializedDataset.RemoteFiles)reader.nextJsonElement(remoteFilesAdapter);
                        break;
                    }
                    case "dkuProperties": {
                        sds.dkuProperties = (List)reader.nextJsonElement(listOfCustomDatabaseProperty);
                        break;
                    }
                    case "flowOptions": {
                        sds.flowOptions = (SerializedDataset.FlowOptions)reader.nextJsonElement(flowOptionsAdapter);
                        break;
                    }
                    case "readWriteOptions": {
                        sds.readWriteOptions = (SerializedDataset.ReadWriteOptions)reader.nextJsonElement(readWriteOptionsAdapter);
                        break;
                    }
                    case "overrideTable": {
                        sds.overrideTable = (OverrideTable)reader.nextJsonElement(overrideTableAdapter);
                        break;
                    }
                    case "versionTag": {
                        sds.versionTag = (VersionTag)reader.nextJsonElement(versionTagAdapter);
                        break;
                    }
                    case "creationTag": {
                        sds.creationTag = (VersionTag)reader.nextJsonElement(versionTagAdapter);
                        break;
                    }
                    case "customMeta": {
                        sds.customMeta = (ObjectCustomMetadata)reader.nextJsonElement(objectCustomMetadataAdapter);
                        break;
                    }
                    case "metrics": {
                        sds.setMetricsRaw(reader.nextJsonElement(), (arg_0, arg_1) -> ((Gson)gson).fromJson(arg_0, arg_1));
                        break;
                    }
                    case "metricsChecks": {
                        sds.setDataQualityRuleSetRaw(reader.nextJsonElement(), (arg_0, arg_1) -> ((Gson)gson).fromJson(arg_0, arg_1));
                        break;
                    }
                    case "customFields": {
                        sds.customFields = (JsonObject)reader.nextJsonElement(jsonObjectAdapter);
                        break;
                    }
                    case "imageViewSettings": {
                        sds.imageViewSettings = (ImageViewSettings)reader.nextJsonElement(imageViewSettingsTypeAdapter);
                        break;
                    }
                    case "checks": {
                        sds.checks = (List)reader.nextJsonElement(listOfSerializedCheckAdapter);
                        break;
                    }
                    case "type": {
                        sds.type = reader.nextStringOrNull();
                        break;
                    }
                    case "params": {
                        Class<? extends DatasetHandler.DatasetParams> datasetParamsClass;
                        if (sds.type == null) {
                            reader.skipValueAndLookaheadProperty("type", () -> this.readProperty(reader, "type", sds));
                        }
                        if ((datasetParamsClass = datasetParamsMap.get(sds.type)) != null) {
                            sds.setParams((DatasetHandler.DatasetParams)reader.nextJsonElement(gson, datasetParamsClass));
                            break;
                        }
                        reader.skipValue();
                        break;
                    }
                    case "formatType": {
                        sds.formatType = reader.nextStringOrNull();
                        break;
                    }
                    case "formatParams": {
                        Class<? extends FormatParams> formatParamsClass;
                        if (sds.formatType == null) {
                            reader.skipValueAndLookaheadProperty("formatType", () -> this.readProperty(reader, "formatType", sds));
                        }
                        if ((formatParamsClass = formatParamsMap.get(sds.formatType)) != null) {
                            sds.setFormatParams((FormatParams)reader.nextJsonElement(gson, formatParamsClass));
                            break;
                        }
                        reader.skipValue();
                        break;
                    }
                    case "dataSteward": {
                        sds.dataSteward = reader.nextStringOrNull();
                        break;
                    }
                    case "manualDataLineage": {
                        sds.manualDataLineage = (ManualDataLineage)reader.nextJsonElement(manualDataLineageAdapter);
                        break;
                    }
                    default: {
                        reader.skipValue();
                    }
                }
            }

            public SerializedDataset read(JsonReader unwrappedReader) throws IOException {
                RichJsonReader reader = RichJsonReader.fromReader((JsonReader)unwrappedReader);
                SerializedDataset sds = new SerializedDataset();
                reader.beginObject();
                while (reader.hasNext()) {
                    this.readProperty(reader, reader.nextName(), sds);
                }
                reader.endObject();
                return sds;
            }
        }.nullSafe();
    }

    static {
        datasetParamsMap = Collections.synchronizedMap(new HashMap());
        formatParamsMap = Collections.synchronizedMap(new HashMap());
    }
}

