/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.dynamic;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datasets.DatasetSelectionToMemTable;
import com.dataiku.dip.datasets.SamplingParam;
import com.dataiku.dip.datasets.SingleThreadPusherToMemTable;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.PerfUtils;

public class SmallDatasetEasyLoadHelper {
    public static MemTable load_AutoTXN(AuthCtx authCtx, AnyLoc loc, int maxRecords) throws Exception {
        SerializedDataset sd;
        PerfUtils.markSlowCode();
        TransactionService transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
        DatasetsDAO datasetsDAO = (DatasetsDAO)SpringUtils.getBean(DatasetsDAO.class);
        try (Transaction t = transactionService.retrieveOrBeginRead();){
            sd = (SerializedDataset)datasetsDAO.getMandatory(loc);
        }
        Dataset dataset = Dataset.fromSerialized(sd);
        MemTable mt = new MemTable();
        SingleThreadPusherToMemTable stmt = new SingleThreadPusherToMemTable(authCtx, dataset, mt, true);
        DatasetSelectionToMemTable dsmt = new DatasetSelectionToMemTable();
        dsmt.samplingMethod = SamplingParam.SamplingMethod.HEAD_SEQUENTIAL;
        dsmt.maxRecords = maxRecords > 0 ? (long)(maxRecords + 1) : -1L;
        stmt.setDatasetSelection(dsmt);
        stmt.push();
        if (maxRecords > 0 && stmt.getProcessedRowCount() > (long)maxRecords) {
            throw new IllegalArgumentException("The number of rows in the parameters dataset exceeds the limit of " + maxRecords);
        }
        return mt;
    }
}

