/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import java.io.IOException;
import java.util.regex.Matcher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FSProviderService {
    @Autowired
    private ConnectionsDAO connectionsDAO;

    public FSProviderTypeProvider getFSProviderTypeProvider(AuthCtx authCtx, String connectionId) throws IOException, DKUSecurityException {
        FSProviderTypeProvider ret = new FSProviderTypeProvider();
        ret.connectionId = connectionId;
        Matcher matcher = ConnectionsDAO.virtualConnectionPattern.matcher(connectionId);
        if (matcher.matches()) {
            ret.providerType = matcher.group(1);
            ret.isCustom = true;
        } else {
            DSSConnection c2;
            ret.connection = c2 = this.connectionsDAO.getMandatoryConnection(authCtx, connectionId);
            ret.providerType = c2.getMainManagedDatasetType();
            ret.isCustom = false;
        }
        return ret;
    }

    public static class FSProviderTypeProvider {
        public String connectionId;
        public String providerType;
        public DSSConnection connection;
        public boolean isCustom;
    }
}

