/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.sharepointonline;

import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.SharePointOnlineConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.datasets.SchemaDetection;
import com.dataiku.dip.datasets.sharepointonline.SharePointOnlineListDatasetHandler;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.naming.ASCIITransliterator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.server.SerializedMemTableSimple;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.Pair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class SharePointOnlineListDatasetTestHandler
implements DatasetTestHandler {
    @Autowired
    private DatasetsDAO dao;
    @Autowired
    private TransactionService transactionService;
    private SharePointOnlineListDatasetHandler handler;
    private AuthCtx authCtx;
    private static final Pattern startWithAlphanumOrUnderscore = Pattern.compile("^[a-zA-Z_]{1}");
    private static DKULogger logger = DKULogger.getLogger((String)"dku.sharepointonline");

    public SharePointOnlineListDatasetTestHandler(AuthCtx authCtx, SharePointOnlineListDatasetHandler handler) {
        this.authCtx = authCtx;
        this.handler = handler;
    }

    @Override
    public void close() throws IOException {
        if (this.handler != null) {
            try {
                this.handler.close();
            }
            finally {
                this.handler = null;
            }
        }
    }

    public TestResult getSites(String projectKey, Dataset dataset) throws Exception {
        TestResult result = new TestResult();
        return result;
    }

    public TestResult getLists(String projectKey, Dataset dataset, String siteId) throws Exception {
        TestResult result = new TestResult();
        return result;
    }

    public TestResult test(String projectKey, Dataset dataset, boolean connectionOnly, boolean forConsistencyCheck, boolean inferStorageTypes) throws Exception {
        assert (SharePointOnlineListDatasetHandler.META.getType().equals(dataset.getType()));
        logger.info((Object)("Testing, dataset = " + dataset.getName() + " connectionOnly = " + connectionOnly));
        TestResult result = new TestResult();
        result.testedConnectionOnly = true;
        result.sharePointSites = new ArrayList<SharePointOnlineConnection.SharePointOnlineClient.CustomSite>();
        result.sharePointLists = new ArrayList<SharePointOnlineConnection.SharePointOnlineClient.CustomList>();
        try (DatasetHandler dhForName = DatasetHandlerFactory.build(this.authCtx, dataset);){
            result.suggestedName = DatasetInspector.slufigyAndUnicize(projectKey, dhForName.suggestName(), this.dao, this.transactionService);
        }
        SharePointOnlineListDatasetHandler.Config config = dataset.getParamsAs(SharePointOnlineListDatasetHandler.Config.class);
        String siteSearch = config.siteSearch;
        if (StringUtils.isBlank((String)config.connection)) {
            throw new IllegalArgumentException("missing connection name");
        }
        ConnectionsDAO connectionsDAO = (ConnectionsDAO)SpringUtils.getBean(ConnectionsDAO.class);
        SharePointOnlineConnection conn = connectionsDAO.getMandatoryConnectionAs(this.authCtx, config.connection, SharePointOnlineConnection.class);
        ProxySettings proxySettings = conn.getProxySettings();
        SharePointOnlineConnection.SharePointOnlineClient sharePointClient = null;
        try {
            sharePointClient = conn.getSharePointOnlineClient(this.authCtx, proxySettings);
        }
        catch (Exception e) {
            result.connectionErrorMsg = "Could not connect to SharePoint Online: " + ExceptionUtils.getMessageWithCauses((Throwable)e);
            logger.warn((Object)"Could not connect to SharePoint Online", (Throwable)e);
            return result;
        }
        List<SharePointOnlineConnection.SharePointOnlineClient.CustomSite> sites = new ArrayList<SharePointOnlineConnection.SharePointOnlineClient.CustomSite>();
        if (StringUtils.isBlank((String)siteSearch) && StringUtils.isBlank((String)config.siteId)) {
            result.sharePointSites = sites;
            result.connectionOK = true;
            return result;
        }
        if (StringUtils.isBlank((String)siteSearch) && StringUtils.isNotBlank((String)config.siteId)) {
            SharePointOnlineConnection.SharePointOnlineClient.CustomSite site = sharePointClient.getSiteById(config.siteId);
            sites.add(site);
            result.sharePointSites = sites;
            result.connectionOK = true;
        } else {
            try {
                sites = sharePointClient.getSites(siteSearch);
            }
            catch (Exception e) {
                result.connectionErrorMsg = "Could not retrieve list of available sites: " + ExceptionUtils.getMessageWithCauses((Throwable)e);
                logger.warn((Object)("Server connection failed for connection " + config.connection), (Throwable)e);
                return result;
            }
            result.sharePointSites = sites;
            result.connectionOK = true;
        }
        if (!sites.isEmpty() && config.siteId != null && !config.siteId.isBlank()) {
            List<SharePointOnlineConnection.SharePointOnlineClient.CustomList> lists;
            SharePointOnlineConnection.SharePointOnlineClient.CustomList list = null;
            try {
                lists = sharePointClient.getLists(config.siteId);
            }
            catch (Exception e) {
                result.connectionErrorMsg = "Could not retrieve available lists: " + ExceptionUtils.getMessageWithCauses((Throwable)e);
                logger.warn((Object)("Server connection failed for connection " + config.connection), (Throwable)e);
                return result;
            }
            result.sharePointLists = lists;
            if (config.sharePointList != null) {
                list = lists.stream().filter(l -> l.name.equals(config.sharePointList)).findFirst().orElse(null);
                boolean bl = result.listExists = list != null;
            }
            if (list != null) {
                result.suggestedName = ASCIITransliterator.transliterateToASCIIAlphanumAndUnderscore(list.displayName, "list");
            }
        }
        if (connectionOnly || !result.listExists) {
            return result;
        }
        result.testedConnectionOnly = false;
        logger.info((Object)"Gathering list preview");
        try {
            Pair<SchemaDetection.SchemaDetectionResult, MemTable> res = null;
            res = inferStorageTypes ? DatasetUtils.detectSchemaWithStorageTypeInference(this.authCtx, dataset, forConsistencyCheck) : DatasetUtils.simpleDetectSchema(this.authCtx, dataset, forConsistencyCheck);
            ((SchemaDetection.SchemaDetectionResult)res.first).makesSenseToInferStorageTypes = true;
            result.schemaDetection = (SchemaDetection.SchemaDetectionResult)res.first;
            SerializedMemTableSimple smt = new SerializedMemTableSimple();
            smt.fromMemTable((MemTable)res.second, 0, ((MemTable)res.second).nrows());
            result.preview = smt;
            result.collectionExists = ((MemTable)res.second).nrows() > 0;
        }
        catch (Exception e) {
            logger.warn((Object)("Error getting preview for list " + config.sharePointList), (Throwable)e);
            result.previewErrorMsg = ExceptionUtils.getMessageWithCauses((Throwable)e);
        }
        return result;
    }

    @Override
    public DatasetTestHandler.SchemaConsistencyResult testSchemaConsistency() throws Exception {
        DatasetTestHandler.SchemaConsistencyResult ret = new DatasetTestHandler.SchemaConsistencyResult();
        TestResult result = this.test(this.handler.getDataset().getProjectKey(), this.handler.getDataset(), false, true, false);
        ret.empty = !result.collectionExists;
        ret.result = result.schemaDetection;
        return ret;
    }

    @Override
    public InfoMessage.InfoMessages checkManagedDatasetNameSafety(String newDatasetName) {
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        if (StringUtils.isBlank((String)newDatasetName)) {
            ret.withFatal((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_NAME, "Dataset name is empty");
            return ret;
        }
        if (newDatasetName.contains("$")) {
            ret.withFatal((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_NAME, "Dataset name should not contain '$'");
        }
        if (newDatasetName.contains("\u0000")) {
            ret.withFatal((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_NAME, "Dataset name should not contain a null character");
        }
        if (newDatasetName.toLowerCase().startsWith("system.")) {
            ret.withWarning((InfoMessage.MessageCode)DatasetCodes.WARN_DATASET_UNSAFE_NAME, "Dataset name should not start with 'system'");
        }
        if (!startWithAlphanumOrUnderscore.matcher(newDatasetName).find()) {
            ret.withWarning((InfoMessage.MessageCode)DatasetCodes.WARN_DATASET_UNSAFE_NAME, "Dataset name should start with a letter or '_'");
        }
        return ret;
    }

    public static class TestResult {
        public boolean testedConnectionOnly;
        public String suggestedName;
        public boolean connectionOK;
        public String connectionErrorMsg;
        public List<SharePointOnlineConnection.SharePointOnlineClient.CustomSite> sharePointSites;
        public List<SharePointOnlineConnection.SharePointOnlineClient.CustomList> sharePointLists;
        public boolean collectionExists;
        public boolean listExists;
        public String sharePointSite;
        public String previewErrorMsg;
        public SchemaDetection.SchemaDetectionResult schemaDetection;
        public SerializedMemTableSimple preview;
    }
}

