/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.sql;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.connections.MetastoreDBBasedConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datalayer.memimpl.MemTableAppendingOutput;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.SchemaDetection;
import com.dataiku.dip.datasets.dynamic.VariablesExpansionLoopItemsIterable;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetTestHandler;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.input.row.RowOrientedDatasetHandler;
import com.dataiku.dip.input.row.RowsInputSplit;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.CurrentComputeResourceUsageContext;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.shaker.server.SerializedMemTableSimple;
import com.dataiku.dip.shaker.services.TypeInferrer2;
import com.dataiku.dip.sql.OracleSQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.SchemaReader;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.variables.DynamicLevelsStack;
import com.dataiku.dip.variables.VariablesUtils;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ExternalSQLDatasetTestHandler
extends AbstractSQLDatasetTestHandler {
    private TypeInferrer2 inferer = new TypeInferrer2();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.datasets.sql");

    public ExternalSQLDatasetTestHandler(AuthCtx authCtx, Dataset dataset, DatasetHandler dh) {
        super(authCtx, dataset, dh);
    }

    public List<String> listPartitions(AuthCtx liu) throws Exception {
        try (DatasetHandler dh2 = DatasetHandlerFactory.build(this.authCtx, this.dataset);){
            ArrayList<String> ret = new ArrayList<String>();
            for (Partition p : dh2.listPartitions()) {
                ret.add(p.id());
            }
            ArrayList<String> arrayList = ret;
            return arrayList;
        }
    }

    public ExternalSQLDatasetTestResult test(boolean listTables, boolean testTableOrQuery, AuthCtx liu) throws Exception {
        return this.test(listTables, testTableOrQuery, false, liu);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ExternalSQLDatasetTestResult test(boolean listTables, boolean testTableOrQuery, boolean getTableMetadata, AuthCtx liu) throws Exception {
        assert (DatasetInspector.isSQLOrHive(this.dataset));
        ExternalSQLDatasetTestResult ret = new ExternalSQLDatasetTestResult();
        ret.testedConnectionOnly = !testTableOrQuery;
        CurrentComputeResourceUsageContext.setInCurrentThreadIfNull((ComputeResourceUsageContext)ComputeResourceUsageContext.forDatasetOrConnectionTesting((AuthCtx)this.authCtx, (String)this.dataset.getProjectKey(), (String)this.dataset.getName()));
        ret.suggestedName = DatasetInspector.slufigyAndUnicize(this.dataset.getProjectKey(), this.dh.suggestName(), this.dao, this.transactionService);
        try (AbstractSQLDatasetTestHandler.ConnRet cr = this.checkConfigDriverAndConnection(ret);){
            Object schema;
            AbstractSQLDatasetHandler.AbstractSQLConfig configWithJITResolvedTableLoc;
            JsonObject jo;
            if (!cr.cd.getConnection().isFreelyUsableBy(liu)) {
                throw new SecurityException("You may not test on connection " + cr.cd.getConnection().name);
            }
            SQLUtils.SQLTable tableConf = SQLUtils.resolveAndExpandSQLCatalogAndSchema(cr.cd, this.dataset.getProjectKey(), this.config.catalog, this.config.schema);
            String resolvedCatalog = tableConf.getCatalog();
            String resolvedSchema = tableConf.getSchemaNullIfBlank();
            if (listTables) {
                try {
                    String catalog = null;
                    String schema2 = null;
                    if (cr.cd.getConnection() instanceof MetastoreDBBasedConnection) {
                        schema2 = ((MetastoreDBBasedConnection)((Object)cr.cd.getConnection())).getDatabaseName();
                        if (StringUtils.isBlank((String)schema2)) {
                            schema2 = null;
                        }
                    } else if (!this.config.variablesExpansionLoopConfig.isEnabled()) {
                        catalog = resolvedCatalog;
                        schema2 = resolvedSchema;
                    } else {
                        jo = VariablesExpansionLoopItemsIterable.firstIterationOnlyFailIfNone(this.authCtx, this.dataset.getProjectKey(), this.config.variablesExpansionLoopConfig, "Repeating dataset is empty, cannot guess schema");
                        try {
                            DynamicLevelsStack.pushLevel(jo);
                            configWithJITResolvedTableLoc = (AbstractSQLDatasetHandler.AbstractSQLConfig)VariablesUtils.expandObjectFieldsAllowUnresolved(this.dataset.getProjectKey(), this.config, new String[]{"catalog", "table", "schema"});
                            catalog = configWithJITResolvedTableLoc.catalog;
                            schema2 = configWithJITResolvedTableLoc.schema;
                        }
                        finally {
                            DynamicLevelsStack.popLevel();
                        }
                    }
                    ret.tablesList = SQLUtils.listTables(cr.cd, cr.jdbcConn, catalog, schema2, cr.cd.getDialect());
                    ret.tablesListOK = true;
                    Collections.sort(ret.tablesList, new Comparator<SQLUtils.SQLTable>(){

                        @Override
                        public int compare(SQLUtils.SQLTable a, SQLUtils.SQLTable b) {
                            String bSchema;
                            String bCatalog;
                            String aCatalog = StringUtils.defaultIfBlank((String)a.getCatalog(), (String)"");
                            int catalogCmp = aCatalog.compareToIgnoreCase(bCatalog = StringUtils.defaultIfBlank((String)b.getCatalog(), (String)""));
                            if (catalogCmp != 0) {
                                return catalogCmp;
                            }
                            String aSchema = StringUtils.defaultIfBlank((String)a.getSchemaNullIfBlank(), (String)"");
                            int schemaCmp = aSchema.compareToIgnoreCase(bSchema = StringUtils.defaultIfBlank((String)b.getSchemaNullIfBlank(), (String)""));
                            if (schemaCmp != 0) {
                                return schemaCmp;
                            }
                            String aTable = StringUtils.defaultIfBlank((String)a.getTable(), (String)"");
                            String bTable = StringUtils.defaultIfBlank((String)b.getTable(), (String)"");
                            return aTable.compareToIgnoreCase(bTable);
                        }
                    });
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to list tables", (Throwable)e);
                    ret.tablesListOK = false;
                    ret.tablesListError = new SerializedError((Throwable)e, false);
                }
            } else {
                ret.tablesListOK = true;
            }
            if (getTableMetadata || testTableOrQuery && this.config.mode.equals("table")) {
                schema = resolvedSchema;
                if (cr.cd.getConnection() instanceof MetastoreDBBasedConnection && StringUtils.isBlank((String)(schema = ((MetastoreDBBasedConnection)((Object)cr.cd.getConnection())).getDatabaseName()))) {
                    schema = null;
                }
                if (!StringUtils.isBlank((String)this.config.table)) {
                    try {
                        ret.table = SQLUtils.getTableMetadata(cr.cd, cr.jdbcConn, resolvedCatalog, (String)schema, this.config.table);
                    }
                    catch (Exception e) {
                        logger.error((Object)"Could not retrieve table", (Throwable)e);
                    }
                }
            }
            if (!testTableOrQuery) {
                schema = ret;
                return schema;
            }
            try {
                AbstractSQLDatasetHandler.ReadTemporalMode effectiveDateonlyReadMode = OracleSQLDialect.adjustDateonlyReadMode(this.config.dateonlyReadMode, this.config.datetimenotzReadMode, cr.cd.getDialect(), this.dataset);
                if (this.config.mode.equals("query")) {
                    if (StringUtils.isBlank((String)this.config.query)) {
                        throw new IllegalArgumentException("query is empty");
                    }
                    String query = this.config.query;
                    if (this.dataset.getPartitioningSchema() != null && this.dataset.getPartitioningSchema().isPartitioned()) {
                        String previewPartition = this.config.previewPartition;
                        if (previewPartition == null) {
                            throw ErrorContext.iae((String)"In 'query' mode, the 'Preview Partition' parameter is mandatory for partitioned SQL datasets");
                        }
                        Partition p = PartitionFactory.fromIdentifier(this.dataset.getPartitioningSchema(), previewPartition);
                        query = SQLUtils.getQueryForPartition(query, p);
                    }
                    SchemaReader.SchemaWithInfo querySchema = SchemaReader.getQuerySchemaWithInfo(this.authCtx, cr.cd, cr.jdbcConn, query, this.config.datetimenotzReadMode, effectiveDateonlyReadMode, this.dataset.getSchema());
                    ret.querySchema = new Schema(querySchema.schema);
                } else if (this.config.mode.equals("table")) {
                    SchemaReader.SchemaWithInfo tableSchema;
                    if (!this.config.variablesExpansionLoopConfig.isEnabled()) {
                        tableSchema = SchemaReader.tryGetTableSchemaWithInfoAndComments(this.authCtx, cr.cd, cr.jdbcConn, resolvedCatalog, resolvedSchema, this.config.table, this.config.datetimenotzReadMode, effectiveDateonlyReadMode, this.dataset.getSchema(), ret.table);
                    } else {
                        jo = VariablesExpansionLoopItemsIterable.firstIterationOnlyFailIfNone(this.authCtx, this.dataset.getProjectKey(), this.config.variablesExpansionLoopConfig, "Repeating dataset is empty, cannot guess schema");
                        try {
                            DynamicLevelsStack.pushLevel(jo);
                            configWithJITResolvedTableLoc = (AbstractSQLDatasetHandler.AbstractSQLConfig)VariablesUtils.expandObjectFieldsAllowUnresolved(this.dataset.getProjectKey(), this.config, new String[]{"catalog", "table", "schema"});
                            tableSchema = SchemaReader.tryGetTableSchemaWithInfoAndComments(this.authCtx, cr.cd, cr.jdbcConn, configWithJITResolvedTableLoc.catalog, configWithJITResolvedTableLoc.schema, configWithJITResolvedTableLoc.table, this.config.datetimenotzReadMode, effectiveDateonlyReadMode, this.dataset.getSchema(), ret.table);
                        }
                        finally {
                            DynamicLevelsStack.popLevel();
                        }
                    }
                    ret.querySchema = new Schema(tableSchema.schema);
                    ret.tablePartitionInfo = tableSchema.tablePartitionInfo;
                }
                ret.queryOK = true;
            }
            catch (Exception e) {
                logger.error((Object)"Query failed", (Throwable)e);
                ret.queryOK = false;
                ret.queryError = new SerializedError((Throwable)e, true);
                ExternalSQLDatasetTestResult externalSQLDatasetTestResult = ret;
                if (cr == null) return externalSQLDatasetTestResult;
                cr.close();
                return externalSQLDatasetTestResult;
            }
        }
        catch (Exception e) {
            ret.connectionOK = false;
            ret.connectionError = new SerializedError((Throwable)e, false);
            return ret;
        }
        ret.schemaDetection = SchemaDetection.handleDetectionResult(SchemaDetection.SchemaHandlingType.FIXED_TYPE_AND_SCHEMA, this.dataset.getSchema(), this.dataset.getSchema().userModified ? SchemaDetection.Mode.DETECTION_PREFER_USER_AND_WARN : SchemaDetection.Mode.DETECTION_PREFER_DATA, ret.querySchema, false);
        if (ret.schemaDetection.warningLevel == null && this.config.mode.equals("table")) {
            SchemaDetection.updateDetectionResultWithCommentCheck(ret.schemaDetection, this.dataset.getSchema(), ret.schemaDetection.detectedSchema);
        }
        logger.info((Object)"Gathering SQL table preview");
        this.dataset.setSchema(null);
        try {
            RowsInputSplit split = ((RowOrientedDatasetHandler)this.dh).getSampleSplit();
            MemTable mt = new MemTable();
            split.push((ProcessorOutput)new MemTableAppendingOutput(mt), mt, mt, new ExtractionLimit(100L), null, null);
            this.inferer.processFullAuto(null, mt);
            SerializedMemTableSimple smt = new SerializedMemTableSimple();
            smt.fromMemTable(mt, 0, mt.nrows());
            ret.preview = smt;
            return ret;
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get preview", (Throwable)e);
            ret.queryOK = false;
            ret.queryError = new SerializedError((Throwable)e, true);
            ret.previewErrorMsg = ExceptionUtils.getMessageWithCauses((Throwable)e);
        }
        return ret;
    }

    @Override
    public DatasetTestHandler.SchemaConsistencyResult testSchemaConsistency() throws Exception {
        DatasetTestHandler.SchemaConsistencyResult ret = new DatasetTestHandler.SchemaConsistencyResult();
        ExternalSQLDatasetTestResult result = this.test(false, true, null);
        ret.empty = !result.queryOK;
        ret.result = result.schemaDetection;
        return ret;
    }

    @Override
    public InfoMessage.InfoMessages checkManagedDatasetNameSafety(String newDatasetName) {
        return new InfoMessage.InfoMessages();
    }

    public static class ExternalSQLDatasetTestResult
    extends AbstractSQLDatasetTestHandler.SQLDatasetTestResult {
        public String suggestedName;
        public boolean tablesListOK;
        public List<SQLUtils.SQLTable> tablesList;
        public SerializedError tablesListError;
        public SQLUtils.SQLTable table;
        public boolean queryOK;
        public Schema querySchema;
        public SchemaReader.TablePartitionInfo tablePartitionInfo;
        public SerializedError queryError;
    }
}

