/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.sql;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.datasets.sql.PartitionedSQLQueryDatasetHandler;
import com.dataiku.dip.datasets.sql.PartitionedSQLTableDatasetHandler;
import com.dataiku.dip.datasets.sql.UnpartitionedSQLQueryDatasetHandler;
import com.dataiku.dip.datasets.sql.UnpartitionedSQLTableDatasetHandler;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.recipes.ManagedDatasetsCreationService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class GenericSQLDatasetMeta
extends DatasetHandler.NonFSMeta<AbstractSQLDatasetHandler, AbstractSQLDatasetHandler.AbstractSQLConfig> {
    static Logger logger = Logger.getLogger((String)"dku.datasetsmeta.sql");

    @Override
    public Class<? extends DatasetHandler.DatasetParams> paramsClass() {
        return AbstractSQLDatasetHandler.AbstractSQLConfig.class;
    }

    @Override
    public DatasetHandler build(AuthCtx authCtx, Dataset dataset) {
        boolean partitioned;
        AbstractSQLDatasetHandler.AbstractSQLConfig config = (AbstractSQLDatasetHandler.AbstractSQLConfig)dataset.getParams();
        String mode = config.mode == null ? "table" : config.mode;
        boolean bl = partitioned = dataset.getPartitioningSchema() != null && dataset.getPartitioningSchema().isPartitioned();
        if (mode.equals("query") && !partitioned) {
            return new UnpartitionedSQLQueryDatasetHandler(authCtx, dataset, this);
        }
        if (mode.equals("query") && partitioned) {
            return new PartitionedSQLQueryDatasetHandler(authCtx, dataset, this);
        }
        if (mode.equals("table") && !partitioned) {
            return new UnpartitionedSQLTableDatasetHandler(authCtx, dataset, this);
        }
        if (mode.equals("table") && partitioned) {
            return new PartitionedSQLTableDatasetHandler(authCtx, dataset, this);
        }
        throw ErrorContext.iaef((String)"Invalid SQL dataset mode : '%s' expected 'query' or 'table'", (Object)mode, (Object[])new Object[0]);
    }

    @Override
    public boolean isFSLike() {
        return false;
    }

    @Override
    public boolean isFS() {
        return false;
    }

    @Override
    public boolean isReadable() {
        return true;
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public boolean isParallelWritable() {
        return false;
    }

    @Override
    public boolean supportsReadOrdering() {
        return true;
    }

    @Override
    public void fillManagedDatasetParams(Dataset dataset, DSSConnection targetConnection, ManagedDatasetsCreationService.ManagedDatasetCreationSpecificSettings specificSettings, boolean useExistingParams) {
        AbstractSQLDatasetHandler.AbstractSQLConfig config;
        if (!(targetConnection instanceof AbstractSQLConnection)) {
            throw ErrorContext.iae((String)("Unexpected connection type for SQL: " + targetConnection.getType()));
        }
        AbstractSQLConnection connection = (AbstractSQLConnection)targetConnection;
        dataset.setManaged(true);
        dataset.setType(connection.getType());
        DatasetHandler.DatasetMeta<?, ?> realMeta = DatasetHandlerFactory.getMeta(dataset);
        try {
            logger.info((Object)("Create parameters with class: " + realMeta.paramsClass().getName()));
            config = (AbstractSQLDatasetHandler.AbstractSQLConfig)realMeta.paramsClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e1) {
            throw new Error("Failed to instantiate config", e1);
        }
        if (useExistingParams && dataset.getParams() instanceof AbstractSQLDatasetHandler.AbstractSQLConfig) {
            AbstractSQLDatasetHandler.AbstractSQLConfig currentParams = (AbstractSQLDatasetHandler.AbstractSQLConfig)dataset.getParams();
            if (currentParams.getClass().equals(realMeta.paramsClass())) {
                config = (AbstractSQLDatasetHandler.AbstractSQLConfig)JSON.deepCopy((Object)currentParams);
            } else {
                config.mode = currentParams.mode;
                config.partitioningType = currentParams.partitioningType;
                config.explicitPartitionsList = currentParams.explicitPartitionsList;
                config.normalizeDoubles = currentParams.normalizeDoubles;
                config.query = currentParams.query;
                config.partitionsQuery = currentParams.partitionsQuery;
                config.previewPartition = currentParams.previewPartition;
                config.tableCreationMode = currentParams.tableCreationMode;
                config.customCreateStatement = currentParams.customCreateStatement;
                config.customPreWriteStatements = currentParams.customPreWriteStatements;
                config.customPostWriteStatements = currentParams.customPostWriteStatements;
                config.writeInsertBatchSize = currentParams.writeInsertBatchSize;
                config.writeDescriptionsAsSQLComment = currentParams.writeDescriptionsAsSQLComment;
            }
        }
        this.fillDefaultDatasetParams(dataset, connection, config, specificSettings);
        dataset.setParams(config);
    }

    private void fillDefaultDatasetParams(Dataset dataset, AbstractSQLConnection connection, AbstractSQLDatasetHandler.AbstractSQLConfig config, ManagedDatasetsCreationService.ManagedDatasetCreationSpecificSettings specificSettings) {
        AbstractSQLConnection.AbstractSQLParams connParams = connection.getParams();
        config.connection = connection.name;
        config.mode = "table";
        config.writeDescriptionsAsSQLComment = connParams.namingRule.writeDescriptionsAsSQLComment;
        if (specificSettings != null && StringUtils.isNotBlank((String)specificSettings.overrideSQLCatalog)) {
            config.catalog = specificSettings.overrideSQLCatalog;
        } else if (!StringUtils.isBlank((String)connParams.namingRule.catalog)) {
            config.catalog = connParams.namingRule.catalog;
        }
        if (specificSettings != null && StringUtils.isNotBlank((String)specificSettings.overrideSQLSchema)) {
            config.schema = specificSettings.overrideSQLSchema;
        } else if (!StringUtils.isBlank((String)connParams.namingRule.schemaName)) {
            config.schema = connParams.namingRule.schemaName;
        }
        switch (connection.getDialect().getDefaultUnquotedCaseForTables()) {
            case LOWER: {
                config.table = dataset.getName().toLowerCase();
                break;
            }
            case UPPER: {
                config.table = dataset.getName().toUpperCase();
            }
        }
        if (!StringUtils.isBlank((String)connParams.namingRule.tableNameDatasetNamePrefix)) {
            config.table = connParams.namingRule.tableNameDatasetNamePrefix + config.table;
        }
        if (!StringUtils.isBlank((String)connParams.namingRule.tableNameDatasetNameSuffix)) {
            config.table = config.table + connParams.namingRule.tableNameDatasetNameSuffix;
        }
    }

    @Override
    public void selfReport(AbstractSQLDatasetHandler.AbstractSQLConfig params, JsonObject ret) {
        ret.addProperty("sqlMode", params.mode);
        if (!StringUtils.isBlank((String)params.customCreateStatement)) {
            ret.addProperty("customCreateStmt", params.customCreateStatement);
        }
    }

    public boolean hasCaseInsensitiveColumns() {
        return false;
    }
}

