/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docgen.flow.placeholders.recipe;

import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.exec.dataquality.ExtractFailedRowsRecipeMeta;
import com.dataiku.dip.dataflow.exec.dataquality.ExtractFailedRowsRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.dataquality.ExtractFailedRowsRecipeStatusComputer;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataquality.DataQualityRule;
import com.dataiku.dip.docgen.flow.FlowDocumentContext;
import com.dataiku.dip.docgen.flow.FlowPlaceholder;
import com.dataiku.dip.docgen.helpers.PlaceholderOutputFactory;
import com.dataiku.dip.docgen.resolver.BadTemplatePlaceholderException;
import com.dataiku.dip.docgen.resolver.IterableDescription;
import com.dataiku.dip.docgen.resolver.PlaceholderExpectedException;
import com.dataiku.dip.docgen.resolver.PlaceholderOutput;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.StringUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ExtractFailedRowsRecipePlaceholders {
    private ExtractFailedRowsRecipePlaceholders() {
    }

    public static class RuleIsSelected
    implements FlowPlaceholder.TextPlaceholder<ExtractFailedRowsRecipePayloadParams.ColumnRuleDescWithDisplayName> {
        @Override
        public Class<ExtractFailedRowsRecipePayloadParams.ColumnRuleDescWithDisplayName> getInputType() {
            return ExtractFailedRowsRecipePayloadParams.ColumnRuleDescWithDisplayName.class;
        }

        @Override
        public PlaceholderOutput.Text resolve(FlowDocumentContext flowDocumentContext, ExtractFailedRowsRecipePayloadParams.ColumnRuleDescWithDisplayName desc) throws PlaceholderExpectedException {
            return PlaceholderOutputFactory.makeBoolean(desc.isSelected);
        }
    }

    public static class RuleColumn
    implements FlowPlaceholder.TextPlaceholder<ExtractFailedRowsRecipePayloadParams.ColumnRuleDescWithDisplayName> {
        @Override
        public Class<ExtractFailedRowsRecipePayloadParams.ColumnRuleDescWithDisplayName> getInputType() {
            return ExtractFailedRowsRecipePayloadParams.ColumnRuleDescWithDisplayName.class;
        }

        @Override
        public PlaceholderOutput.Text resolve(FlowDocumentContext flowDocumentContext, ExtractFailedRowsRecipePayloadParams.ColumnRuleDescWithDisplayName desc) throws PlaceholderExpectedException {
            return new PlaceholderOutput.Text((String)StringUtils.defaultIfBlank((CharSequence)desc.ruleColumn, (CharSequence)""));
        }
    }

    public static class RuleName
    implements FlowPlaceholder.TextPlaceholder<ExtractFailedRowsRecipePayloadParams.ColumnRuleDescWithDisplayName> {
        @Override
        public Class<ExtractFailedRowsRecipePayloadParams.ColumnRuleDescWithDisplayName> getInputType() {
            return ExtractFailedRowsRecipePayloadParams.ColumnRuleDescWithDisplayName.class;
        }

        @Override
        public PlaceholderOutput.Text resolve(FlowDocumentContext flowDocumentContext, ExtractFailedRowsRecipePayloadParams.ColumnRuleDescWithDisplayName desc) throws PlaceholderExpectedException {
            return new PlaceholderOutput.Text(desc.ruleDisplayedName);
        }
    }

    public static class RuleId
    implements FlowPlaceholder.TextPlaceholder<ExtractFailedRowsRecipePayloadParams.ColumnRuleDescWithDisplayName> {
        @Override
        public Class<ExtractFailedRowsRecipePayloadParams.ColumnRuleDescWithDisplayName> getInputType() {
            return ExtractFailedRowsRecipePayloadParams.ColumnRuleDescWithDisplayName.class;
        }

        @Override
        public PlaceholderOutput.Text resolve(FlowDocumentContext flowDocumentContext, ExtractFailedRowsRecipePayloadParams.ColumnRuleDescWithDisplayName desc) throws PlaceholderExpectedException {
            return new PlaceholderOutput.Text(desc.ruleId);
        }
    }

    public static class RulesIterable
    implements FlowPlaceholder.IterablePlaceholder<SerializedRecipe, ExtractFailedRowsRecipePayloadParams.ColumnRuleDescWithDisplayName> {
        @Override
        public IterableDescription<SerializedRecipe, ExtractFailedRowsRecipePayloadParams.ColumnRuleDescWithDisplayName> getDescription() {
            return IterableDescription.iterablePlaceholder(SerializedRecipe.class, ExtractFailedRowsRecipePayloadParams.ColumnRuleDescWithDisplayName.class, "$rule");
        }

        @Override
        public Collection<ExtractFailedRowsRecipePayloadParams.ColumnRuleDescWithDisplayName> resolve(FlowDocumentContext context, SerializedRecipe recipe) throws PlaceholderExpectedException {
            FlowRecipe flowRecipe = context.getProjectFlowGraph().getRecipe(recipe.getProjectKey(), recipe.getDisplayName());
            List<FlowDataset> flowDatasets = flowRecipe.getPredecessors().stream().filter(FlowDataset.class::isInstance).map(FlowDataset.class::cast).toList();
            if (!flowDatasets.isEmpty()) {
                ExtractFailedRowsRecipeStatusComputer.ExtractFailedRowsRecipeStatus status;
                SerializedDataset dataset = context.getSerializedDatasets(flowDatasets).get(0);
                Map<String, String> ruleDisplayNamesById = dataset.getDataQualityRuleSet().getRules().stream().collect(Collectors.toMap(DataQualityRule::getId, DataQualityRule::getDisplayName));
                ExtractFailedRowsRecipeStatusComputer statusComputer = ExtractFailedRowsRecipeMeta.META.buildStatusComputer(recipe, context.getCachedPayload(recipe));
                try {
                    status = statusComputer.getFullStatus_NT(context.user, "");
                }
                catch (DKUSecurityException | IOException e) {
                    throw new PlaceholderExpectedException("Failed to resolve placeholder for recipe " + recipe.name + ".");
                }
                return status.consolidatedColumnRules.stream().map(desc -> {
                    ExtractFailedRowsRecipePayloadParams.ColumnRuleDescWithDisplayName descWithDisplayName = new ExtractFailedRowsRecipePayloadParams.ColumnRuleDescWithDisplayName();
                    descWithDisplayName.ruleId = desc.ruleId;
                    descWithDisplayName.ruleColumn = desc.ruleColumn;
                    descWithDisplayName.isSelected = desc.isSelected;
                    descWithDisplayName.ruleDisplayedName = (String)ruleDisplayNamesById.get(desc.ruleId);
                    return descWithDisplayName;
                }).toList();
            }
            return List.of();
        }
    }

    public static class AutoSelectAllCompatibleRules
    implements FlowPlaceholder.TextPlaceholder<SerializedRecipe> {
        @Override
        public Class<SerializedRecipe> getInputType() {
            return SerializedRecipe.class;
        }

        @Override
        public PlaceholderOutput.Text resolve(FlowDocumentContext context, SerializedRecipe recipe) throws PlaceholderExpectedException {
            if (!ExtractFailedRowsRecipeMeta.META.getType().equals(recipe.type)) {
                throw new BadTemplatePlaceholderException("Placeholder not available for recipe " + recipe.name + ". It is not an extract failed rows recipe.");
            }
            ExtractFailedRowsRecipePayloadParams payload = (ExtractFailedRowsRecipePayloadParams)JSON.parse((String)context.getCachedPayload(recipe), ExtractFailedRowsRecipePayloadParams.class);
            return PlaceholderOutputFactory.makeBoolean(!payload.explicitColumnSelection);
        }
    }
}

