/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.cards.bivariate_header;

import com.dataiku.dip.eda.compute.computations.common.Count;
import com.dataiku.dip.eda.compute.computations.common.GroupedComputation;
import com.dataiku.dip.eda.compute.computations.common.MultiComputation;
import com.dataiku.dip.eda.compute.filtering.Filter;
import com.dataiku.dip.eda.compute.grouping.CrossGrouping;
import com.dataiku.dip.eda.compute.grouping.Grouping;
import com.dataiku.dip.eda.compute.grouping.SubsetGrouping;
import com.dataiku.dip.eda.compute.grouping.UnionGrouping;
import com.dataiku.dip.eda.worksheets.cards.CardResult;
import com.dataiku.dip.eda.worksheets.cards.bivariate_header.Abstract2DPivotCard;
import com.dataiku.dip.eda.worksheets.cards.common.AbstractCompiledCard;
import com.dataiku.dip.eda.worksheets.cards.common.CardWithHighlight;
import com.dataiku.dip.eda.worksheets.cards.common.CompiledCard;
import com.dataiku.dip.eda.worksheets.cards.common.GroupingHelpers;
import com.dataiku.dip.utils.ImmutableValueObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class MosaicPlotCard
extends Abstract2DPivotCard
implements CardWithHighlight {
    public static final String TYPE = "mosaic_plot";
    @Nullable
    Filter highlightFilter;

    @Override
    protected CompiledCard compileNoSplitNoFilter() {
        return new AbstractCompiledCard<MultiComputation, MultiComputation.MultiComputationResult>(){

            @Override
            public MultiComputation getComputationPlan() {
                Grouping xAxis = GroupingHelpers.handleCustomizableVariableGrouping(MosaicPlotCard.this.xColumn, MosaicPlotCard.this.xBinningMode, MosaicPlotCard.this.maxValuesX, MosaicPlotCard.this.groupWithOthersX, MosaicPlotCard.this.xCustomBinningBoundaries, true);
                Grouping yAxis = GroupingHelpers.handleCustomizableVariableGrouping(MosaicPlotCard.this.yColumn, MosaicPlotCard.this.yBinningMode, MosaicPlotCard.this.maxValuesY, MosaicPlotCard.this.groupWithOthersY, MosaicPlotCard.this.yCustomBinningBoundaries, true);
                ArrayList<Grouping> subsets = new ArrayList<Grouping>();
                subsets.add(SubsetGrouping.all());
                if (MosaicPlotCard.this.highlightFilter != null) {
                    subsets.add(new SubsetGrouping(MosaicPlotCard.this.highlightFilter));
                }
                return new MultiComputation(new GroupedComputation(new Count(), new CrossGrouping(new UnionGrouping(subsets), xAxis, yAxis)), new Count());
            }

            @Override
            protected CardResult buildFromFullyAvailableResult(MultiComputation.MultiComputationResult result) {
                GroupedComputation.GroupedComputationResult groupedResults = result.get(0).asGrouped();
                List<Filter> xVals = groupedResults.groups.asCross().groups.get(1).listFilters();
                List<Filter> yVals = groupedResults.groups.asCross().groups.get(2).listFilters();
                long totalCount = result.get((int)1).as(Count.CountResult.class).count;
                long[] counts = new long[xVals.size() * yVals.size()];
                for (int i = 0; i < counts.length; ++i) {
                    counts[i] = groupedResults.results.get((int)i).as(Count.CountResult.class).count;
                }
                long[] highlightedCounts = null;
                if (MosaicPlotCard.this.highlightFilter != null) {
                    highlightedCounts = new long[xVals.size() * yVals.size()];
                    for (int i = 0; i < highlightedCounts.length; ++i) {
                        highlightedCounts[i] = groupedResults.results.get((int)(counts.length + i)).as(Count.CountResult.class).count;
                    }
                }
                MosaicPlotData mosaicPlot = new MosaicPlotData(xVals, yVals, counts, totalCount, highlightedCounts);
                return new MosaicPlotCardResult(mosaicPlot);
            }
        };
    }

    @Override
    public void setHighlightFilter(Filter filter) {
        this.highlightFilter = filter;
    }

    public static class MosaicPlotData
    extends ImmutableValueObject {
        List<Filter> xVals;
        List<Filter> yVals;
        double[] xPercentages;
        double[] yPercentages;
        @Nullable
        double[] highlightedYPercentages;
        long[] counts;
        long totalCount;

        public MosaicPlotData(List<Filter> xVals, List<Filter> yVals, long[] counts, long totalCount, @Nullable long[] highlightedCounts) {
            int index;
            int i;
            this.xVals = xVals;
            this.yVals = yVals;
            this.counts = counts;
            this.totalCount = totalCount;
            long[] xCounts = new long[xVals.size()];
            long total = 0L;
            for (i = 0; i < xVals.size(); ++i) {
                long xCount = 0L;
                for (int j = 0; j < yVals.size(); ++j) {
                    int index2 = i * yVals.size() + j;
                    total += counts[index2];
                    xCount += counts[index2];
                }
                xCounts[i] = xCount;
            }
            this.xPercentages = new double[xCounts.length];
            for (i = 0; i < xCounts.length; ++i) {
                this.xPercentages[i] = xCounts[i] == 0L || total == 0L ? 0.0 : (double)xCounts[i] / (double)total;
            }
            this.yPercentages = new double[xVals.size() * yVals.size()];
            for (i = 0; i < xVals.size(); ++i) {
                for (int j = 0; j < yVals.size(); ++j) {
                    index = i * yVals.size() + j;
                    this.yPercentages[index] = counts[index] == 0L || xCounts[i] == 0L ? 0.0 : (double)counts[index] / (double)xCounts[i];
                }
            }
            if (highlightedCounts != null) {
                this.highlightedYPercentages = new double[xVals.size() * yVals.size()];
                for (i = 0; i < xVals.size(); ++i) {
                    for (int j = 0; j < yVals.size(); ++j) {
                        index = i * yVals.size() + j;
                        this.highlightedYPercentages[index] = highlightedCounts[index] == 0L || xCounts[i] == 0L ? 0.0 : (double)highlightedCounts[index] / (double)xCounts[i];
                    }
                }
            }
        }

        private MosaicPlotData() {
        }
    }

    public static class MosaicPlotCardResult
    extends CardResult {
        public MosaicPlotData mosaic;

        public MosaicPlotCardResult(MosaicPlotData mosaic) {
            this.mosaic = mosaic;
        }

        private MosaicPlotCardResult() {
        }
    }
}

