/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.models;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.utils.ImmutableValueObject;
import com.dataiku.j2ts.annotations.UIModel;

@UIModel
public class Variable
extends ImmutableValueObject {
    public String name;
    public Type type;

    public Variable(String name, Type type) {
        this.name = name;
        this.type = type;
    }

    public Variable(SchemaColumn column) {
        this.name = column.getName();
        this.type = column.getType().isNumeric() ? Type.CONTINUOUS : Type.CATEGORICAL;
    }

    private Variable() {
    }

    public boolean isContinuous() {
        return Type.CONTINUOUS.equals((Object)this.type);
    }

    public boolean isCategorical() {
        return Type.CATEGORICAL.equals((Object)this.type);
    }

    public Variable asCategorical() {
        return new Variable(this.name, Type.CATEGORICAL);
    }

    public static enum Type {
        CATEGORICAL,
        CONTINUOUS;

    }
}

