/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.exposition;

import com.dataiku.dip.exposition.ExposedEndpointConsumer;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractExposedEndpointCollector
implements ExposedEndpointConsumer {
    private Map<String, ExposedEndpointConsumer.ExposedEndpoint> endpoints = Maps.newHashMap();
    private static Logger logger = Logger.getLogger((String)"dip.expose.endpoint.collector");

    private synchronized List<ExposedEndpointConsumer.ExposedEndpoint> addEndpoint(ExposedEndpointConsumer.ExposedEndpoint endpoint) {
        this.endpoints.put(endpoint.id, endpoint);
        return Lists.newArrayList(this.endpoints.values());
    }

    private synchronized List<ExposedEndpointConsumer.ExposedEndpoint> removeEndpoint(ExposedEndpointConsumer.ExposedEndpoint endpoint) {
        this.endpoints.remove(endpoint.id);
        return Lists.newArrayList(this.endpoints.values());
    }

    @Override
    public void registerPort(ExposedEndpointConsumer.ExposedEndpoint endpoint) throws Exception {
        logger.info((Object)("Register a backend " + JSON.json((Object)endpoint)));
        List<ExposedEndpointConsumer.ExposedEndpoint> list = this.addEndpoint(endpoint);
        this.endpointsChanged(list);
    }

    @Override
    public void deregisterPort(ExposedEndpointConsumer.ExposedEndpoint endpoint) throws Exception {
        logger.info((Object)("Deregister a backend " + JSON.json((Object)endpoint)));
        List<ExposedEndpointConsumer.ExposedEndpoint> list = this.removeEndpoint(endpoint);
        this.endpointsChanged(list);
    }

    protected synchronized void clear() throws Exception {
        this.endpoints.clear();
        this.endpointsChanged(new ArrayList<ExposedEndpointConsumer.ExposedEndpoint>());
    }

    protected abstract void endpointsChanged(List<ExposedEndpointConsumer.ExposedEndpoint> var1) throws Exception;
}

