/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.formats.yxdb;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.fs.FSDatasetUtils;
import com.dataiku.dip.formats.yxdb.AlteryxDBFormatConfig;
import com.dataiku.dip.formats.yxdb.AlteryxDBFormatExtractor;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.input.formats.FileBasedFormatDetector;
import com.dataiku.dip.input.formats.InputFormatsDetector;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import com.tlarsendataguy.yxdb.YxdbReader;
import java.io.BufferedInputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AlteryxDBFormatDetector
implements FileBasedFormatDetector {
    private static final Logger logger = Logger.getLogger((String)"dku.formats.yxdb");

    @Override
    public List<InputFormatsDetector.FormatWithMetadata> detect(Dataset dataset, FSDatasetUtils.PathsBasedSplit split, FSPath path, String filename) throws Exception {
        InputFormatsDetector.FormatWithMetadata fwm = AlteryxDBFormatDetector.detect(split.getStreamForPath(path), filename);
        return fwm != null ? Collections.singletonList(fwm) : Collections.emptyList();
    }

    @Override
    public Map<String, String> recomputeMetadata(String autoDetectedFormatId, Dataset dataset, FSDatasetUtils.PathsBasedSplit split, FSPath path, String filename) throws Exception {
        if (AlteryxDBFormatExtractor.META.getType().equals(autoDetectedFormatId)) {
            return new HashMap<String, String>();
        }
        return null;
    }

    private static InputFormatsDetector.FormatWithMetadata detect(EnrichedInputStream eis, String filename) {
        InputFormatsDetector.FormatWithMetadata formatWithMetadata;
        BufferedInputStream inputStream = new BufferedInputStream(eis.decompressedStream());
        try {
            YxdbReader yxdbReader = new YxdbReader(inputStream);
            logger.info((Object)("Successfully read " + filename + " header. File contains " + yxdbReader.numRecords + " records"));
            InputFormatsDetector.FormatWithMetadata fwm = new InputFormatsDetector.FormatWithMetadata();
            fwm.type = AlteryxDBFormatExtractor.META.getType();
            fwm.params = new AlteryxDBFormatConfig();
            fwm.metadata = new HashMap<String, String>();
            formatWithMetadata = fwm;
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                logger.error((Object)("Extension is yxdb but could not open as an YXDB file: " + filename), (Throwable)e);
                return null;
            }
        }
        inputStream.close();
        return formatWithMetadata;
    }
}

