/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.graphicsexport.execution;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.analysis.docgen.helpers.UrlUtil;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dashboards.DashboardCodes;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.graphicsexport.model.EnrichedExport;
import com.dataiku.dip.server.services.InternalAPIKeysService;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

public abstract class ExportScriptRunner {
    private static final String SCRIPT_DIRECTORY = "graphics-export";
    private static final int ERR_CREATE_BROWSER = 2;
    private static final int ERR_CREATE_BROWSER_SANDBOX = 3;
    private static final int ERR_INVALID_TILE_SCALE_VALUE = 5;
    protected final EnrichedExport export;
    protected final File exportDirectory;
    protected final InternalAPIKeysService.APIKey apiKey;
    protected List<DKUtils.ExecSubscription> outputSubscriptions;
    public LoggingAndErrorSubscription errorSubscription;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.graphics.export.script");

    public ExportScriptRunner(EnrichedExport export, File exportDirectory, InternalAPIKeysService.APIKey apiKey) {
        this.export = export;
        this.exportDirectory = exportDirectory;
        this.apiKey = apiKey;
        this.outputSubscriptions = new ArrayList<DKUtils.ExecSubscription>();
        this.outputSubscriptions.add((DKUtils.ExecSubscription)new LoggingSubscription());
        this.errorSubscription = new LoggingAndErrorSubscription();
    }

    protected List<String> getUrlsRequiringAuthentication() {
        List<String> authenticatedUrlsOverride = ExportScriptRunner.getCommaSeparatedUrlsProperty("dku.graphics.export.authenticatedUrlsOverride");
        if (!authenticatedUrlsOverride.isEmpty()) {
            return authenticatedUrlsOverride;
        }
        List<String> authenticatedUrls = ExportScriptRunner.getCommaSeparatedUrlsProperty("dku.graphics.export.authenticatedUrls");
        ArrayList<String> result = new ArrayList<String>(authenticatedUrls);
        String dssInternalRootUrl = ExportScriptRunner.getDSSInternalRootUrl();
        result.add(dssInternalRootUrl + "dip/api");
        result.add(dssInternalRootUrl + "local/projects/");
        result.add(dssInternalRootUrl + "web-apps-backends");
        result.add(dssInternalRootUrl + "html-apps-backends");
        return result;
    }

    protected abstract ScriptConfig getScriptConfig();

    protected abstract String getScriptFileName();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws IOException, InterruptedException {
        ScriptConfig scriptConfig = this.getScriptConfig();
        try (AutoDelete parametersFile = DSSTempUtils.getTempFile((String)SCRIPT_DIRECTORY, (String)"script-config", (String)"json");){
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Executing node script: " + Joiner.on((String)" ").join(this.getCommandLine("<API KEY>", parametersFile.getAbsolutePath())) + "\n" + JSON.pretty((Object)scriptConfig)));
            }
            JSON.prettyToFile((Object)scriptConfig, (File)parametersFile);
            ProcessBuilder pb = new ProcessBuilder(this.getCommandLine(this.apiKey.key, parametersFile.getAbsolutePath()));
            File scriptDirectory = new File(new File(System.getenv("DKUINSTALLDIR"), "resources"), SCRIPT_DIRECTORY);
            pb.directory(scriptDirectory);
            int returnCode = new DKUtils.ExecBuilder().withProcessBuilder(pb).withOutputConsumers(this.outputSubscriptions).withErrorConsumer((DKUtils.ExecSubscription)this.errorSubscription).exec();
            switch (returnCode) {
                case 0: {
                    return;
                }
                case 3: {
                    throw new CodedIOException((InfoMessage.MessageCode)DashboardCodes.ERR_DASHBOARD_EXPORT_SAND_BOXING_ERROR, "Either authorize internal Web browser to start in a non-sandboxed mode by changing dip.properties or update your server installation to enable sandboxing.");
                }
                case 2: {
                    throw new CodedIOException((InfoMessage.MessageCode)DashboardCodes.ERR_DASHBOARD_EXPORT_BROWSER_CREATION_ERROR, this.errorSubscription.getErrorMessage());
                }
                case 5: {
                    throw new IllegalArgumentException(this.errorSubscription.getErrorMessage());
                }
                default: {
                    throw new IOException(this.errorSubscription.getErrorMessage());
                }
            }
        }
    }

    protected List<String> getCommandLine(String apiKey, String scriptConfigFilePath) {
        return Lists.newArrayList((Object[])new String[]{"node", this.getScriptFileName(), apiKey, scriptConfigFilePath});
    }

    protected String getLogProgressMarker() {
        return null;
    }

    protected String getLogWarningMarker() {
        return "Warning:";
    }

    private static String getDSSInternalRootUrl() {
        String rootUrl;
        GeneralSettingsDAO.GeneralSettings generalSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        return rootUrl + ((rootUrl = UrlUtil.getDSSInternalRootUrl(generalSettings)).endsWith("/") ? "" : "/");
    }

    private static List<String> getCommaSeparatedUrlsProperty(String propertyName) {
        String propertyValue = DKUApp.getProperty((String)propertyName, (String)"");
        return Arrays.stream(propertyValue.split(",")).filter(StringUtils::isNotBlank).map(String::trim).toList();
    }

    protected static class LoggingSubscription
    implements DKUtils.LineSubscription {
        protected LoggingSubscription() {
        }

        public void handle(String line, boolean replace) {
            logger.log((Priority)Level.INFO, (Object)line);
        }

        public void close() throws IOException {
        }
    }

    public static class LoggingAndErrorSubscription
    implements DKUtils.LineSubscription {
        private final StringBuilder errorMessage = new StringBuilder();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(String line, boolean replace) {
            logger.log((Priority)Level.WARN, (Object)line);
            LoggingAndErrorSubscription loggingAndErrorSubscription = this;
            synchronized (loggingAndErrorSubscription) {
                if (this.errorMessage.isEmpty()) {
                    this.errorMessage.append('\n');
                }
                this.errorMessage.append(line);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getErrorMessage() {
            LoggingAndErrorSubscription loggingAndErrorSubscription = this;
            synchronized (loggingAndErrorSubscription) {
                if (this.errorMessage.isEmpty()) {
                    return "Export script failed. Check logs for more information.";
                }
                return this.errorMessage.toString();
            }
        }

        public void close() {
        }
    }

    public static abstract class ScriptConfig {
        public List<String> urlsRequiringAuthentication;
        public boolean browserSandBoxing;
        public int pageDefaultTimeout;
        public String outputDirectory;
    }

    protected static class WarningSubscription
    implements DKUtils.LineSubscription {
        private final ExportWarningObserver observer;
        private final String warningMarker;

        public WarningSubscription(ExportWarningObserver observer, String warningMarker) {
            this.observer = (ExportWarningObserver)Preconditions.checkNotNull((Object)observer, (Object)"observer cannot be null");
            this.warningMarker = (String)Preconditions.checkNotNull((Object)warningMarker, (Object)"warningMarker cannot be null");
        }

        public void handle(String line, boolean replace) {
            if (line.startsWith(this.warningMarker)) {
                String warning = line.substring(this.warningMarker.length());
                this.observer.update(warning);
            }
        }

        public void close() throws IOException {
        }
    }

    protected static class ProgressSubscription
    implements DKUtils.LineSubscription {
        private final ExportProgressObserver observer;
        private final AtomicInteger exportedCount = new AtomicInteger(0);
        private final String progressMarker;

        public ProgressSubscription(ExportProgressObserver observer, String progressMarker) {
            this.observer = (ExportProgressObserver)Preconditions.checkNotNull((Object)observer, (Object)"observer cannot be null");
            this.progressMarker = (String)Preconditions.checkNotNull((Object)progressMarker, (Object)"progressMarker cannot be null");
        }

        public void handle(String line, boolean replace) {
            if (line.startsWith(this.progressMarker)) {
                int count = this.exportedCount.incrementAndGet();
                try {
                    this.observer.update(count);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public void close() throws IOException {
        }
    }

    public static interface ExportWarningObserver {
        public void update(String var1);
    }

    public static interface ExportProgressObserver {
        public void update(int var1) throws InterruptedException;
    }
}

