/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats;

import com.dataiku.dip.input.formats.InputFormatsDetector;
import com.dataiku.dip.input.formats.JSONFormatConfig;
import com.dataiku.dip.input.formats.LineOrientedInputSample;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class MiscFormatsDetector {
    private static Pattern jsonLike = Pattern.compile("\\s*\\{");
    private static Pattern jsonArrayLike = Pattern.compile("\\s*\\[");

    public static boolean startsWith(byte[] source, byte[] match) {
        if (source.length < match.length) {
            return false;
        }
        for (int i = 0; i < match.length; ++i) {
            if (source[i] == match[i]) continue;
            return false;
        }
        return true;
    }

    public static InputFormatsDetector.FormatWithMetadata detectMySQLDump(byte[] sample, String filename) throws Exception {
        InputFormatsDetector.FormatWithMetadata fwm = new InputFormatsDetector.FormatWithMetadata();
        fwm.type = "mysql_dump";
        fwm.detectionScore = 500.0;
        return MiscFormatsDetector.startsWith(sample, new byte[]{45, 45, 32, 77, 121, 83, 81, 76, 32, 100, 117, 109, 112}) ? fwm : null;
    }

    public static InputFormatsDetector.FormatWithMetadata detectJSON(LineOrientedInputSample sample, String filename) throws Exception {
        InputFormatsDetector.FormatWithMetadata fwm = new InputFormatsDetector.FormatWithMetadata();
        fwm.type = "json";
        fwm.detectionScore = 600 + (filename.endsWith("json") ? 800 : 0);
        String allLines = sample.allLines.toString();
        boolean matchJsonLike = jsonLike.matcher(allLines).find();
        boolean matchJsonArrayLike = jsonArrayLike.matcher(allLines).find();
        if (matchJsonLike) {
            int matchingBrackets = 0;
            for (String line : sample.lines) {
                if (StringUtils.countMatches((String)line, (String)"{") != StringUtils.countMatches((String)line, (String)"}")) continue;
                ++matchingBrackets;
            }
            fwm.params = matchingBrackets == sample.lines.size() || matchJsonArrayLike ? new JSONFormatConfig(false, false, null) : new JSONFormatConfig(true, false, null);
            return fwm;
        }
        return null;
    }
}

