/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.hive.orcfile;

import com.dataiku.dip.input.formats.BinaryHeader;
import com.dataiku.dip.input.formats.InputFormatsDetector;
import com.dataiku.dip.input.formats.hive.orcfile.ORCFileFormatConfig;
import com.dataiku.dip.input.formats.hive.orcfile.ORCFileFormatMeta;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

public class ORCFileFormatDetector {
    private static final byte[] ORCFILE_MAGIC = new byte[]{79, 82, 67};

    public Collection<? extends InputFormatsDetector.FormatWithMetadata> detect(BinaryHeader header) {
        if (header.bytes.length < ORCFILE_MAGIC.length) {
            return Collections.emptyList();
        }
        if (Arrays.equals(ORCFILE_MAGIC, Arrays.copyOfRange(header.bytes, 0, ORCFILE_MAGIC.length))) {
            InputFormatsDetector.FormatWithMetadata fwm = new InputFormatsDetector.FormatWithMetadata();
            fwm.detectionScore = 600.0;
            fwm.params = new ORCFileFormatConfig();
            fwm.type = ORCFileFormatMeta.META.getType();
            fwm.metadata = new HashMap<String, String>();
            return Arrays.asList(fwm);
        }
        return Collections.emptyList();
    }
}

