/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.anthropic.api;

import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.llm.online.anthropic.api.AnthropicChatQuery;
import com.dataiku.dip.llm.online.marshall.CoreCompletionSettings;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class AnthropicChatQueryAdapter {
    private AnthropicChatQueryAdapter() {
    }

    public static AnthropicChatQuery adapt(String model, List<LLMClient.ChatMessage> messages, CoreCompletionSettings ccs) {
        AnthropicChatQuery query = AnthropicChatQueryAdapter.adapt(messages, ccs);
        query.model = model;
        return query;
    }

    public static AnthropicChatQuery adapt(List<LLMClient.ChatMessage> messages, CoreCompletionSettings ccs) {
        AnthropicChatQuery query = new AnthropicChatQuery();
        query.messages = messages.stream().filter(Predicate.not(m -> "system".equals(m.role))).map(AnthropicChatQueryAdapter::adapt).collect(Collectors.toList());
        query.system = messages.stream().filter(m -> "system".equals(m.role)).map(LLMClient.ChatMessage::getText).collect(Collectors.joining("\n\n"));
        query.stream = false;
        query.maxTokens = Objects.requireNonNullElse(ccs.maxTokens, 4096);
        if (ccs.temperature != null) {
            query.temperature = ccs.temperature;
        }
        if (ccs.topK != null) {
            query.topK = ccs.topK;
        }
        if (ccs.topP != null) {
            query.topP = ccs.topP;
        }
        if (ccs.stopSequences != null && !ccs.stopSequences.isEmpty()) {
            query.stopSequences = ccs.stopSequences;
        }
        if (ccs.toolChoice != null) {
            query.toolChoice = AnthropicChatQueryAdapter.adapt(ccs.toolChoice);
        }
        if (ccs.tools != null && !ccs.tools.isEmpty()) {
            query.tools = ccs.tools.stream().map(AnthropicChatQueryAdapter::adapt).collect(Collectors.toList());
        }
        if (ccs.reasoningEffort != null) {
            query.thinking = new AnthropicChatQuery.Thinking();
            if (ccs.reasoningEffort.equals((Object)LLMClient.ReasoningEffort.OFF)) {
                query.thinking.type = "disabled";
            } else if (ccs.reasoningEffort.equals((Object)LLMClient.ReasoningEffort.STANDARD)) {
                query.thinking.type = "enabled";
                query.thinking.budgetTokens = 3000;
            } else if (ccs.reasoningEffort.equals((Object)LLMClient.ReasoningEffort.CUSTOM)) {
                if (StringUtils.isEmpty((String)ccs.customReasoningEffort)) {
                    throw new IllegalArgumentException(String.format("Custom reasoning effort cannot be null or empty: %s ", ccs.customReasoningEffort));
                }
                try {
                    int budgetTokens = Integer.parseInt(ccs.customReasoningEffort);
                    query.thinking.type = "enabled";
                    query.thinking.budgetTokens = budgetTokens;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.format("Invalid 'customReasoningEffort' for Anthropic: Expected an integer (number of tokens for reasoning), but received '%s'.", ccs.customReasoningEffort));
                }
            } else {
                throw new IllegalArgumentException(String.format("Unsupported Reasoning Effort for Anthropic: expected OFF, STANDARD or CUSTOM but received %s.", new Object[]{ccs.reasoningEffort}));
            }
        }
        return query;
    }

    private static AnthropicChatQuery.Message adapt(LLMClient.ChatMessage message) {
        if (!"user".equals(message.role) && !"assistant".equals(message.role)) {
            throw new IllegalArgumentException(String.format("Unsupported chat message role: %s", message.role));
        }
        AnthropicChatQuery.Message msg = new AnthropicChatQuery.Message();
        msg.content = new ArrayList<AnthropicChatQuery.MessagePart>();
        if (message.isTextOnly()) {
            String text = message.getText();
            if (text != null) {
                AnthropicChatQuery.TextMessagePart tm = new AnthropicChatQuery.TextMessagePart();
                tm.text = text;
                msg.content.add(tm);
            }
        } else {
            List messageParts = message.parts.stream().map(AnthropicChatQueryAdapter::adapt).collect(Collectors.toList());
            msg.content.addAll(messageParts);
        }
        if ("user".equals(message.role)) {
            msg.role = AnthropicChatQuery.MessageRole.user;
            if (message.toolOutputs != null) {
                List toolOutputParts = message.toolOutputs.stream().map(AnthropicChatQueryAdapter::adapt).collect(Collectors.toList());
                msg.content.addAll(toolOutputParts);
            }
        }
        if ("assistant".equals(message.role)) {
            msg.role = AnthropicChatQuery.MessageRole.assistant;
            if (message.toolCalls != null) {
                List toolCallsPart = message.toolCalls.stream().map(AnthropicChatQueryAdapter::adapt).collect(Collectors.toList());
                msg.content.addAll(toolCallsPart);
            }
        }
        return msg;
    }

    private static AnthropicChatQuery.MessagePart adapt(LLMClient.ChatMessagePart part) {
        switch (part.type) {
            case TEXT: {
                AnthropicChatQuery.TextMessagePart textPart = new AnthropicChatQuery.TextMessagePart();
                textPart.text = part.text;
                return textPart;
            }
            case IMAGE_INLINE: {
                AnthropicChatQuery.ImageSource source = new AnthropicChatQuery.ImageSource();
                source.mediaType = part.imageMimeType == null ? "image/jpeg" : part.imageMimeType;
                source.data = part.inlineImage;
                AnthropicChatQuery.ImageMessagePart imagePart = new AnthropicChatQuery.ImageMessagePart();
                imagePart.source = source;
                return imagePart;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported assistant message part type: %s", new Object[]{part.type}));
    }

    private static AnthropicChatQuery.ToolUseMessagePart adapt(LLMClient.AbstractToolCall atc) {
        if (atc instanceof LLMClient.FunctionToolCall) {
            LLMClient.FunctionToolCall ftc = (LLMClient.FunctionToolCall)atc;
            AnthropicChatQuery.ToolUseMessagePart tu = new AnthropicChatQuery.ToolUseMessagePart();
            tu.id = ftc.id;
            tu.name = ftc.function.name;
            tu.input = (JsonObject)JSON.parse((String)ftc.function.arguments, JsonObject.class);
            return tu;
        }
        throw new IllegalArgumentException(String.format("Unknown tool call: %s", atc.getClass().getSimpleName()));
    }

    private static AnthropicChatQuery.ToolResultMessagePart adapt(LLMClient.ToolOutput to) {
        AnthropicChatQuery.ToolResultMessagePart tr = new AnthropicChatQuery.ToolResultMessagePart();
        tr.toolUseId = to.callId;
        tr.content = to.output;
        return tr;
    }

    private static AnthropicChatQuery.ToolChoice adapt(LLMClient.ToolChoice choice) {
        if (choice instanceof LLMClient.NoneToolChoice) {
            throw new IllegalArgumentException("The Anthropic Claude API does not support tool choice: \"none\"");
        }
        if (choice instanceof LLMClient.RequiredToolChoice) {
            AnthropicChatQuery.ToolChoice tc = new AnthropicChatQuery.ToolChoice();
            tc.type = AnthropicChatQuery.ToolChoiceType.any;
            return tc;
        }
        if (choice instanceof LLMClient.AutoToolChoice) {
            AnthropicChatQuery.ToolChoice tc = new AnthropicChatQuery.ToolChoice();
            tc.type = AnthropicChatQuery.ToolChoiceType.auto;
            return tc;
        }
        if (choice instanceof LLMClient.NamedToolChoice) {
            LLMClient.NamedToolChoice ntc = (LLMClient.NamedToolChoice)choice;
            AnthropicChatQuery.ToolChoice tc = new AnthropicChatQuery.ToolChoice();
            tc.type = AnthropicChatQuery.ToolChoiceType.tool;
            tc.name = ntc.name;
            return tc;
        }
        throw new IllegalArgumentException(String.format("Unknown tool choice: %s", choice.getClass().getSimpleName()));
    }

    private static AnthropicChatQuery.Tool adapt(LLMClient.AbstractTool tool) {
        if (tool instanceof LLMClient.FunctionTool) {
            LLMClient.FunctionTool fDesc = (LLMClient.FunctionTool)tool;
            AnthropicChatQuery.Tool t = new AnthropicChatQuery.Tool();
            t.name = fDesc.function.name;
            t.description = fDesc.function.description;
            t.inputSchema = fDesc.function.getParameters();
            return t;
        }
        throw new IllegalArgumentException(String.format("Unknown tool: %s", tool.getClass().getSimpleName()));
    }
}

