/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.mistralai;

import com.dataiku.dip.connections.AbstractLLMConnection;
import com.dataiku.dip.connections.ConnectionUtils;
import com.dataiku.dip.connections.MistralAIConnection;
import com.dataiku.dip.llm.LLMModelHandle;
import com.dataiku.dip.llm.LLMStructuredRef;
import com.dataiku.dip.llm.online.AbstractLLMClient;
import com.dataiku.dip.llm.online.LLMChatMessageUtils;
import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.llm.online.LLMQueryRunner;
import com.dataiku.dip.llm.online.marshall.CoreCompletionSettings;
import com.dataiku.dip.llm.online.mistralai.RawMistralAIClient;
import com.dataiku.dip.llm.utils.OnlineLLMUtils;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class MistralAIClient
extends AbstractLLMClient
implements LLMClient {
    private final MistralAIConnection connection;
    private final LLMQueryRunner queryRunner;
    private final MistralAIConnection.MistralAIModel model;
    private final RawMistralAIClient raw;
    private ComputeResourceUsage.InternalLLMUsageData usageData = new ComputeResourceUsage.LLMUsageData();

    public MistralAIClient(MistralAIConnection connection, LLMModelHandle<MistralAIConnection.MistralAIModel> modelHandle, String apiKey) {
        super(modelHandle.getEnrichedRef());
        this.connection = connection;
        this.queryRunner = new LLMQueryRunner(this.getProviderId(), modelHandle, connection.params.networkSettings, OnlineLLMUtils::isRetryableException);
        this.model = modelHandle.getModel();
        boolean forceContentLength = ConnectionUtils.getParamsFromProperties(connection.getDkuProperties()).getBoolParam("dku.connection.llm.forceContentLength", false);
        this.raw = new RawMistralAIClient(apiKey, this.queryRunner.getHttpClientNetworkSettings(), connection.getProxySettings(), forceContentLength);
    }

    @Override
    public boolean supportNativeBatch() {
        return false;
    }

    @Override
    public boolean requiresCostLimiting() {
        return true;
    }

    @Override
    public String getProviderId() {
        return "MistralAI";
    }

    @Override
    public boolean supportsStream() {
        return true;
    }

    @Override
    public AbstractLLMConnection getConnection() {
        return this.connection;
    }

    @Override
    public int getMaxParallelism() {
        return this.connection.params.maxParallelism;
    }

    @Override
    public int getBatchSize(AbstractLLMConnection.QueryType queryType, LLMStructuredRef llmRef) {
        switch (queryType) {
            case textEmbedding: {
                if (this.model.getBatchSize().isPresent()) {
                    logger.info((Object)"Using user defined batch size");
                    return this.model.getBatchSize().getAsInt();
                }
                return 10;
            }
        }
        return 1;
    }

    @Override
    public List<LLMClient.ChatMessage> getFormattedPrompt(List<LLMClient.ChatMessage> chatMessages) {
        return MistralAIClient.formatChatMessages(chatMessages);
    }

    public static List<LLMClient.ChatMessage> formatChatMessages(List<LLMClient.ChatMessage> chatMessages) {
        return LLMChatMessageUtils.convertExtraSystemMessageToUser(chatMessages);
    }

    @Override
    public List<LLMClient.SimpleCompletionResponse> completeBatch(List<LLMClient.SingleCompletionQuery> queries, LLMClient.CompletionSettings settings) throws Exception {
        CoreCompletionSettings ccs = this.getCoreCompletionSettings(settings);
        ArrayList<LLMClient.SimpleCompletionResponse> ret = new ArrayList<LLMClient.SimpleCompletionResponse>();
        for (LLMClient.SingleCompletionQuery query : queries) {
            long before = System.currentTimeMillis();
            logger.info((Object)("Mistral AI single complete query: " + JSON.json((Object)query.getSafeForLoggingCopy())));
            List<LLMClient.ChatMessage> chatMessages = this.getFormattedPrompt(query.messages);
            LLMClient.SimpleCompletionResponse scr = this.queryRunner.run(() -> this.raw.chatComplete(this.model.getId(), chatMessages, ccs));
            scr.estimatedCost = this.model.getEstimatedCompletionCost(scr.promptTokens, scr.completionTokens);
            scr.includeInUsageData(this.usageData, System.currentTimeMillis() - before);
            ret.add(scr);
        }
        return ret;
    }

    @Override
    public void streamComplete(LLMClient.SingleCompletionQuery query, LLMClient.CompletionSettings settings, LLMClient.StreamedCompletionResponseConsumer consumer) throws Exception {
        logger.trace(() -> "Mistral AI completion stream starting: " + JSON.json((Object)query.getSafeForLoggingCopy()));
        CoreCompletionSettings ccs = this.getCoreCompletionSettings(settings);
        Stopwatch stopwatch = Stopwatch.createStarted();
        List<LLMClient.ChatMessage> chatMessages = this.getFormattedPrompt(query.messages);
        LLMClient.StreamedCompletionResponseConsumerProxy wrappedConsumer = new LLMClient.StreamedCompletionResponseConsumerProxy(consumer, (ExceptionUtils.ThrowingConsumer<LLMClient.StreamedCompletionResponseFooter, Exception>)((ExceptionUtils.ThrowingConsumer)footer -> footer.includeInUsageData(this.usageData, stopwatch.elapsed(TimeUnit.MILLISECONDS))));
        this.queryRunner.run(() -> {
            this.raw.streamChatComplete(wrappedConsumer, this.model, chatMessages, ccs);
            return null;
        });
    }

    @Override
    public List<LLMClient.SimpleEmbeddingResponse> embedBatch(List<LLMClient.EmbeddingQuery> queries, LLMClient.EmbeddingSettings settings) throws Exception {
        ArrayList<LLMClient.SimpleEmbeddingResponse> ret = new ArrayList<LLMClient.SimpleEmbeddingResponse>();
        long before = System.currentTimeMillis();
        List batchTexts = queries.stream().map(query -> query.text).collect(Collectors.toList());
        logger.info((Object)("Mistral AI Embed sending the following batch : " + JSON.json(batchTexts)));
        List EmbeddingResponses = this.queryRunner.run(() -> this.raw.embed(this.model.getId(), batchTexts));
        this.usageData.incrementTotalComputationTimeMS(Long.valueOf(System.currentTimeMillis() - before));
        for (LLMClient.SimpleEmbeddingResponse scr : EmbeddingResponses) {
            scr.estimatedCost = this.model.getEstimatedEmbeddingCost(scr.promptTokens, 0);
            scr.includeInUsageData(this.usageData);
            ret.add(scr);
        }
        return ret;
    }

    @Override
    public List<LLMClient.SingleRerankingResponse> rerankBatch(List<LLMClient.RerankingQuery> queries, LLMClient.RerankingSettings settings) throws Exception {
        throw new IllegalArgumentException("Reranking not supported on this LLM");
    }

    @Override
    public ComputeResourceUsage getTotalCRU(ComputeResourceUsage.LLMUsageType usageType, LLMStructuredRef llmRef) {
        ComputeResourceUsage cru = new ComputeResourceUsage();
        cru.setupLLMUsage(usageType, llmRef.connection, llmRef.type.toString(), llmRef.id);
        cru.llmUsage.setFromInternal(this.usageData);
        return cru;
    }

    @Override
    public void close() throws Exception {
        this.raw.close();
    }
}

