/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.openai;

import com.dataiku.dip.connections.AbstractAzureAIConnection;
import com.dataiku.dip.connections.AbstractLLMConnection;
import com.dataiku.dip.connections.AzureOpenAIConnection;
import com.dataiku.dip.connections.ConnectionWithAzureAuthCredentials;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.externalinfras.azureml.AzureMLUtils;
import com.dataiku.dip.externalinfras.azureml.http.AzureMLHttpClient;
import com.dataiku.dip.llm.LLMModelHandle;
import com.dataiku.dip.llm.online.ISavedModelDeployer;
import com.dataiku.dip.llm.online.openai.AbstractAzureAIClient;
import com.dataiku.dip.llm.online.openai.AzureOpenAISavedModelDeployer;
import com.dataiku.dip.llm.online.openai.RawOpenAIClient;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nullable;

public class AzureOpenAIClient
extends AbstractAzureAIClient<AzureOpenAIConnection.AzureOpenAIDeployment, AzureOpenAIConnection, AzureOpenAIConnection.HardcodedAzureOpenAIModel, AzureOpenAIConnection.CustomAzureOpenAIModel> {
    private AzureMLHttpClient azureMLHttpClient;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.llm.azureopenai");

    public AzureOpenAIClient(AzureOpenAIConnection connection, LLMModelHandle<AbstractAzureAIConnection.AbstractAzureAIModel> modelHandle, AuthCtx authCtx, @Nullable String projectKey) throws DKUSecurityException, IOException {
        super(connection, modelHandle, authCtx, projectKey);
    }

    @Override
    protected void setRawClient(AzureOpenAIConnection connection, AuthCtx authCtx, @Nullable String projectKey, ConnectionWithAzureAuthCredentials.SerializableAzureAuthCredentials creds, AbstractLLMConnection.HTTPBasedLLMNetworkSettings networkSettings, boolean trustAllSSLCertificates, boolean forceContentLength) {
        switch (creds.authType) {
            case OAUTH2_APP: {
                this.raw = RawOpenAIClient.forAzureWithOAuthToken(connection.params.resourceName, creds.oauth2AccessToken, connection.params.customHeaders, projectKey, networkSettings, connection.getProxySettings(), trustAllSSLCertificates, forceContentLength, authCtx, connection);
                break;
            }
            case KEY: {
                this.raw = RawOpenAIClient.forAzureWithAPIKey(connection.params.resourceName, creds.key, connection.params.customHeaders, projectKey, networkSettings, connection.getProxySettings(), trustAllSSLCertificates, forceContentLength, authCtx, connection);
            }
        }
    }

    @Override
    public ISavedModelDeployer newSavedModelDeployer(AuthCtx authCtx) throws AzureMLUtils.AzureAuthenticationException, IOException, DKUSecurityException {
        if (((AzureOpenAIConnection)this.connection).params.azureMLConnection != null && this.azureMLHttpClient == null) {
            int defaultConnectTimeout = 120000;
            int defaultSocketTimeout = 60000;
            this.azureMLHttpClient = AzureMLUtils.getAzureMLClient_NT(authCtx, ((AzureOpenAIConnection)this.connection).params.azureMLConnection, defaultConnectTimeout, defaultSocketTimeout);
        }
        String resourceName = ((AzureOpenAIConnection)this.connection).params.resourceName;
        if (((AzureOpenAIConnection)this.connection).params.resourceName.startsWith("http://") || ((AzureOpenAIConnection)this.connection).params.resourceName.startsWith("https://")) {
            resourceName = Arrays.stream(Arrays.stream(((AzureOpenAIConnection)this.connection).params.resourceName.split("://")).toList().get(1).split(".openai.azure.com/openai")).findFirst().get();
        }
        if (this.azureMLHttpClient == null) {
            throw new IllegalArgumentException("Error creating the Azure ML Http client. Make sure you have an Azure ML connection in your Azure Open AI Connection");
        }
        if (((AzureOpenAIConnection)this.connection).params.subscriptionId == null || ((AzureOpenAIConnection)this.connection).params.subscriptionId.isEmpty()) {
            throw new IllegalArgumentException("Please define a subscription id in your Azure Open AI connection '" + ((AzureOpenAIConnection)this.connection).name + "' to access your model deployments.");
        }
        if (((AzureOpenAIConnection)this.connection).params.resourceGroup == null || ((AzureOpenAIConnection)this.connection).params.resourceGroup.isEmpty()) {
            throw new IllegalArgumentException("Please define a resource group in your Azure Open AI connection '" + ((AzureOpenAIConnection)this.connection).name + "' to access your model deployments.");
        }
        return new AzureOpenAISavedModelDeployer(this.azureMLHttpClient, ((AzureOpenAIConnection)this.connection).params.subscriptionId, ((AzureOpenAIConnection)this.connection).params.resourceGroup, resourceName);
    }

    @Override
    public String getLogPrefix() {
        return "AzureOpenAI";
    }

    @Override
    protected DKULogger getLogger() {
        return logger;
    }
}

