/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.snowflakecortex;

import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.llm.online.snowflakecortex.SnowflakeCortexRESTCompletionNonStreamedResponse;
import com.dataiku.dip.utils.JSON;
import java.util.ArrayList;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class SnowflakeCompletionRESTResponseAdapter {
    private SnowflakeCompletionRESTResponseAdapter() {
    }

    public static LLMClient.SimpleCompletionResponse adapt(SnowflakeCortexRESTCompletionNonStreamedResponse response) {
        if (response.choices == null || response.choices.isEmpty()) {
            throw new IllegalArgumentException("Empty completion response");
        }
        if (response.choices == null || response.choices.isEmpty()) {
            throw new IllegalArgumentException("Empty chat response");
        }
        SnowflakeCortexRESTCompletionNonStreamedResponse.Choice choice = response.choices.get(0);
        LLMClient.SimpleCompletionResponse resp = new LLMClient.SimpleCompletionResponse();
        if (StringUtils.equals((String)choice.finishReason, (String)"prohibited_content")) {
            resp.finishReason = LLMClient.FinishReason.CONTENT_FILTER;
        }
        if (choice.message != null) {
            resp.text = choice.message.content;
            if (CollectionUtils.isNotEmpty(choice.message.contentList)) {
                for (SnowflakeCortexRESTCompletionNonStreamedResponse.ContentListItem cli : choice.message.contentList) {
                    if (!StringUtils.equals((String)cli.type, (String)"tool_use") || cli.toolUse == null) continue;
                    if (resp.toolCalls == null) {
                        resp.toolCalls = new ArrayList<LLMClient.AbstractToolCall>();
                    }
                    LLMClient.FunctionToolCall ftc = new LLMClient.FunctionToolCall();
                    ftc.function = new LLMClient.FunctionToolCallInfo();
                    ftc.id = cli.toolUse.toolUseId;
                    ftc.function.name = cli.toolUse.name;
                    ftc.function.arguments = JSON.pretty((Object)cli.toolUse.input);
                    resp.toolCalls.add(ftc);
                }
            }
        }
        resp.promptTokens = response.usage.promptTokens;
        resp.completionTokens = response.usage.completionTokens;
        resp.totalTokens = response.usage.totalTokens;
        return resp;
    }
}

