/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.maintainance;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.utils.ExceptionUtils;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.hadoop.metrics2.impl.MetricsSystemImpl;
import org.apache.log4j.Logger;

public class CleanS3AInstrumentationsTask {
    private static Timer expirationTimer = null;
    private static Class<?> s3aInstrumentationClazz = null;
    private static final Logger logger = Logger.getLogger((String)"dku.fs.s3.cleanup");

    public static synchronized void startCleanupThreadIfNeeded() {
        if (expirationTimer == null) {
            Timer expirationTimer = new Timer("S3AInstrumentation-cleanup", true);
            try {
                s3aInstrumentationClazz = Class.forName("org.apache.hadoop.fs.s3a.S3AInstrumentation");
            }
            catch (Throwable t) {
                logger.debug((Object)("Cannot load S3AInstrumentation (" + ExceptionUtils.getMessageWithCauses((Throwable)t) + "), not scheduling cleanup"));
                return;
            }
            assert (s3aInstrumentationClazz != null);
            int periodSeconds = ApplicationConfigurator.getParams().getIntParam("dku.maintenance.clean-s3a-instrumentation.periodS", Integer.valueOf(300));
            if (periodSeconds <= 0) {
                logger.info((Object)"Cleanup of S3AInstrumentation instances is disabled");
                return;
            }
            long delay = (long)periodSeconds * 1000L;
            logger.info((Object)("Starting S3AInstrumentation cleanup with delay " + delay + " ms"));
            expirationTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    logger.info((Object)"Performing routine cleanup of S3AInstrumentation instances");
                    new CleanS3AInstrumentationsTask().execute();
                }
            }, delay, delay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        if (s3aInstrumentationClazz == null) {
            return;
        }
        try {
            Map allSources;
            Field metricsSystemField = s3aInstrumentationClazz.getDeclaredField("metricsSystem");
            metricsSystemField.setAccessible(true);
            MetricsSystemImpl metricsSystem = (MetricsSystemImpl)metricsSystemField.get(null);
            if (metricsSystem == null) {
                logger.debug((Object)"S3AInstrumentation's metricsSystem is not yet instantiated, no cleanup to do");
                return;
            }
            if (!Class.forName("org.apache.hadoop.metrics2.impl.MetricsSystemImpl").isAssignableFrom(metricsSystem.getClass())) {
                logger.warn((Object)("Metrics system of unexpected type " + metricsSystem.getClass().getCanonicalName() + " , trying to get allSources field"));
            }
            logger.debug((Object)("Got metricsSystem=" + String.valueOf(metricsSystem) + " , going for the allSources map"));
            Field allSourcesField = MetricsSystemImpl.class.getDeclaredField("allSources");
            allSourcesField.setAccessible(true);
            MetricsSystemImpl metricsSystemImpl = metricsSystem;
            synchronized (metricsSystemImpl) {
                allSources = (Map)allSourcesField.get(metricsSystem);
                allSources = Maps.newHashMap((Map)allSources);
            }
            int unregistered = 0;
            for (Map.Entry sourceEntry : allSources.entrySet()) {
                Object source;
                String sourceName = (String)sourceEntry.getKey();
                if (!sourceName.startsWith("S3AMetrics")) continue;
                try {
                    metricsSystem.unregisterSource(sourceName);
                    ++unregistered;
                }
                catch (Exception e) {
                    logger.warn((Object)"Unable to unregister", (Throwable)e);
                }
                if (!((source = sourceEntry.getValue()) instanceof AutoCloseable)) continue;
                try {
                    ((AutoCloseable)source).close();
                }
                catch (Exception e) {
                    logger.warn((Object)"Unable to close the instrumentation", (Throwable)e);
                }
            }
            logger.info((Object)("Unregistered " + unregistered + " sources"));
        }
        catch (Throwable t) {
            logger.error((Object)"Failed to cleanup S3AInstrumentation instances", t);
        }
    }
}

