/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.nodeclients;

import com.dataiku.common.rpc.APIKeyAuthAPIClient;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.apideployer.DeployerCodes;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractProjectDeploymentHeavyStatus;
import com.dataiku.dip.apideployer.datamodel.config.AbstractProjectDeploymentInfra;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.directory.NodeConnection;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.nodeclients.IUnifiedMonitoringClient;
import com.dataiku.dip.projects.importexport.AbstractBundleService;
import com.dataiku.dip.projects.importexport.BundleActivator;
import com.dataiku.dip.projects.importexport.BundlePreloader;
import com.dataiku.dip.projects.importexport.CommonBundleUtils;
import com.dataiku.dip.projects.importexport.model.BundleActivationTestResult;
import com.dataiku.dip.scheduler.scenarios.TestingStatus;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.auth.UserAuthenticationService;
import com.dataiku.dip.security.model.PersonalPublicAPIKey;
import com.dataiku.dip.server.services.ProjectFoldersService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.ScenarioReportsService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.unifiedmonitoring.ModelStatus;
import com.dataiku.dip.unifiedmonitoring.payloads.UnifiedMonitoringProxySMVWithModelStatus;
import com.dataiku.dip.unifiedmonitoring.project.ProjectDataQualityDTO;
import com.dataiku.dip.unifiedmonitoring.project.ProjectModelStatus;
import com.dataiku.dip.unifiedmonitoring.project.ProjectScenarioRunsDTO;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss.shadelib.org.apache.http.client.utils.URIBuilder;
import com.dataiku.dss.shadelib.org.apache.http.entity.ContentType;
import com.dataiku.dss.shadelib.org.apache.http.entity.mime.HttpMultipartMode;
import com.dataiku.dss.shadelib.org.apache.http.entity.mime.MultipartEntityBuilder;
import com.dataiku.dss.shadelib.org.apache.http.entity.mime.content.ContentBody;
import com.dataiku.dss.shadelib.org.apache.http.entity.mime.content.FileBody;
import com.dataiku.dss.shadelib.org.apache.http.entity.mime.content.StringBody;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class AutomationNodeClient
extends APIKeyAuthAPIClient
implements IUnifiedMonitoringClient {
    private static final String PUBLIC_API_BASE = "public/api/";
    private static final String PROJECTS_BASE_URL = "public/api/projects/";
    private static final String BUNDLES_IMPORTED_PATH = "/bundles/imported";
    @Nullable
    public final String automationNodeId;
    public String externalUrl;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.deployment.automation.client");

    private AutomationNodeClient(NodeConnection connection, ProxySettings proxySettings, int connectTimeout, int socketTimeout) {
        super(connection.url, connection.adminAPIKey, connection.trustAllSSLCertificates, proxySettings, connectTimeout, socketTimeout);
        this.automationNodeId = connection.automationNodeId;
        this.externalUrl = connection.externalUrl;
    }

    public static AutomationNodeClient automationNodeOverridableProxyUserClient(AuthCtx authCtx, AbstractProjectDeploymentInfra infra, NodeConnection nodeConnection, String targetProjectKey, int connectTimeout, int socketTimeout) throws CodedException {
        String identifier;
        String deployAsUserForTargetProject = infra.getDeployAsUserForTargetProject(targetProjectKey);
        if (StringUtils.isNotEmpty((String)deployAsUserForTargetProject)) {
            identifier = deployAsUserForTargetProject;
        } else {
            if (infra.setDeployAsUser && infra.mandatoryDeployAsUser) {
                throw new IllegalArgumentException("Infra " + infra.id + " requires a deployAs user to be defined for target project " + targetProjectKey + " but none defined");
            }
            identifier = authCtx.getIdentifier();
        }
        return AutomationNodeClient.automationNodeProxyUserClient(identifier, nodeConnection, connectTimeout, socketTimeout);
    }

    public static AutomationNodeClient automationNodeProxyUserClient(AuthCtx authCtx, AbstractProjectDeploymentInfra infra, NodeConnection nodeConnection, int connectTimeout, int socketTimeout) throws CodedException {
        String identifier;
        if (infra.setDeployAsUser && StringUtils.isNotEmpty((String)infra.deployAsUser)) {
            identifier = infra.deployAsUser;
            logger.debug((Object)("Using infra default deployAs user " + identifier + " to connect to automation node."));
        } else {
            identifier = authCtx.getIdentifier();
            logger.debug((Object)("No default deployAs user configured. Using current user " + identifier + " to connect to automation node."));
        }
        return AutomationNodeClient.automationNodeProxyUserClient(identifier, nodeConnection, connectTimeout, socketTimeout);
    }

    public static AutomationNodeClient automationNodeProxyUserClient(String identifier, NodeConnection connection, int connectTimeout, int socketTimeout) throws CodedException {
        AutomationNodeClient client = AutomationNodeClient.automationNodeClient(connection, null, connectTimeout, socketTimeout);
        AutomationNodeClient.addUserHeader(client, identifier);
        return client;
    }

    public static AutomationNodeClient automationNodeClient(NodeConnection connection, ProxySettings proxySettings, int connectTimeout, int socketTimeout) throws CodedException {
        if (!connection.canOpenClient()) {
            logger.errorV("The automation node %s cannot be reached (%s)", new Object[]{connection.automationNodeId, connection.nodeDirectoryStatus});
            throw new CodedException((InfoMessage.MessageCode)DeployerCodes.ERR_PROJECT_DEPLOYER_AUTOMATION_NODE_NOT_REACHABLE, String.format("The automation node %s cannot be reached (%s)", connection.automationNodeId, connection.nodeDirectoryStatus));
        }
        return new AutomationNodeClient(connection, proxySettings, connectTimeout, socketTimeout);
    }

    public static void addUserHeader(AutomationNodeClient client, String identifier) {
        if ("api:dku-internal-collection".equals(identifier)) {
            logger.debugV("Not proxifying user %s", new Object[]{identifier});
        } else {
            client.addHeader("X-DKU-ProxyUser", identifier);
        }
    }

    protected String getPossibleBadInfraHint() {
        return ", please check URL of infra (" + this.baseURI + ") or server version";
    }

    public List<ProjectsService.UIProject> getProjects() throws IOException {
        JsonArray ret = (JsonArray)this.get(PROJECTS_BASE_URL, JsonArray.class);
        return (List)JSON.parse((JsonElement)ret, (TypeToken)new TypeToken<List<ProjectsService.UIProject>>(){});
    }

    public List<String> getProjectKeys() throws IOException {
        List<ProjectsService.UIProject> projects = this.getProjects();
        ArrayList<String> projectKeys = new ArrayList<String>();
        for (ProjectsService.UIProject project : projects) {
            projectKeys.add(project.projectKey);
        }
        return projectKeys;
    }

    public String getNodeType() throws IOException {
        return (String)this.get("public/api/admin/get-node-type", String.class);
    }

    @Override
    public ProjectsService.UIProject getProjectSummary(String projectKey) throws IOException {
        return (ProjectsService.UIProject)this.get(PROJECTS_BASE_URL + projectKey, ProjectsService.UIProject.class);
    }

    public List<UsersService.APIUser> listUsers() throws IOException {
        JsonArray ret = (JsonArray)this.get("public/api/admin/users", JsonArray.class);
        return (List)JSON.parse((JsonElement)ret, (TypeToken)new TypeToken<List<UsersService.APIUser>>(){});
    }

    @Nonnull
    public UserAuthenticationService.UserAuthInfo userExists(String userLogin) throws IOException {
        return (UserAuthenticationService.UserAuthInfo)this.get("public/api/admin/user-exists/" + userLogin, UserAuthenticationService.UserAuthInfo.class);
    }

    public CommonBundleUtils.BundleInfoList listBundles(String projectKey) throws IOException {
        return (CommonBundleUtils.BundleInfoList)this.get(this.projectUrl(projectKey) + BUNDLES_IMPORTED_PATH, CommonBundleUtils.BundleInfoList.class);
    }

    public List<String> listConnectionsNames() throws IOException, URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder("public/api/connections/get-names");
        uriBuilder.addParameter("type", "all");
        return (List)this.get(uriBuilder.build().toString(), (TypeToken)new TypeToken<List<String>>(){});
    }

    public Map<String, DSSConnection> listAdminConnections() throws IOException, URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder("public/api//admin/connections/");
        return (Map)this.get(uriBuilder.build().toString(), (TypeToken)new TypeToken<Map<String, DSSConnection>>(){});
    }

    @Nonnull
    public List<String> listContainerExecNames() throws IOException, URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder("public/api/container-exec/list-names");
        return (List)this.get(uriBuilder.build().toString(), (TypeToken)new TypeToken<List<String>>(){});
    }

    private MultipartEntityBuilder getBundleHttpEntityBuilder(File bundle) {
        FileBody fileBody = new FileBody(bundle, ContentType.DEFAULT_BINARY);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        builder.addPart("file", (ContentBody)fileBody);
        return builder;
    }

    public void createWithInitialBundle(File bundle, String newProjectKey, String projectFolderId, AbstractProjectDeploymentInfra.PermissionsPropagationPolicy permissionsPropagationPolicy) throws IOException {
        MultipartEntityBuilder builder = this.getBundleHttpEntityBuilder(bundle);
        builder.addPart("projectKey", (ContentBody)new StringBody(newProjectKey, ContentType.MULTIPART_FORM_DATA));
        if (StringUtils.isNotBlank((String)projectFolderId)) {
            builder.addPart("projectFolderId", (ContentBody)new StringBody(projectFolderId, ContentType.MULTIPART_FORM_DATA));
        }
        builder.addPart("permissionsPropagationPolicy", (ContentBody)new StringBody(String.valueOf((Object)permissionsPropagationPolicy), ContentType.MULTIPART_FORM_DATA));
        this.postAnyToJSON("public/api/projectsFromBundle/", Void.class, builder.build());
    }

    public void importBundle(File bundle, String projectKey, boolean allowProjectKeyMismatch) throws IOException {
        MultipartEntityBuilder builder = this.getBundleHttpEntityBuilder(bundle);
        builder.addPart("allowProjectKeyMismatch", (ContentBody)new StringBody(String.valueOf(allowProjectKeyMismatch), ContentType.MULTIPART_FORM_DATA));
        this.postAnyToJSON(this.projectUrl(projectKey) + "/bundles/imported/actions/importFromStream", Void.class, builder.build());
    }

    public BundleActivationTestResult activateCheck(String projectKey, String bundleId) throws IOException {
        return (BundleActivationTestResult)((Object)this.get(this.projectUrl(projectKey) + this.bundleUrl(bundleId) + "/actions/activate-check", BundleActivationTestResult.class));
    }

    public FutureResponse<BundlePreloader.BundlePreloadingReport> startPreload(String projectKey, String bundleId, AbstractBundleService.BundlePreloadOptions preloadOptions) throws IOException {
        return (FutureResponse)this.postObject(this.projectUrl(projectKey) + this.bundleUrl(bundleId) + "/actions/preload", (TypeToken)new TypeToken<FutureResponse<BundlePreloader.BundlePreloadingReport>>(){}, preloadOptions);
    }

    public FutureResponse<BundleActivator.BundleActivationReport> startActivate(String projectKey, String bundleId, AbstractBundleService.BundleActivationOptions activationOptions) throws IOException {
        return (FutureResponse)this.postObject(this.projectUrl(projectKey) + this.bundleUrl(bundleId) + "/actions/activate", (TypeToken)new TypeToken<FutureResponse<BundleActivator.BundleActivationReport>>(){}, activationOptions);
    }

    public JsonObject getSettings(String projectKey) throws IOException {
        return (JsonObject)this.get(this.projectUrl(projectKey) + "/settings", JsonObject.class);
    }

    public void saveSettings(String projectKey, JsonObject settings) throws IOException {
        this.putObject(this.projectUrl(projectKey) + "/settings", Void.class, settings);
    }

    public VariablesService.ProjectVariables getVariables(String projectKey) throws IOException {
        return (VariablesService.ProjectVariables)this.get(this.projectUrl(projectKey) + "/variables", VariablesService.ProjectVariables.class);
    }

    public void saveVariables(String projectKey, VariablesService.ProjectVariables variables) throws IOException {
        this.putObject(this.projectUrl(projectKey) + "/variables", Void.class, variables);
    }

    public AbstractProjectDeploymentHeavyStatus.InfoMap listHeavyStatus(List<String> projectKeys) throws IOException {
        String path = "public/api/projects/heavy-status/list";
        JsonArray jsonArray = new JsonArray();
        projectKeys.forEach(arg_0 -> ((JsonArray)jsonArray).add(arg_0));
        JsonObject requestBody = new JsonObject();
        requestBody.add("projectKeys", (JsonElement)jsonArray);
        requestBody.add("autoStartedWebappsOnly", (JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
        requestBody.add("includeWebappsWithNoBackend", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
        return (AbstractProjectDeploymentHeavyStatus.InfoMap)this.postObject(path, AbstractProjectDeploymentHeavyStatus.InfoMap.class, requestBody);
    }

    public ScenarioReportsService.ScenarioDays getScenarioRunsWithinDateRange(String projectKey, String fromDateStr, String toDateStr, boolean includeOutOfDatesScenarios) throws IOException {
        return (ScenarioReportsService.ScenarioDays)this.get(this.projectUrl(projectKey) + "/scenarios/get-outcomes?fromDate=" + fromDateStr + "&toDate=" + toDateStr + "&includeOutOfDatesScenarios=" + includeOutOfDatesScenarios, ScenarioReportsService.ScenarioDays.class);
    }

    public ProjectFoldersService.ProjectFolderSummary getProjectFolderHierarchy() throws IOException {
        return (ProjectFoldersService.ProjectFolderSummary)this.get("public/api/project-folders/hierarchy/", ProjectFoldersService.ProjectFolderSummary.class);
    }

    public ProjectModelStatus getProjectModelStatus(@Nonnull String projectKey) throws IOException {
        String getProjectModelStatusUrl = PROJECTS_BASE_URL + String.format("%s/unified-monitoring-automation/models-status", projectKey);
        return (ProjectModelStatus)this.getForm(getProjectModelStatusUrl, ProjectModelStatus.class, new Object[0]);
    }

    @Override
    public ModelStatus getModelStatus(@Nonnull String projectKey, @Nonnull String modelId, @Nullable List<String> mesToFilterOn) throws IOException {
        String getModelStatusUrl = PROJECTS_BASE_URL + String.format("%s/unified-monitoring-automation/model-status/%s", projectKey, modelId);
        return (ModelStatus)this.getForm(getModelStatusUrl, ModelStatus.class, new Object[0]);
    }

    @Override
    public List<UnifiedMonitoringProxySMVWithModelStatus> listProxyModelVersionWithModelStatus() throws Exception {
        throw new Error("Not implemented");
    }

    public ProjectScenarioRunsDTO getLastScenariosRun(@Nonnull String projectKey) throws IOException {
        String getLastScenariosRunUrl = PROJECTS_BASE_URL + String.format("%s/unified-monitoring-automation/latest-scenario-run", projectKey);
        return (ProjectScenarioRunsDTO)this.getForm(getLastScenariosRunUrl, ProjectScenarioRunsDTO.class, new Object[0]);
    }

    public ProjectDataQualityDTO getDataQualityStatus(@Nonnull String projectKey) throws IOException {
        String getDataQualityStatusUrl = PROJECTS_BASE_URL + String.format("%s/unified-monitoring-automation/data-quality-status", projectKey);
        return (ProjectDataQualityDTO)this.getForm(getDataQualityStatusUrl, ProjectDataQualityDTO.class, new Object[0]);
    }

    public TestingStatus getTestingStatus(String projectKey, @Nullable String bundleId) throws IOException {
        String getTestingStatusURL = PROJECTS_BASE_URL + String.format("%s/scenarios/testing-status", projectKey);
        if (bundleId != null) {
            return (TestingStatus)this.getForm(getTestingStatusURL, TestingStatus.class, new Object[]{"bundleId", bundleId});
        }
        return (TestingStatus)this.getForm(getTestingStatusURL, TestingStatus.class, new Object[0]);
    }

    public TestingStatus runTestScenarios(String projectKey) throws IOException {
        String runTestScenariosUrl = PROJECTS_BASE_URL + String.format("%s/scenarios/run-test-scenarios", projectKey);
        return (TestingStatus)this.postObject(runTestScenariosUrl, TestingStatus.class, null);
    }

    public String getNodeId() throws IOException {
        String getNodeIdPath = "public/api/admin/get-node-id";
        return this.getFormToString(getNodeIdPath, new Object[0]);
    }

    public PersonalPublicAPIKey createPersonalKey(PersonalPublicAPIKey key) throws IOException {
        return (PersonalPublicAPIKey)((Object)this.postObject("public/api//admin/personal-api-keys/?forceKey=true", PersonalPublicAPIKey.class, (Object)key));
    }

    private String projectUrl(String projectKey) {
        return PROJECTS_BASE_URL + projectKey;
    }

    private String bundleUrl(String bundleId) {
        return "/bundles/imported/" + bundleId;
    }
}

